<?php
/**
 * Rating HTML
 * 
 */ 
add_filter('woocommerce_get_star_rating_html', 'finanzia_woocommerce_get_star_rating_html', 10, 3);
function finanzia_woocommerce_get_star_rating_html( $html, $rating, $count = 0 ) {
    if ( 0 < $count ) {
        /* translators: 1: rating 2: rating count */
        $data_title = sprintf( _n( 'Rated %1$s out of 5 based on %2$s customer rating', 'Rated %1$s out of 5 based on %2$s customer ratings', $count, 'finanzia' ), esc_html( $rating ),  esc_html( $count )  );
    } else {
        /* translators: %s: rating */
        $data_title = sprintf( esc_html__( 'Rated %s out of 5', 'finanzia' ),  esc_html( $rating ) );
    }
    $star_icon = finanzia_svgs_icon(['icon' => 'core/star-o','echo' => false]);
    $star_rated_icon = finanzia_svgs_icon(['icon' => 'core/star','echo' => false]);
    $star = '<span class="cms-product-star cms-star d-flex gap-5">'.$star_icon.$star_icon.$star_icon.$star_icon.$star_icon.'</span>';
    $star_rated = '<span class="cms-product-rated cms-star-rated d-flex gap-5 text-accent" style="width:' . ( ( $rating / 5 ) * 100 ) . '%">'.$star_rated_icon.$star_rated_icon.$star_rated_icon.$star_rated_icon.$star_rated_icon.'</span>';

    $html = '<div class="cms-star-rate relative" data-title="'. $data_title.'">'.$star.$star_rated.'</div>';

    return $html;
}
/**
 * Loop Product
 * Remove Page Title
 **/
add_filter('woocommerce_show_page_title', function (){ return false;});
/**
 * Loop Product
 * Remove Count
 **/
remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
/**
 * Loop Product
 * Remove Catalog Ordering
 **/
remove_action('woocommerce_before_shop_loop','woocommerce_catalog_ordering', 30);

/**
 * Loop Product
 * Add Count and Catalog Ordering
 **/
add_action('woocommerce_before_shop_loop', 'finanzia_woocommerce_count_order', 20);
function finanzia_woocommerce_count_order(){
?>
    <div class="d-flex gap-40 justify-content-between align-items-center pb-40 text-14"><?php
        woocommerce_result_count();
        woocommerce_catalog_ordering();
    ?></div>
<?php 
}
/**
 * Loop Product
 * Loop Product CSS class
 * */
add_filter('woocommerce_post_class', 'finanzia_woocommerce_post_class', 10, 2);
function finanzia_woocommerce_post_class($classes, $product){
    //$classes[] = 'cms-hover-change';
    return $classes;
}
/**
 * Loop Product 
 * Wrap by div
 * 
*/
add_action('woocommerce_before_shop_loop_item', 'finanzia_woocommerce_before_shop_loop_item', -99999);
function finanzia_woocommerce_before_shop_loop_item(){
    echo '<div class="cms-hover-change">';
}
add_action('woocommerce_after_shop_loop_item', 'finanzia_woocommerce_after_shop_loop_item', 99999);
function finanzia_woocommerce_after_shop_loop_item(){
    echo '</div>';
}
/**
 * Loop Product 
 * Remove product link
 * 
 * */
remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);
/**
 * Loop Product
 * Sale
 * */
remove_action('woocommerce_before_shop_loop_item_title','woocommerce_show_product_loop_sale_flash', 10);
add_action('finanzia_woocommerce_after_loop_thumbnail', 'woocommerce_show_product_loop_sale_flash', 1);
/**
 * Loop Product
 * Product Thumbnail
 * 
 * */
if ( ! function_exists( 'woocommerce_template_loop_product_thumbnail' ) ) {
    /**
     * Get the product thumbnail for the loop.
     */
    function woocommerce_template_loop_product_thumbnail() {
        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    ?>
        <div class="cms-products-loop-thumbs relative overflow-hidden bg-accent-lighten"><?php
            do_action('finanzia_woocommerce_before_loop_thumbnail');
                echo woocommerce_get_product_thumbnail('woocommerce_thumbnail', ['class' => '']);
            do_action('finanzia_woocommerce_after_loop_thumbnail');
    ?></div>
    <?php
    }
}
/**
 * Loop Product
 * Add to Cart button
 * 
 * */
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
add_action('finanzia_woocommerce_after_loop_thumbnail', 'woocommerce_template_loop_add_to_cart', 2);
// add to cart button classes
add_filter('woocommerce_loop_add_to_cart_args', 'finanzia_woocommerce_loop_add_to_cart_args', 10, 2);
function finanzia_woocommerce_loop_add_to_cart_args($args, $product){
    $args['class'] = implode(
        ' ',
        array_filter(
            array(
                'cms-btn-addtocart',
                'btn btn-lg btn-accent text-white btn-hover-accent-darken text-hover-white',
                'w-100',
                'product_type_' . $product->get_type(),
                $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                $product->supports( 'ajax_add_to_cart' ) && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
            )
        )
    );
    return $args;
}
// Change loop add_to_cart HTML
add_filter('woocommerce_loop_add_to_cart_link', 'finanzia_woocommerce_loop_add_to_cart_link', 10, 3);
if(!function_exists('finanzia_woocommerce_loop_add_to_cart_link')){
    function finanzia_woocommerce_loop_add_to_cart_link($button, $product, $args){
        return sprintf(
            '<div class="cms-loop-addtocart absolute bottom w-100 p-lr-40 pb-40 cms-hover-show move-up cms-transition"><a href="%1$s" data-quantity="%2$s" class="%3$s" %4$s>%5$s%6$s</a>%7$s</div>',
            esc_url( $product->add_to_cart_url() ),
            esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
            esc_attr( isset( $args['class'] ) ? $args['class'] : '' ),
            isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
            esc_html( $product->add_to_cart_text() ),
            // add to cart / loadding icon
            finanzia_svgs_icon(['icon' => 'core/cart-box','icon_size' => 20, 'class' => 'hide-on-loading', 'echo' => false])
            .finanzia_svgs_icon(['icon' => 'core/spinner','icon_size' => 20, 'class' => 'cms-spin show-on-loading', 'echo' => false]),
            // added to cart
            finanzia_woocommerce_template_loop_added_to_cart([
                'class' => 'btn btn-lg btn-accent text-white btn-hover-accent-darken text-hover-white w-100 cms-hover-move-icon-right'
            ])
        );
    }
}
/**
 * Loop Product
 * Added to cart
 * 
 */
if(!function_exists('finanzia_woocommerce_template_loop_added_to_cart')){
  function finanzia_woocommerce_template_loop_added_to_cart($args = []){
    $args = wp_parse_args($args, [
      'layout' => 'text',
      'class'  => ''
    ]);
    $classes = [
      'added_to_cart',
      $args['class']
    ];
    ob_start();
    ?>
      <a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="<?php echo finanzia_nice_class($classes); ?>" title="<?php esc_attr_e('View Cart','finanzia');?>"> 
        <?php 
            // text
            switch ($args['layout']) {
              case 'text':
                esc_html_e('View Cart','finanzia');
                break;
            }
            // icon
            finanzia_svgs_icon(['icon' => 'core/long-arrow-right','icon_size' => 17, 'class' => '', 'echo' => true])
        ?>
      </a>
    <?php
    $html =  ob_get_clean();
    return $html;
  }
}
/**
 * Loop Product
 * Product Title
 * 
 * */
if(!function_exists('woocommerce_template_loop_product_title')){
    function woocommerce_template_loop_product_title(){
        echo '<h2 class="cms-heading text-19 pt-25 pb-5 text-accent"><a href="'.get_the_permalink().'" class="cms-hover-underline">' . get_the_title() . '</a></h2>'; // phpcs:ignore 
    }
}
/**
 * Pagination
 * Custom next/prev icon
 */ 
add_filter('woocommerce_pagination_args', 'finanzia_woocommerce_pagination_args');
if(!function_exists('finanzia_woocommerce_pagination_args')){
    function finanzia_woocommerce_pagination_args($default){
        $default = array_merge($default, [
            'prev_text' => apply_filters('finanzia_pagination_prev_arrow','Prev'),
            'next_text' => apply_filters('finanzia_pagination_next_arrow','Next'),
            'type'      => 'plain',
        ]);
        return $default;
    }
}
/**
 * Single Product
 * Review count & link 
*/
if ( ! function_exists( 'woocommerce_template_single_rating' ) ) {
    /**
     * Output the product rating.
     */
    function woocommerce_template_single_rating() {
        if ( !post_type_supports( 'product', 'comments' ) || ! wc_review_ratings_enabled() ) {
            return;
        }
        global $product;
        $rating_count = $product->get_rating_count();
        $review_count = $product->get_review_count();
        $average      = $product->get_average_rating();

        $review_url =  get_the_permalink($product->get_id()).'#reviews';

        //if ( $rating_count > 0 ) : 
            ?>
            <div class="woocommerce-product-rating">
                <?php echo wc_get_rating_html( $average, $rating_count ); // WPCS: XSS ok. ?>
                <?php if ( comments_open() ) : ?>
                    <?php //phpcs:disable ?>
                    <a href="<?php echo esc_attr($review_url); ?>" class="woocommerce-review-link" rel="nofollow"><?php printf( _n( '%s Review', '%s Reviews', $review_count, 'finanzia' ), '<span class="count">' . esc_html( $review_count ) . '</span>' ); ?> / <?php esc_html_e('Add review','finanzia'); ?></a>
                    <?php // phpcs:enable ?>
                <?php endif ?>
            </div>
        <?php 
        //endif;
    }
}
/**
 * Single Product
 * Custom Add To Cart 
 * add icon
 * **/
add_filter('woocommerce_product_single_add_to_cart_text', 'finanzia_woocommerce_product_single_add_to_cart_text');
function finanzia_woocommerce_product_single_add_to_cart_text($button){
    return $button . finanzia_svgs_icon([
        'icon'      => 'core/cart-box',
        'icon_size' => 20,
        'echo'      => false,
        //'class'     => 'pl-10'
    ]);
};

/**
 * Single Product 
 * Share
 * 
 * <a class="g-social hover-effect d-none" title="<?php echo esc_attr__('Google Plus', 'finanzia'); ?>" target="_blank" href="https://plus.google.com/share?url=<?php the_permalink(); ?>"><i class="cmsi-google-plus-g"></i></a>
 * <a class="pin-social hover-effect d-none" title="<?php echo esc_attr__('Pinterest', 'finanzia'); ?>" target="_blank" href="https://pinterest.com/pin/create/button/?url=<?php echo esc_url(the_post_thumbnail_url('full')); ?>&media=&description=<?php the_title(); ?>"><i class="cmsi-pinterest"></i></a>
 * <a class="instagram-social hover-effect" title="<?php echo esc_attr__('Instagram', 'finanzia'); ?>" target="_blank"
           href="https://www.instagram.com/"><i class="cmsi-instagram"></i></a>
 * <a class="tiktok-social hover-effect" title="<?php echo esc_attr__('Tiktok', 'finanzia'); ?>" target="_blank"
           href="https://www.tiktok.com/"><i class="cmsi-tik-tok"></i></a>
 * 
*/
add_action('woocommerce_share', 'finanzia_social_share_product');
function finanzia_social_share_product(){ 
    $product_share = finanzia_get_opts('product_share', 'off', 'product_custom');
    if($product_share === 'off') return;
    $product_share_class = [
        'text-accent',
        'text-hover-white',
        'bg-grey',
        'bg-hover-accent',
        'box-40 circle',
        'text-20'
    ];
    ?>
    <div class="cms-product-share d-flex align-items-center gap-15">
        <?php // Facebook ?>
        <a class="fb-social <?php echo finanzia_nice_class($product_share_class); ?>" title="<?php echo esc_attr__('Facebook', 'finanzia'); ?>" target="_blank"
           href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><?php 
           include get_template_directory().'/assets/svgs/core/facebook.svg';
        ?></a>
        <?php // Twitter ?>
        <a class="tw-social <?php echo finanzia_nice_class($product_share_class); ?>" title="<?php echo esc_attr__('Twitter', 'finanzia'); ?>" target="_blank"
           href="https://twitter.com/home?status=<?php the_permalink(); ?>"><?php 
           include get_template_directory().'/assets/svgs/core/twitter.svg';
        ?></a>
        <?php // LinkedIn ?>
        <a class="li-social <?php echo finanzia_nice_class($product_share_class); ?>" title="<?php echo esc_attr__('LinkedIn', 'finanzia'); ?>" target="_blank"
               href="http://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&title=<?php the_title(); ?>"><?php 
           include get_template_directory() . '/assets/svgs/core/linkedin.svg'; 
        ?></a>
    </div>
    <?php
}

/**
 * 
 * Single Product Tabs
 * 
 * Remove tab heading
 * 
 * */
add_filter('woocommerce_product_description_heading','finanzia_product_tab_heading');
add_filter('woocommerce_product_additional_information_heading','finanzia_product_tab_heading');
if(!function_exists('finanzia_product_tab_heading')){
    function finanzia_product_tab_heading(){
        return false;
    }
}
/**
 * Single Product Nav
 * 
 */ 
function finanzia_product_nav(){
    global $post;
    $previous = (is_attachment()) ? get_post($post->post_parent) : get_adjacent_post(false, '', true);
    $next = get_adjacent_post(false, '', false);

    if (!$next && !$previous) {
        return;
    }
    ?>
    <?php
    $next_post = get_next_post();
    $previous_post = get_previous_post();
    if (!empty($next_post) || !empty($previous_post)) { ?>
        <div class="product-previous-next">
            <?php if (is_a($previous_post, 'WP_Post') && get_the_title($previous_post->ID) != '') { ?>
                <a class="nav-link-prev" href="<?php echo esc_url(get_permalink($previous_post->ID)); ?>"><i
                            class="cmsi-long-arrow-left"></i></a>
            <?php } ?>
            <?php if (is_a($next_post, 'WP_Post') && get_the_title($next_post->ID) != '') { ?>
                <a class="nav-link-next" href="<?php echo esc_url(get_permalink($next_post->ID)); ?>"><i
                            class="cmsi-long-arrow-right"></i></a>
            <?php } ?>
        </div>
    <?php }
}
/**
 * Single Product
 * Review callback function 
 * make it callback same as default blog review
*/
remove_action('woocommerce_review_meta','woocommerce_review_display_meta', 10);
remove_action('woocommerce_review_comment_text','woocommerce_review_display_comment_text', 10);
if(!function_exists('finanzia_woocommerce_product_review_list_args')){
    add_filter('woocommerce_product_review_list_args', 'finanzia_woocommerce_product_review_list_args');
    function finanzia_woocommerce_product_review_list_args($args){
        $args['style']      = 'div';
        $args['short_ping'] = 'true';
        $args['callback']   = 'finanzia_comment_list';
        return $args;
    }
}
/**
 * Single Product
 * Comment form Args
 * 
*/
if(!function_exists('finanzia_woocommerce_product_review_comment_form_args')){
    add_filter('woocommerce_product_review_comment_form_args', 'finanzia_woocommerce_product_review_comment_form_args');
    function finanzia_woocommerce_product_review_comment_form_args($comment_form){
        $comment_form = finanzia_comment_form_args();
        return $comment_form;
    }
}
/**
 * Single Product
 * Upsell, Cross Sell, Related
 *
 */
// related
add_filter('woocommerce_output_related_products_args', function($args){
    $args['posts_per_page'] = 4;
    $args['columns'] = 4;
    return $args;
});
// upsell
add_filter('woocommerce_upsells_columns', function(){ return 4;});
add_filter('woocommerce_upsells_total', function(){ return 4;});
// Cross sell
add_filter('woocommerce_cross_sells_columns' , function(){ return 4;});
add_filter('woocommerce_cross_sells_total' , function(){ return 4;});

/**
 * Single Product 
 * Added to Cart Message
 * 
 * */
add_filter('wc_add_to_cart_message_html', 'finanzia_wc_add_to_cart_message_html', 10, 3);
if(!function_exists('finanzia_wc_add_to_cart_message_html')){
    function finanzia_wc_add_to_cart_message_html($message, $products, $show_qty ){
        $titles = array();
        $count  = 0;

        if ( ! is_array( $products ) ) {
            $products = array( $products => 1 );
            $show_qty = false;
        }

        if ( ! $show_qty ) {
            $products = array_fill_keys( array_keys( $products ), 1 );
        }

        foreach ( $products as $product_id => $qty ) {
            /* translators: %s: product name */
            $titles[] = apply_filters( 'woocommerce_add_to_cart_qty_html', ( $qty > 1 ? absint( $qty ) . ' &times; ' : '' ), $product_id ) . apply_filters( 'woocommerce_add_to_cart_item_name_in_quotes', sprintf( _x( '&ldquo;%s&rdquo;', 'Item name in quotes', 'finanzia' ), strip_tags( get_the_title( $product_id ) ) ), $product_id );
            $count   += $qty;
        }

        $titles = array_filter( $titles );
        /* translators: %s: product name */
        $added_text = sprintf( _n( '%s has been added to your cart.', '%s have been added to your cart.', $count, 'finanzia' ), wc_format_list_of_items( $titles ) );

        // Output success messages.
        $wp_button_class = 'cms-single-viewcart btn btn-accent text-white btn-hover-accent-darken text-hover-white order-last cms-hover-move-icon-right';
        // icon
        ob_start();
            finanzia_svgs_icon(['icon' => 'core/long-arrow-right', 'icon_size' => 17]);
        $btn_icon = ob_get_clean();

        if ( 'yes' === get_option( 'woocommerce_cart_redirect_after_add' ) ) {
            $message   = sprintf( '%s <a href="%s" tabindex="1" class="%s">%s%s</a>', 
                esc_html( $added_text ),
                esc_url( $return_to ), 
                esc_attr( $wp_button_class ), 
                esc_html__( 'Continue shopping', 'finanzia' ),
                $btn_icon
            );
        } else {
            $message = sprintf( '%s <a href="%s" tabindex="1" class="%s">%s%s</a>', 
                esc_html( $added_text ),
                esc_url( wc_get_cart_url() ), 
                esc_attr( $wp_button_class ),
                esc_html__( 'View cart', 'finanzia' ), 
                $btn_icon
            );
        }
        return $message;
    }
}
/**
 * Loop 
 * 
 * Quantity Form
 * 
**/
add_action( 'woocommerce_before_quantity_input_field', 'finanzia_woocommerce_before_quantity_input_field', 99999);
if(!function_exists('finanzia_woocommerce_before_quantity_input_field')){
    function finanzia_woocommerce_before_quantity_input_field(){
?>  
    <span class="cms-qty-act cms-qty-down"></span>
<?php
    }
}
add_action( 'woocommerce_after_quantity_input_field', 'finanzia_woocommerce_after_quantity_input_field', -99999 );
if(!function_exists('finanzia_woocommerce_after_quantity_input_field')){
    function finanzia_woocommerce_after_quantity_input_field(){
?>  
    <span class="cms-qty-act cms-qty-up"></span>
<?php
    } // close .cms-quantity , prioty 99999/-99999 to make sure just wrap input box
}

/**
 * Checkout Page
 * **/
add_action('woocommerce_checkout_before_order_review_heading', function(){echo '<div class="cms-orderreview-wrap"><div class="cms-orderreview cms-sticky">';}, -9999);
add_action('woocommerce_checkout_after_order_review', function(){echo '</div></div>';}, 9999);

/**
 * Checkout Page
 * custom Place Order button
 * 
 * */
add_filter('woocommerce_order_button_html', 'finanzia_woocommerce_order_button_html');
if(!function_exists('finanzia_woocommerce_order_button_html')){
    function finanzia_woocommerce_order_button_html($button){
        // The text of the button
        $order_button_text = apply_filters( 'woocommerce_order_button_text', esc_html__( 'Place order', 'finanzia' ) );
        // button
        $button = '<button type="submit" class="btn btn-accent text-white btn-hover-accent-darken text-hover-white w-100" name="woocommerce_checkout_place_order" id="place_order" value="' . esc_attr( $order_button_text ) . '" data-value="' . esc_attr( $order_button_text ) . '">' . esc_html( $order_button_text ) . '</button>';

        return $button;
    }
}

/**
 * Mini Cart
 * Change product thumbnail size
 * 
 * **/
function finanzia_mini_cart_item_thumbnail( $thumb, $cart_item, $cart_item_key ) {
    $_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
    return $_product->get_image( apply_filters('finanzia_widget_product_thumbnail_size', 'woocommerce_gallery_thumbnail') );
}
add_filter( 'woocommerce_cart_item_thumbnail', 'finanzia_mini_cart_item_thumbnail', 10, 3 );
add_filter('finanzia_widget_product_thumbnail_size', function(){ return 'woocommerce_gallery_thumbnail';});
/**
 * Mini Cart
 * View Cart Button
 * */
remove_action('woocommerce_widget_shopping_cart_buttons','woocommerce_widget_shopping_cart_button_view_cart');
if ( ! function_exists( 'woocommerce_widget_shopping_cart_button_view_cart' ) ) {

    /**
     * Output the view cart button.
     */
    function woocommerce_widget_shopping_cart_button_view_cart() {
        $wp_button_class = wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '';
        echo '<a href="' . esc_url( wc_get_cart_url() ) . '" class="btn btn-lg btn-primary text-white btn-hover-accent text-hover-white btn-viewcart w-100 cms-hover-move-icon-up">' . esc_html__( 'View cart', 'finanzia' ) .finanzia_svgs_icon(['icon' => 'core/arrow-right', 'class' => 'text-10', 'echo' => false]). '</a>';
    }
}
/**
 * Mini Cart
 * Checkout Button
 * */
if ( ! function_exists( 'woocommerce_widget_shopping_cart_proceed_to_checkout' ) ) {

    /**
     * Output the proceed to checkout button.
     */
    function woocommerce_widget_shopping_cart_proceed_to_checkout() {
        echo '<a href="' . esc_url( wc_get_checkout_url() ) . '" class="btn btn-lg btn-accent text-white btn-hover-accent-darken text-hover-white btn-checkout w-100 cms-hover-move-icon-right">' . esc_html__( 'Proceed To Checkout', 'finanzia' ) .finanzia_svgs_icon(['icon' => 'core/long-arrow-right', 'icon_size' => 17, 'echo' => false]). '</a>';
    }
}
/**
 * Mini Cart
 * Sub total
 * */
if ( ! function_exists( 'woocommerce_widget_shopping_cart_subtotal' ) ) {
    /**
     * Output to view cart subtotal.
     *
     * @since 3.7.0
     */
    function woocommerce_widget_shopping_cart_subtotal() {
    ?>
        <div class="cms-mini-cart-subtotal d-flex gap-15 text-19 font-700 text-heading">
            <div class="title"><?php echo esc_html__( 'Total:', 'finanzia' ) ?></div>
            <div class="total"><?php echo WC()->cart->get_cart_subtotal(); ?></div>
        </div>
    <?php
    }
}