<?php
/**
 * Template part for displaying default header layout
 */
?>
<header id="cms-header-wrap" class="<?php echo finanzia_header_wrap_classes(); ?>">
    <div id="cms-header" class="<?php echo finanzia_header_classes(); ?>">
         <?php finanzia_header_top(); ?>
        <div class="<?php echo finanzia_header_container_classes('d-flex gap-30 justify-content-between'); ?>">
            <?php 
            // logo
            get_template_part('template-parts/header/header-branding', '', [
                'before' => '<div class="site-branding flex-auto d-flex justify-content-start">',
                'after'  => '</div>',
            ]);
            // Navigation 
            get_template_part('template-parts/header/header-menu', '',[
                'before' => '<nav class="site-navigation site-navigation-dropdown justify-content-end flex-basic d-flex">', 
                'after'  => '</nav>' 
            ]);
            ?>
            <div class="<?php echo finanzia_header_tools_classes(['class' => 'site-tools flex-auto d-flex gap-20 justify-content-end align-items-center']); ?>">
                <?php
                // Button 01
                ob_start();
                    echo '<span class="order-last text-10 lh-0">';
                    include get_template_directory() . '/assets/svgs/core/arrow-right.svg';
                    echo '</span>';
                $btn_icon_1 = ob_get_clean();
                // icon mobile
                ob_start();
                 echo '<span class="order-last text-10 lh-0">';
                    include get_template_directory() . '/assets/svgs/core/email.svg';
                    echo '</span>';
                $btn_icon_1_mobile = ob_get_clean();
                finanzia_header_button_render([
                    'wrap_class' => '', //cms-hidden-smobile
                    'class'      => 'h-btn1 btn btn-smd btn-accent text-white btn-hover-primary text-hover-white cms-hover-move-icon-up',
                    'data'       => [
                        'default'     => 'btn-accent--text-white',
                        'transparent' => (finanzia_get_opts('header_transparent', 'off', 'header_custom') === 'on') ? 'btn-accent--text-white' : 'btn-accent--text-white'
                    ],
                    'icon'        => $btn_icon_1,
                    'icon_mobile' => $btn_icon_1_mobile
                ]);
                
                // Button 02
                ob_start();
                    echo '<span class="order-last text-10 lh-0">';
                    include get_template_directory() . '/assets/svgs/core/arrow-right.svg';
                    echo '</span>';
                $btn_icon_2 = ob_get_clean();
                // icon mobile
                ob_start();
                 echo '<span class="order-last text-10 lh-0">';
                    include get_template_directory() . '/assets/svgs/core/arrow-right.svg';
                    echo '</span>';
                $btn_icon_2_mobile = ob_get_clean();
                finanzia_header_button_render([
                    'name'       => 'h_btn2', 
                    'wrap_class' => '', //cms-hidden-smobile
                    'class'      => 'h-btn2 btn btn-smd btn-primary text-white btn-hover-accent text-hover-white cms-hover-move-icon-up',
                    'data'       => [
                        'default'     => 'btn-primary--text-white',
                        'transparent' => (finanzia_get_opts('header_transparent', 'off', 'header_custom') === 'on') ? 'btn-white--text-primary' : 'btn-primary--text-white'
                    ],
                    'icon'        => $btn_icon_2,
                    'icon_mobile' => $btn_icon_2_mobile
                ]);
                // Phone
                finanzia_header_phone_render2();
                // Mail
                finanzia_header_mail_render(['class' => 'menu-color cms-hover-underline']);
                // Currency Switch
                finanzia_header_woocs([
                    'before' => '<div class="site-header-item">',
                    'after'  => '</div>'
                ]);
                // Language Switch
                finanzia_header_language_switcher([
                    'before' => '<div class="site-header-item">',
                    'after'  => '</div>'
                ]);
                // Login
                finanzia_header_login();
                // Search icon
                finanzia_header_search();
                // Wishlist
                finanzia_header_wishlist();
                // Compare
                finanzia_header_compare();
                // Cart icon
                finanzia_header_cart();
                // Side Nav
                finanzia_header_side_nav_render();
                // Mobile menu
                finanzia_open_mobile_menu();
                ?>
            </div>
        </div>
    </div>
</header>