<?php
/**
 * Template part for displaying default header layout
 */
ob_start();
    // Button 01
    finanzia_header_button_render([
        'class'      => 'cms-hidden-mobile-menu h-btn1 btn-menu-mobile cms-hover-move-icon-right btn btn-sm btn-accent text-white btn-hover-accent-darken text-hover-white',
        'data'       => [
            'default'     => 'btn-accent--text-white--btn-hover-accent-darken',
            'transparent' => (finanzia_get_opts('header_transparent', 'off', 'header_custom') === 'on') ? 'btn-white--text-primary--btn-hover-accent-darken--text-hover-white' : 'btn-accent--text-white--btn-hover-accent-darken'
        ],
        'icon'        => 'core/long-arrow-right',
        'icon_mobile' => '',
        'icon_size'  => '17'
    ]);
    // Button 02
    finanzia_header_button_render([
        'name'       => 'h_btn2',
        'class'      => 'cms-hidden-mobile-menu h-btn2 btn-menu-mobile cms-hover-move-icon-right btn btn-sm btn-primary text-white btn-hover-accent text-hover-white',
        'data'       => [
            'default'     => 'btn-primary--text-white--btn-hover-accent--text-hover-white',
            'transparent' => (finanzia_get_opts('header_transparent', 'off', 'header_custom') === 'on') ? 'btn-white--text-primary--btn-hover-accent-text-hover-white' : 'btn-primary--text-white--btn-hover-accent--text-hover-white'
        ],
        'icon'        => 'core/arrow-right',
        'icon_mobile' => ''  
    ]);
    // Phone
    finanzia_header_phone_render(['class' => 'cms-hidden-mobile-menu']);
    // Mail
    finanzia_header_mail_render(['class' => 'cms-hidden-mobile-menu menu-color cms-hover-underline font-700']);
$desktop_menu_attrs = ob_get_clean();
?>
<?php finanzia_header_top(); ?>
<header id="cms-header-wrap" class="<?php echo finanzia_header_wrap_classes(); ?>">
    <div id="cms-header" class="<?php echo finanzia_header_classes(); ?>">
        <div class="<?php echo finanzia_header_container_classes('d-flex gap-30 justify-content-between'); ?>">
            <?php 
            // logo
            get_template_part('template-parts/header/header-branding', '', [
                'before' => '<div class="site-branding flex-auto d-flex justify-content-center pl-mobile-menu-20">',
                'after'  => '</div>',
            ]);
            ?>
            <div id="cms-header-left-show-menu" class="cms-header-left-show-menu d-flex justify-content-center align-items-center relative cms-hidden-mobile-menu menu-color"><?php 
                finanzia_svgs_icon([
                    'icon'      => 'side-menu',
                    'icon_size' => 8,
                    'icon_class'     => 'open'
                ]);
                finanzia_svgs_icon([
                    'icon'      => 'close',
                    'icon_size' => 16,
                    'icon_class'     => 'close'
                ]);
            ?></div>
            <?php
            // Navigation 
            get_template_part('template-parts/header/header-menu', '',[
                'before' => '<nav class="site-navigation site-navigation-dropdown flex-basic">', 
                'after'  => $desktop_menu_attrs.'</nav>' 
            ]);
            ?>
            <div class="<?php echo finanzia_header_tools_classes(['class' => 'flex-auto d-flex gap-20 justify-content-end align-items-center pl-mobile-menu-20 pr-mobile-menu-20']); ?>">
                <?php
                // Button 01
                finanzia_header_button_render([
                    'class'      => 'cms-hidden-desktop-menu h-btn1 btn-menu-mobile cms-hover-move-icon-right btn btn-sm btn-accent text-white btn-hover-accent-darken text-hover-white',
                    'data'       => [
                        'default'     => 'btn-accent--text-white--btn-hover-accent-darken',
                        'transparent' => (finanzia_get_opts('header_transparent', 'off', 'header_custom') === 'on') ? 'btn-white--text-primary--btn-hover-accent-darken--text-hover-white' : 'btn-accent--text-white--btn-hover-accent-darken'
                    ],
                    'icon'        => 'core/long-arrow-right',
                    'icon_mobile' => '',
                    'icon_size'  => '17'
                ]);
                // Button 02
                finanzia_header_button_render([
                    'name'       => 'h_btn2',
                    'class'      => 'cms-hidden-desktop-menu h-btn2 btn-menu-mobile cms-hover-move-icon-right btn btn-sm btn-primary text-white btn-hover-accent text-hover-white',
                    'data'       => [
                        'default'     => 'btn-primary--text-white--btn-hover-accent--text-hover-white',
                        'transparent' => (finanzia_get_opts('header_transparent', 'off', 'header_custom') === 'on') ? 'btn-white--text-primary--btn-hover-accent-text-hover-white' : 'btn-primary--text-white--btn-hover-accent--text-hover-white'
                    ],
                    'icon'        => 'core/arrow-right',
                    'icon_mobile' => ''  
                ]);
                // Phone
                finanzia_header_phone_render(['class'=>'cms-hidden-desktop-menu']);
                // Mail
                finanzia_header_mail_render(['class' => 'cms-hidden-desktop-menu menu-color cms-hover-underline font-700']);
                // Currency Switch
                finanzia_header_woocs([
                    'before' => '<div class="site-header-item">',
                    'after'  => '</div>'
                ]);
                // Language Switch
                finanzia_header_language_switcher([
                    'before' => '<div class="cms-hidden-desktop-menu site-header-item site-header-language font-700">',
                    'after'  => '</div>'
                ]);
                // Login
                finanzia_header_login();
                // Search icon
                finanzia_header_search([
                    'text' => ''
                ]);
                // Wishlist
                finanzia_header_wishlist();
                // Compare
                finanzia_header_compare();
                // Cart icon
                finanzia_header_cart();
                // Social
                finanzia_header_social_render([
                    'show_text'  => false,
                    'item_class' => 'menu-color cms-hidden-mobile-menu',
                    'before' => '',
                    'after'  => ''
                ]);
                // Side Nav
                finanzia_header_side_nav_render();
                
                // Mobile menu
                finanzia_open_mobile_menu();
                ?>
            </div>
        </div>
    </div>
</header>