<?php
/**
 * Template part for displaying default header layout
 */
?>
<header id="cms-header-wrap" class="<?php echo finanzia_header_wrap_classes(); ?>">
    <div id="cms-header" class="<?php echo finanzia_header_classes('bg-transparent'); ?>">
        <?php finanzia_header_top(); ?>
        <div class="<?php echo finanzia_header_container_classes('d-flex gap-5 justify-content-between align-items-center p-20'); ?>">
            <?php 
            // logo
            get_template_part('template-parts/header/header-branding', '', [
                'before' => '<div class="site-branding flex-basic d-flex justify-content-between gap-20 flex-nowrap bg-white p-tb-20 p-lr-30 cms-radius-12 text-primary">',
                'after'  => '<span class="font-500 text-end lh-1 m-tb-n3 d-block" style="max-width:75px;">'.esc_html__('Research Center', 'finanzia').'</span></div>',
            ]);
            // Navigation 
            get_template_part('template-parts/header/header-menu', '', [
                'before'     => '<nav class="site-navigation site-navigation-dropdown flex-auto d-flex justify-content-end">', 
                'after'      => '</nav>',
                'menu_class' => 'cms-header-menu-5'
            ]);
            ?>
            <div class="<?php echo finanzia_header_tools_classes(['class' => 'flex-auto d-flex gap-5']); ?>">
                <?php
                // Phone
                finanzia_header_phone_render();
                // Mail
                finanzia_header_mail_render(['class' => 'menu-color cms-hover-underline font-700']);
                // Currency Switch
                finanzia_header_woocs([
                    'before' => '<div class="site-header-item">',
                    'after'  => '</div>'
                ]);
                // Language Switch
                finanzia_header_language_switcher([
                    'before' => '<div class="site-header-item site-header-language font-700">',
                    'after'  => '</div>'
                ]);
                // Login
                finanzia_header_login([
                    'icon_class' => 'box-67 box-mobile-menu-32 cms-radius-12 cms-radius-mobile-menu-4 menu-color cms-transition cms-backdrop-1 cms-hover-backdrop-3'
                ]);
                // Search icon
                finanzia_header_search([
                    'icon_class' => 'box-67 box-mobile-menu-32 cms-radius-12 cms-radius-mobile-menu-4 menu-color cms-transition cms-backdrop-1 cms-hover-backdrop-3'
                ]);
                // Wishlist
                finanzia_header_wishlist([
                    'icon_class' => 'box-67 box-mobile-menu-32 cms-radius-12 cms-radius-mobile-menu-4 menu-color cms-transition cms-backdrop-1 cms-hover-backdrop-3'
                ]);
                // Compare
                finanzia_header_compare([
                    'icon_class' => 'box-67 box-mobile-menu-32 cms-radius-12 cms-radius-mobile-menu-4 menu-color cms-transition cms-backdrop-1 cms-hover-backdrop-3'
                ]);
                // Cart icon
                finanzia_header_cart([
                    'icon_class' => 'box-67 box-mobile-menu-32 cms-radius-12 cms-radius-mobile-menu-4 menu-color cms-transition cms-backdrop-1 cms-hover-backdrop-3'
                ]);
                // Side Nav
                finanzia_header_side_nav_render();
                // Button 01
                finanzia_header_button_render([
                    'class'      => 'h-btn1 btn-menu-mobile cms-hover-move-icon-up btn btn-lg btn-accent text-white btn-hover-accent-darken text-hover-white',
                    'data'       => [
                        'default'     => 'btn-accent--text-white',
                        'transparent' => (finanzia_get_opts('header_transparent', 'off', 'header_custom') === 'on') ? 'btn-accent--text-white--btn-hover-white--text-hover-primary' : 'btn-accent--text-white'
                    ],
                    'icon'        => 'core/arrow-right',
                    'icon_mobile' => '',
                    'style'       => '--cms-btn-padding:0 30px;'
                ]);
                // Button 02
                finanzia_header_button_render([
                    'name'       => 'h_btn2',
                    'class'      => 'h-btn2 btn-menu-mobile cms-hover-move-icon-up btn btn-lg btn-primary text-white btn-hover-accent text-hover-white',
                    'data'       => [
                        'default'     => 'btn-primary--text-white',
                        'transparent' => (finanzia_get_opts('header_transparent', 'off', 'header_custom') === 'on') ? 'btn-white--text-primary' : 'btn-primary--text-white'
                    ],
                    'icon'        => 'core/arrow-right',
                    'icon_mobile' => '',
                    'style'       => '--cms-btn-padding:0 30px;'
                ]);
                // Social
                finanzia_header_social_render([
                    'before' => '<div class="site-header-social d-flex gapX-20 p-lr-50 p-lr-mobile-menu-20 cms-header-height bdr-b-1 bdr-divider cms-hidden-mobile-menu">',
                    'after'  => '</div>'
                ]);
                // Mobile menu
                finanzia_open_mobile_menu();
                ?>
            </div>
        </div>
    </div>
</header>