<?php
/**
 * Template part for displaying default header layout
 */
?>
<?php finanzia_header_top(); ?>
<header id="cms-header-wrap" class="<?php echo finanzia_header_wrap_classes(); ?>">
    <div id="cms-header" class="<?php echo finanzia_header_classes(); ?>">
        <div class="<?php echo finanzia_header_container_classes('d-flex gap-30 justify-content-between'); ?>">
            <?php 
            // logo
            get_template_part('template-parts/header/header-branding', '', [
                'before' => '<div class="site-branding flex-auto d-flex justify-content-start">',
                'after'  => '</div>',
            ]);
            // Navigation 
            get_template_part('template-parts/header/header-menu', '',[
                'before' => '<nav class="site-navigation site-navigation-dropdown justify-content-end flex-basic d-flex">', 
                'after'  => '</nav>' 
            ]);
            ?>
            <div class="<?php echo finanzia_header_tools_classes(['class' => 'flex-auto d-flex gap-20 justify-content-end align-items-center']); ?>">
                <?php
                // Button 01
                finanzia_header_button_render([
                    'class'      => 'h-btn1 btn-menu-mobile cms-hover-move-icon-right btn btn-sm btn-accent text-white btn-hover-accent-darken text-hover-white mr-10 mr-mobile-menu-0',
                    'data'       => [
                        'default'     => 'btn-accent--text-white--btn-hover-accent-darken--text-hover-white',
                        'transparent' => (finanzia_get_opts('header_transparent', 'off', 'header_custom') === 'on') ? 'btn-white--text-accent--btn-hover-accent-darken--text-hover-white' : 'btn-accent--text-white--btn-hover-accent-darken--text-hover-white'
                    ],
                    'icon'        => 'core/long-arrow-right',
                    'icon_mobile' => '',
                    'icon_size'  => '17'
                ]);
                // Button 02
                finanzia_header_button_render([
                    'name'       => 'h_btn2',
                    'class'      => 'h-btn2 btn-menu-mobile cms-hover-move-icon-right btn btn-sm btn-primary text-white btn-hover-accent text-hover-white mr-10 mr-mobile-menu-0',
                    'data'       => [
                        'default'     => 'btn-primary--text-white--btn-hover-accent--text-hover-white',
                        'transparent' => (finanzia_get_opts('header_transparent', 'off', 'header_custom') === 'on') ? 'btn-white--text-primary--btn-hover-accent-text-hover-white' : 'btn-primary--text-white--btn-hover-accent--text-hover-white'
                    ],
                    'icon'        => 'core/arrow-right',
                    'icon_mobile' => ''  
                ]);
                // Phone
                finanzia_header_phone_render();
                // Mail
                finanzia_header_mail_render(['class' => 'menu-color cms-hover-underline font-700']);
                // Currency Switch
                finanzia_header_woocs([
                    'before' => '<div class="site-header-item">',
                    'after'  => '</div>'
                ]);
                // Language Switch
                finanzia_header_language_switcher([
                    'before' => '<div class="site-header-item site-header-language font-700">',
                    'after'  => '</div>'
                ]);
                // Login
                finanzia_header_login();
                // Wishlist
                finanzia_header_wishlist();
                // Compare
                finanzia_header_compare();
                // Cart icon
                finanzia_header_cart();
                // Search icon
                finanzia_header_search([
                    'text' => ''
                ]);
                // Social
                finanzia_header_social_render([
                    'before' => '<div class="site-header-social d-flex gapX-20 p-lr-50 p-lr-mobile-menu-20 cms-header-height bdr-b-1 bdr-divider cms-hidden-mobile-menu">',
                    'after'  => '</div>'
                ]);
                // Side Nav
                finanzia_header_side_nav_render();
                
                // Mobile menu
                finanzia_open_mobile_menu();
                ?>
            </div>
        </div>
    </div>
</header>