<?php
if (class_exists('Theme_Core_Options')) {
    // Set Location of Theme Options Menu
    add_filter('tco_page_parent', 'finanzia_tco_parent_page');
    function finanzia_tco_parent_page()
    {
        $current_theme = wp_get_theme();
        if (is_child_theme()) {
            $current_theme = $current_theme->parent();
        }
        return $current_theme->get('TextDomain');
    }

    // Set Theme Options Name
    add_filter('tco_theme_options_name', 'finanzia_tco_theme_options_name');
    add_filter('swa_ie_options_name', 'finanzia_tco_theme_options_name');
    function finanzia_tco_theme_options_name()
    {
        $opt_name = finanzia_get_opt_name();
        return $opt_name;
    }

    add_filter('tco_theme_options_args', 'finanzia_theme_options_args');

    function finanzia_theme_options_args()
    {
        $default        = false;
        $default_value  = '1';
        $default_layout = '1';
        $default_on     = 'on';
        $default_off    = 'off';
        $default_width  = 'container';
        $default_header_width  = 'container-fluid';
        $custom_opts    = false;

        $general     = include get_template_directory() . '/inc/theme-options/args/general.php';
        $header_top  = include get_template_directory() . '/inc/theme-options/args/header-top.php';
        $header      = include get_template_directory() . '/inc/theme-options/args/header.php';
        $page_title  = include get_template_directory() . '/inc/theme-options/args/page-title.php';
        $content     = include get_template_directory() . '/inc/theme-options/args/content.php';
        $sidebar     = include get_template_directory() . '/inc/theme-options/args/sidebar.php';
        $shop        = include get_template_directory() . '/inc/theme-options/args/shop.php';
        $footer      = include get_template_directory() . '/inc/theme-options/args/footer.php';
        $api         = include get_template_directory() . '/inc/theme-options/args/api.php';
        $page_404    = include get_template_directory() . '/inc/theme-options/args/404-page.php';
        $popup       = include get_template_directory() . '/inc/theme-options/args/popup.php';

        $args = [
            'general'     => $general,
            'header_top'  => $header_top,
            'header'      => $header,
            'page-title'  => $page_title,
            'content'     => $content,
            'sidebar'     => $sidebar,  
            'footer'      => $footer,
            '404-page'    => $page_404,
        ];
        if(class_exists('WooCommerce')){
            $args['shop'] =  $shop;
        }
        $args['popup'] = $popup;
        $args['api'] = $api;

        return $args;
    }
}
/**
 * Color list from theme configs
 * 
 * **/
function finanzia_color_list_opts($name = []){
    $colors = (array) finanzia_configs($name);
    $opts = [];
    foreach ($colors as $key => $value) {
        $opts[$key] = sprintf('%1$s %2$s', ucfirst($key), '<div class="label-desc">'.esc_html__('Default:','finanzia').' '.$value.'</div>');
    }
    return $opts;
}
/**
 * Get post thumbnail as image options
 * @return array
 *
*/
function finanzia_list_post_thumbnail($post_type = 'post', $default = false, $args = []){
    $layouts = [];
    if($default){
        $layouts['-1'] = get_template_directory_uri() . '/assets/images/default-opt/default.jpg';
        $layouts['none'] = get_template_directory_uri() . '/assets/images/default-opt/none.jpg';
    }
    $layouts = array_unique($layouts + $args);
    $posts = get_posts(array('post_type' => $post_type,'posts_per_page' => '-1'));
    
    foreach($posts as $post){
        $layouts[$post->ID] = wp_get_attachment_image_url(get_post_thumbnail_id($post->ID), 'full');
    }
    return $layouts;
}
/**
 * Typography
**/
if(!function_exists('finanzia_typography_opts')){
    function finanzia_typography_opts($args = []){
        $default = [
            'body_font' => [
                'type'        => Theme_Core_Options::SELECT_FIELD,
                'title'       => esc_html__('Body Font', 'finanzia'),
                'options'     => [
                    'default' => esc_html__('Default', 'finanzia'),
                    'custom'  => esc_html__('Custom', 'finanzia'),
                ],
                'default'     => 'default'
            ],
            'body_font_typo' => [
                'type'     => Theme_Core_Options::TYPOGRAPHY_FIELD,
                'title'    => esc_html__('Body Custom Font', 'finanzia'),
                'subtitle' => esc_html__('This will be the default font of your website.', 'finanzia'),
                'required' => [
                    'body_font',
                    '=',
                    'custom'
                ],
                'font_backup'  => false,
                'font_subsets' => false,
                'font_style'   => true, 
                'line_height'  => false,
                'font_size'    => false,
                'color'        => false,
                'output'       => [
                    '.dummy-body'
                ]
            ],
            'heading_font' => [
                'type'    => Theme_Core_Options::SELECT_FIELD,
                'title'   => esc_html__('Heading Default Font', 'finanzia'),
                'options' => [
                    'default' => esc_html__('Default', 'finanzia'),
                    'custom'  => esc_html__('Custom', 'finanzia'),
                ],
                'default' => 'default'
            ],
            'heading_font_typo' => [
                'type'     => Theme_Core_Options::TYPOGRAPHY_FIELD,
                'title'    => esc_html__('Heading', 'finanzia'),
                'subtitle' => esc_html__('This will be the default font for all Heading tags of your website.', 'finanzia'),
                'output'   => [
                    '.dummy-heading'
                ],
                'required' => [
                    'heading_font',
                    '=',
                    'custom',
                ],
                'font_backup'  => false,
                'font_subsets' => false,
                'font_style'   => true,
                'line_height'  => false,
                'font_size'    => false,
                'color'        => false,    
            ]
        ];
        return [
            'title'  => esc_html__('Typographys', 'finanzia'),
            'fields' => array_merge($default, $args)
        ];
    }
}
if(!function_exists('finanzia_general_advanced_opts')){
    function finanzia_general_advanced_opts($args = []){
        $default = [
            'body_top_space' => [
                'type'     => Theme_Core_Options::SLIDER_FIELD,
                'title'    => esc_html__('Body Top Space', 'finanzia')
            ]
        ];
        return [
            'title'  => esc_html__('Advanced', 'finanzia'),
            'fields' => array_merge($default, $args)
        ];
    }
}
/**
 * ON/ OFF option
 * 
 * */
function finanzia_theme_on_off_opts($args = []){
    $args = wp_parse_args($args, [
        'default'       => false,
        'default_value' => 'off',
        'title'         => esc_html__('On/Off', 'finanzia'),
        'subtitle'      => '',
        'required'      => ''
    ]);
    $opts = [
        'on' => esc_html__('On', 'finanzia'),
        'off' => esc_html__('Off', 'finanzia'),
    ];
    if($args['default']) {
        $opts['-1'] = esc_html__('Default','finanzia');
        $args['default_value'] = '-1';
    }
    return [
        'type'     => Theme_Core_Options::BUTTON_SET_FIELD,
        'title'    => $args['title'],
        'subtitle' => $args['subtitle'],
        'options'  => $opts,
        'default'  => $args['default_value'],
        'required' => $args['required']
    ];
}
/**
 * Show/ Hide option
 * 
 * */
function finanzia_theme_show_hide_opts($args = []){
    $args = wp_parse_args($args, [
        'default'       => false,
        'default_value' => 'off',
        'title'         => esc_html__('Show/Hide', 'finanzia'),
        'subtitle'      => '',
        'required'      => ''    
    ]);
    $opts = [
        'on' => esc_html__('Show', 'finanzia'),
        'off' => esc_html__('Hide', 'finanzia'),
    ];
    if($args['default']) {
        $opts['-1'] = esc_html__('Default','finanzia');
        $args['default_value'] = '-1';
    }
    return [
        'type'     => Theme_Core_Options::BUTTON_SET_FIELD,
        'title'    => $args['title'],
        'subtitle' => $args['subtitle'],
        'options'  => $opts,
        'default'  => $args['default_value'],
        'required' => $args['required']
    ];
}
/**
 * Select Options
 * 
 * */
if(!function_exists('finanzia_select_opts')){
    function finanzia_select_opts($args = []){
        $args = wp_parse_args($args, [
            'title'         => 'Your title',
            'subtitle'      => '',
            'description'   => '',
            'default'       => false,
            'default_value' => 'opt1',
            'options'       => [
                'opt1'  => __('Options #1', 'finanzia'),
                'opt2'  => __('Options #2', 'finanzia')
            ],
            'required' => []
        ]);
        if($args['default']){
            $args['default_value'] = '0';
            $options = array_merge(
                [
                    '0' => __('Theme Default','finanzia')
                ],
                $args['options']
            );
        } else {
            $options = $args['options'];
        }
        return [
            'title'         => $args['title'],
            'subtitle'      => $args['subtitle'],
            'description'   => $args['description'],
            'type'          => Theme_Core_Options::SELECT_FIELD,
            'options'       => $options,
            'default'       => $args['default_value'],
            'required'      => $args['required']
        ];
    }
}
/**
 * Content Width
 * 
 * */
function finanzia_theme_content_width_opts($args = []){
    $args = wp_parse_args($args, [
        'default'       => false,
        'default_value' => 'container',
        'title'         => esc_html__('Content Width','finanzia'),
        'subtitle'      => '',
        'required'      => ''
    ]);
    $opts = [
        'container'       => esc_html__('Container', 'finanzia'),
        'container-wide'  => esc_html__('Container Wide', 'finanzia'),
        'container-fluid' => esc_html__('Container Fluid', 'finanzia'),
        'container-fluid2' => esc_html__('Container Fluid - Full Right', 'finanzia'),
        'container--full'  => esc_html__('Container Full', 'finanzia')
    ];
    if($args['default']) {
        $opts['-1'] = esc_html__('Default','finanzia');
        $args['default_value'] = '-1';
    }
    return [
        'type'     => Theme_Core_Options::BUTTON_SET_FIELD,
        'title'    => $args['title'],
        'subtitle' => $args['subtitle'],
        'options'  => $opts,
        'default'  => $args['default_value'],
        'required' => $args['required']
    ];
}
function finanzia_theme_content_width_render($args = []){
    $args = wp_parse_args($args, [
        'name'    => '',
        'default' => 'container'
    ]);
    $settings = finanzia_get_opts($args['name'], $agrs['default']);
    if(!empty($settings)) return $args['prefix'].$settings;
}
/**
 * Content Alignment
 * **/
function finanzia_them_content_align_opts($args = []){
    $args = wp_parse_args($args, [
        'default'       => false,
        'default_value' => '',
        'title'         => esc_html__('Content Alignment','finanzia'),
        'subtitle'      => '',
        'required'      => ''
    ]);
    $opts = [
        'start'  => esc_html__('Start', 'finanzia'),
        'center' => esc_html__('Center', 'finanzia'),
        'end'    => esc_html__('End', 'finanzia'),
    ];
    if($args['default']) {
        $opts['-1'] = esc_html__('Default','finanzia');
        $args['default_value'] = '-1';
    }
    return [
        'type'     => Theme_Core_Options::BUTTON_SET_FIELD,
        'title'    => $args['title'],
        'subtitle' => $args['subtitle'],
        'options'  => $opts,
        'default'  => $args['default_value'],
        'required' => $args['required']
    ];
}
function finanzia_them_content_align_render($args = []){
    $args = wp_parse_args($args, [
        'name'    => '',
        'prefix'  => 'text-',
        'default' => 'start'
    ]);
    $settings = finanzia_get_opts($args['name'], $agrs['default']);
    if(!empty($settings)) return $args['prefix'].$settings;
}
/**
 * Button Settings
 * 
 * **/
if(!function_exists('finanzia_theme_button_settings')){
    function finanzia_theme_button_settings($args = []){
        $args = wp_parse_args($args, [
            'name'          => 'h_btn',
            'heading'       => esc_html__('Button Settings','finanzia'),  
            'default'       => false,
            'default_value' => 'off'
        ]);
        return [
            $args['name'].'_heading' => [
                'type' => Theme_Core_Options::HEADING_FIELD,
                'title' => $args['heading'],
            ],
            $args['name'].'_on' => finanzia_theme_on_off_opts([
                'default'       => $args['default'],    
                'default_value' => $args['default_value'],
                'title'         => esc_html__('Show/Hide Button', 'finanzia')
            ]),
            $args['name'].'_text' => [
                'type'  => Theme_Core_Options::TEXT_FIELD,
                'title' => esc_html__('Button Text', 'finanzia'),
                'required' => [
                    $args['name'].'_on',
                    '=',
                    'on'
                ],
            ],
            $args['name'].'_link_type' => [
                'type' => Theme_Core_Options::BUTTON_SET_FIELD,
                'title' => esc_html__('Button Link Type', 'finanzia'),
                'options' => [
                    'page' => esc_html__('Page', 'finanzia'),
                    'custom' => esc_html__('Custom', 'finanzia'),
                ],
                'default' => 'page',
                'required' => [
                    $args['name'].'_on',
                    '=',
                    'on'
                ],
            ],
            $args['name'].'_link' => [
                'type' => Theme_Core_Options::SELECT_FIELD,
                'title' => esc_html__('Page Link', 'finanzia'),
                'args' => [
                    'post_type' => 'page',
                    'posts_per_page' => -1,
                    'orderby' => 'title',
                    'order' => 'ASC',
                ],
                'select2' => true,
                'required' => [
                    $args['name'].'_link_type',
                    '=',
                    'page'
                ],
            ],
            $args['name'].'_link_custom' => [
                'type' => Theme_Core_Options::TEXT_FIELD,
                'title' => esc_html__('Custom Link', 'finanzia'),
                'required' => [
                    $args['name'].'_link_type',
                    '=',
                    'custom'
                ],
            ],
            $args['name'].'_target' => [
                'type' => Theme_Core_Options::BUTTON_SET_FIELD,
                'title' => esc_html__('Button Target', 'finanzia'),
                'options' => [
                    '_self' => esc_html__('Self', 'finanzia'),
                    '_blank' => esc_html__('Blank', 'finanzia'),
                ],
                'default' => '_self',
                'required' => [
                    $args['name'].'_on',
                    '=',
                    'on'
                ],
            ]
        ];
    }
}
/**
 * Phone Settings
 * **/
if(!function_exists('finanzia_theme_phone_settings')){
    function finanzia_theme_phone_settings($args = []){
        $args = wp_parse_args($args, [
            'name'        => '',
            'default'     => false,  
            'default_opt' => 'off'
        ]);
        return [
            'show_phone'.$args['name'] => [
                'type'  => Theme_Core_Options::HEADING_FIELD,
                'title' => esc_html__('Phone', 'finanzia').' '.$args['name'],
            ],
            'h_phone'.$args['name'].'_on' => finanzia_theme_on_off_opts([
                'default'       => $args['default'],
                'default_value' => 'off',
                'title'         => esc_html__('Show/Hide Phone', 'finanzia').' '.$args['name']
            ]),
            'h_phone'.$args['name'].'_text' => [
                'type'        => Theme_Core_Options::TEXT_FIELD,
                'title'       => esc_html__('Phone Text', 'finanzia'),
                'placeholder' => 'Need assistance?',
                /*'required'    => [
                    'h_phone'.$args['name'].'_on',
                    '=',
                    'on'
                ]*/
            ],
            'h_phone'.$args['name'].'_number' => [
                'type'        => Theme_Core_Options::TEXT_FIELD,
                'title'       => esc_html__('Phone Number', 'finanzia'),
                'placeholder' => '+2 0106124541',
                /*'required'    => [
                    'h_phone'.$args['name'].'_on',
                    '=',
                    'on'
                ]*/
            ]
        ];
    }
}
/**
 * Mail Settings
 * **/
if(!function_exists('finanzia_theme_mail_settings')){
    function finanzia_theme_mail_settings($args = []){
        $args = wp_parse_args($args, [
            'name'        => '',
            'default'     => false,  
            'default_opt' => 'off'
        ]);
        return [
            'show_mail'.$args['name'] => [
                'type'  => Theme_Core_Options::HEADING_FIELD,
                'title' => esc_html__('Mail', 'finanzia').' '.$args['name'],
            ],
            'h_mail'.$args['name'].'_on' => finanzia_theme_on_off_opts([
                'default'       => $args['default'],
                'default_value' => 'off',
                'title'         => esc_html__('Show/Hide Mail', 'finanzia').' '.$args['name']
            ]),
            'h_mail'.$args['name'].'_text' => [
                'type'        => Theme_Core_Options::TEXT_FIELD,
                'title'       => esc_html__('Your Email', 'finanzia'),
                'placeholder' => 'Finanzia@cmsheroes.com',
                'required'    => [
                    'h_mail'.$args['name'].'_on',
                    '=',
                    'on'
                ]
            ]
        ];
    }
}
// WooCS Currency Switcher
if(!function_exists('finanzia_woo_header_woocs_opts')){
    function finanzia_woo_header_woocs_opts($args = []){
        if(!class_exists('WOOCS_STARTER')) return [];
        $args = wp_parse_args($args, [
            'name'        => '',
            'default'     => false,  
            'default_opt' => 'off',
            'required'    => []
        ]);
        return [
            'show_woocs'.$args['name'] => [
                'type'  => Theme_Core_Options::HEADING_FIELD,
                'title' => esc_html__('Currency Switcher', 'finanzia').' '.$args['name'],
                'required' => $args['required']
            ],
            'h_woocs'.$args['name'].'_on' => finanzia_theme_on_off_opts([
                'default'       => $args['default'],
                'default_value' => 'off',
                'title'         => esc_html__('Show/Hide Currency Switcher', 'finanzia').' '.$args['name'],
                'required' => $args['required']
            ])
        ];
    }
}
// WPC Smart Wishlist
if(!function_exists('finanzia_woo_header_wishlist_opts')){
    function finanzia_woo_header_wishlist_opts($args = []){
        if(!class_exists('WPCleverWoosw')) return [];
        $args = wp_parse_args($args, [
            'name'        => '',
            'default'     => false,  
            'default_opt' => 'off',
            'required'    => []
        ]);
        return [
            'show_wishlist'.$args['name'] => [
                'type'  => Theme_Core_Options::HEADING_FIELD,
                'title' => esc_html__('Wishlist', 'finanzia').' '.$args['name'],
                'required' => $args['required']
            ],
            'h_wishlist'.$args['name'].'_on' => finanzia_theme_on_off_opts([
                'default'       => $args['default'],
                'default_value' => 'off',
                'title'         => esc_html__('Show/Hide Wishlist', 'finanzia').' '.$args['name'],
                'required' => $args['required']
            ])
        ];
    }
}
// WPC Smart Compare
if(!function_exists('finanzia_woo_header_compare_opts')){
    function finanzia_woo_header_compare_opts($args = []){
        if(!class_exists('WPCleverWoosc')) return [];
        $args = wp_parse_args($args, [
            'name'        => '',
            'default'     => false,  
            'default_opt' => 'off',
            'required'    => []
        ]);
        return [
            'show_compare'.$args['name'] => [
                'type'  => Theme_Core_Options::HEADING_FIELD,
                'title' => esc_html__('Compare', 'finanzia').' '.$args['name'],
                'required' => $args['required']
            ],
            'h_compare'.$args['name'].'_on' => finanzia_theme_on_off_opts([
                'default'       => $args['default'],
                'default_value' => 'off',
                'title'         => esc_html__('Show/Hide Compare', 'finanzia').' '.$args['name'],
                'required' => $args['required']
            ])
        ];
    }
}
/** 
 * Login
 * */
if(!function_exists('finanzia_header_login_opts')){
    function finanzia_header_login_opts($args = []){
        if(!function_exists('cshlg_link_to_login')) return [];
        $args = wp_parse_args($args, [
            'name'        => '',
            'default'     => false,  
            'default_opt' => 'off',
            'required'    => []
        ]);
        return [
            'show_login'.$args['name'] => [
                'type'  => Theme_Core_Options::HEADING_FIELD,
                'title' => esc_html__('Login', 'finanzia').' '.$args['name'],
                'required' => $args['required']
            ],
            'h_login'.$args['name'].'_on' => finanzia_theme_on_off_opts([
                'default'       => $args['default'],
                'default_value' => 'off',
                'title'         => esc_html__('Show/Hide Login', 'finanzia'),
                'required' => $args['required']
            ])
        ];
    }
}
/**
 * Language Switcher
 * */
if(!function_exists('finanzia_header_language_switcher_opts')){
    function finanzia_header_language_switcher_opts($args = []){
        if(!class_exists('TRP_Translate_Press') ) return array();
        $args = wp_parse_args($args, [
            'name'        => '',
            'default'     => false,  
            'default_opt' => 'off',
            'required'    => [] 
        ]);
        return [
            'show_language'.$args['name'] => [
                'type'  => Theme_Core_Options::HEADING_FIELD,
                'title' => esc_html__('Language Switcher', 'finanzia').' '.$args['name'],
                'required' => $args['required']
            ],
            'h_language'.$args['name'].'_on' => finanzia_theme_on_off_opts([
                'default'       => $args['default'],
                'default_value' => 'off',
                'title'         => esc_html__('Show/Hide Language Switcher', 'finanzia'),
                'required' => $args['required']
            ])
        ];
    }
}
/**
 * Header layout 
 * 
 * */
if(!function_exists('finanzia_theme_header_layout_opts')){
    function finanzia_theme_header_layout_opts($args = []){
        $args = wp_parse_args($args, [
            'default'       => false,
            'default_value' => '1',
            'required'      => ''
        ]);
        $header_layout = [];
        if($args['default']){
            $header_layout['-1'] = get_template_directory_uri() . '/assets/images/header-layout/h-default.jpg';
            $header_layout['none'] = get_template_directory_uri() . '/assets/images/header-layout/h0.jpg';
        }
        // Theme Layout
        $layouts = [
            '1' => get_template_directory_uri() . '/assets/images/header-layout/h1.jpg',
            '2' => get_template_directory_uri() . '/assets/images/header-layout/h2.jpg',
            '3' => get_template_directory_uri() . '/assets/images/header-layout/h3.jpg',
            '4' => get_template_directory_uri() . '/assets/images/header-layout/h4.jpg',
            'left' => get_template_directory_uri() . '/assets/images/header-layout/h-left.jpg',
        ];
        return [
            'type'     => Theme_Core_Options::IMAGE_SELECT_FIELD,
            'title'    => esc_html__('Layout', 'finanzia'),
            'subtitle' => esc_html__('Select a layout for header.', 'finanzia'),
            'options'  => array_unique ($header_layout + $layouts),
            'default'  => $args['default_value'],
            'required' => $args['required']
        ];
    }
}
/**
 * Header Side Nav Options
**/
if(!function_exists('finanzia_header_side_nav_opts')){
    function finanzia_header_side_nav_opts($args=[]){
        $args = wp_parse_args($args, [
            'default'        => '',
            'default_value'  => '',
            'default_layout' => '',
            'required'       => []
        ]);
        if($args['default']){
            $args['default_value'] = '-1';
        }
        if(!apply_filters('finanzia_enable_sidenav', false)) return array();
        
        return [
            'hide_sidebar_icon_heading' => [
                'type'     => Theme_Core_Options::HEADING_FIELD,
                'title'    => esc_html__('Hidden Sidebar Settings','finanzia'),
                'required' => $args['required']
            ],
            'hide_sidebar_icon' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Hidden Sidebar', 'finanzia'),
                'default'       => $args['default'],
                'default_value' => $args['default_value'],
                'required'      => $args['required']
            ]),
            'header_sidenav_layout' => [
                'type'        => Theme_Core_Options::IMAGE_SELECT_FIELD,
                'title'       => esc_html__('Hidden Sidebar Layout', 'finanzia'),
                'subtitle'    => esc_html__('Select a layout for upper side nav area.', 'finanzia'),
                'description' => sprintf(esc_html__('%sClick Here%s to add your custom side nav layout.','finanzia'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=cms-sidenav' ) ) . '" target="_blank">','</a>'),
                'placeholder' => esc_html__('Default','finanzia'),
                'options'     => finanzia_list_post_thumbnail('cms-sidenav', $args['default']),
                'default'     => $args['default_layout'],
                'required' => [
                    'hide_sidebar_icon', "=", 'on'
                ]
            ]
        ];
    }
}
/**
 * Header Socials
 * 
**/
if(!function_exists('finanzia_header_social_opts')){
    function finanzia_header_social_opts($args = []){
        $args = wp_parse_args($args, [
            'default'        => '',
            'default_value'  => '',
            'default_layout' => '',
            'required'       => []
        ]);
        if($args['default']){
            $args['default_value'] = '-1';
        }
        return [
            'header_social_heading' => [
                'type'     => Theme_Core_Options::HEADING_FIELD,
                'title'    => esc_html__('Header Socials','finanzia'),
                'required' => $args['required']
            ],
            'show_header_social' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Show/Hide Social', 'finanzia'),
                'default'       => $args['default'],
                'default_value' => $args['default_value'],
                'required'      => $args['required']
            ]),
            'header_socials' => [
                'type'        => Theme_Core_Options::REPEATER_FIELD,
                'title'       => __('Add your Social', 'finanzia'),
                'fields' => [
                    'icon' => [
                        'type'        => Theme_Core_Options::MEDIA_FIELD,
                        'title'       => __('Icon', 'finanzia'),
                        'default'     => '' 
                    ],
                    'url' => [
                        'type'  => Theme_Core_Options::TEXT_FIELD,
                        'title' => __('Social URL','finanzia')
                    ],
                    'text' => [
                        'type'  => Theme_Core_Options::TEXT_FIELD,
                        'title' => __('Social Text','finanzia')
                    ]
                ],
                'title_field' => 'url',
                'class'       => '123xxx',
                'classes'     => '456qwweqwe'
            ]
        ];
    }
}

/**
 * Header TOp Options
**/
if(!function_exists('finanzia_header_top_opts')){
    function finanzia_header_top_opts($args=[]){
        $args = wp_parse_args($args, [
            'default'        => false,
            'default_value'  => 'none',
            'default_on'     => 'off',
            'custom'         => false   
        ]);
        if($args['default']){
            $args['default_value'] = '-1';
        }
        $custom_fields = [];
        if($args['custom']){
            $custom_fields['header_top_custom'] = finanzia_theme_on_off_opts([
                'title'         => esc_html__('Custom Header Top','finanzia'),
                'default'       => false
            ]);
        }
        $default_fields = [
            'header_top_layout' => array(
                'type'        => Theme_Core_Options::IMAGE_SELECT_FIELD,
                'title'       => esc_html__('Layout', 'finanzia'),
                'subtitle'    => esc_html__('Select a layout for upper header top area.', 'finanzia'),
                'description' => sprintf(esc_html__('%sClick Here%s to add your custom header top layout.','finanzia'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=cms-header-top' ) ) . '" target="_blank">','</a>'),
                'placeholder' => esc_html__('Default','finanzia'),
                'options'     => finanzia_list_post_thumbnail('cms-header-top', $args['default'], [
                    'none' => get_template_directory_uri() . '/assets/images/default-opt/none.jpg'
                ]),
                'default'     => $args['default_value'],
                'required' => [
                    'header_top_custom', "=", 'on'
                ]
            )
        ];
        // Return
        return [
            'title'      => esc_html__('Header Top', 'finanzia'),
            'fields'     => $custom_fields + $default_fields
        ];
    }
}
/**
 * Footer Options
**/
if(!function_exists('finanzia_footer_opts')){
    function finanzia_footer_opts($args=[]){
        $args = wp_parse_args($args, [
            'default'        => false,
            'default_value'  => '1',
            'default_on'     => 'off',
            'custom'         => false   
        ]);
        if($args['default']){
            $args['default_value'] = '-1';
        }
        $custom_fields = [];
        if($args['custom']){
            $custom_fields['footer_custom'] = finanzia_theme_on_off_opts([
                'title'         => esc_html__('Custom Footer','finanzia'),
                'default'       => false
            ]);
        }
        $default_fields = [
            'footer_copyright' => [
                'type'        => Theme_Core_Options::TEXTAREA_FIELD,
                'title'       => esc_html__('Copyright Settings','finanzia'),
                'subtitle'    => esc_html__('Add your copyright text','finanzia'),
                'description' => esc_html__( 'Use [[copy]] for &copy;, [[year]] for current year', 'finanzia'),
                'placeholder' => '&copy; 2024 Finanzia, All Rights Reserved. With Love by CMSSuperHeroes',
                'required'    => [
                    'footer_custom', '=', 'on',
                    'footer_layout', '=', 1
                ]
            ],
            'footer_layout' => array(
                'type'        => Theme_Core_Options::IMAGE_SELECT_FIELD,
                'title'       => esc_html__('Layout', 'finanzia'),
                'subtitle'    => esc_html__('Select a layout for upper footer area.', 'finanzia'),
                'description' => sprintf(esc_html__('%sClick Here%s to add your custom footer layout.','finanzia'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=cms-footer' ) ) . '" target="_blank">','</a>'),
                'placeholder' => esc_html__('Default','finanzia'),
                'options'     => finanzia_list_post_thumbnail('cms-footer', $args['default'], [
                    '1' => get_template_directory_uri() . '/assets/images/footer-layout/default.webp'
                ]),
                'default'     => $args['default_value'],
                'required' => [
                    'footer_custom', '=', 'on'
                ]
            ),
            'footer_fixed' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Footer Fixed', 'finanzia'),
                'subtitle'      => esc_html__('Make footer fixed at bottom?', 'finanzia'),
                'default'       => $args['default'],
                'default_value' => $args['default_on'], 
                'required' => [
                    'footer_custom', '=', 'on'
                ]
            ])
        ];
        // Return
        return [
            'title'      => esc_html__('Footer', 'finanzia'),
            'fields'     => $custom_fields + $default_fields
        ];
    }
}
/**
 * WooCommerce Options
 * ====================
 * 
 * */
/**
 * Single Product Options
 * **/
if(!function_exists('finanzia_single_product_opts')){
    function finanzia_single_product_opts($args = []){
        $args = wp_parse_args($args, [
            'default'      => false
        ]);
        if($args['default']){
            $custom_opts = [
                'product_custom' => finanzia_theme_on_off_opts([
                    'title'         => esc_html__('Custom Product','finanzia'),
                    'default'       => false,
                    'default_value' => 'off'
                ])
            ];
            $required = [
                'product_custom',
                '=',
                'on'
            ];
            $on_off_default = true;
            $product_single_layout_default = 'df';
            $product_single_gallery_default = 'df';
        } else {
            $custom_opts = [];
            $required = '';
            $on_off_default = false;
            $product_single_layout_default = 'single-product';
            $product_single_gallery_default = 'slider';
        }

        
        return array(
            'title'      => esc_html__('Single Products', 'finanzia'),
            'fields'     => array_merge(
                $custom_opts,
                array(
                    'product_layout_and_content' => [
                        'type'     => Theme_Core_Options::HEADING_FIELD,
                        'title'    => esc_html__('Layout & Content', 'finanzia'),
                        'required' => $required
                    ],
                    'product_single_layout' => finanzia_select_opts([
                        'title'         => esc_html__('Layout', 'finanzia'),
                        'subtitle'      => esc_html__('Choose layout for single product','finanzia'),
                        'default'       => $args['default'],
                        'default_value' => $product_single_layout_default,
                        'options'       => [
                            'single-product'            => esc_html__('WooCommerce Default','finanzia')
                        ],
                        'required' => $required
                    ]),
                    // Product Gallery 
                    'product_gallery' => finanzia_select_opts([
                        'title'         => esc_html__('Gallery Layout', 'finanzia'),
                        'subtitle'      => esc_html__('Choose layout for single product Gallery','finanzia'),
                        'default'       => $args['default'],
                        'default_value' => $product_single_gallery_default,
                        'options'       => [
                            'slider'         => esc_html__('Slider','finanzia')
                        ],
                        'required' => $required
                    ]),
                    // Next/Prev arrow
                    'product_gallery_nav' => finanzia_theme_on_off_opts([
                        'title'         => esc_html__('Gallery Navigation', 'finanzia'),
                        'default'       => $on_off_default,
                        'default_value' => 'on',
                        'required'      => [
                            'product_gallery',
                            '=',
                            ['slider']
                        ]
                    ]),
                    // Product share
                    'product_share' => finanzia_theme_on_off_opts([
                        'title'         => esc_html__('Share', 'finanzia'),
                        'default'       => $on_off_default,
                        'default_value' => 'off',
                        'required'      => $required
                    ])
                )
            )
        );
    }
}
/**
 * Pop Ups Options
**/
if(!function_exists('finanzia_popup_opts')){
    function finanzia_popup_opts($args=[]){
        $args = wp_parse_args($args, [
            'default'        => false,
            'default_value'  => 'none',
            'default_on'     => 'off',
            'custom'         => false ,
            'animate_value'  => 'cms-fadeInUp',
            'position_value' => 'align-items-end' 
        ]);
        if($args['default']){
            $args['default_value'] = '-1';
            $args['animate_value'] = $args['position_value'] = '-1';
        }
        $custom_fields = [];
        if($args['custom']){
            $custom_fields['popup_custom'] = finanzia_theme_on_off_opts([
                'title'         => esc_html__('Custom Pop Up','finanzia'),
                'default'       => false
            ]);
        }
        $default_fields = [
            'popup_layout' => array(
                'type'        => Theme_Core_Options::IMAGE_SELECT_FIELD,
                'title'       => esc_html__('Layout', 'finanzia'),
                'subtitle'    => esc_html__('Select a layout for upper Pop-Up area.', 'finanzia'),
                'description' => sprintf(esc_html__('%sClick Here%s to add your custom popup layout.','finanzia'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=cms-popup' ) ) . '" target="_blank">','</a>'),
                'placeholder' => esc_html__('Default','finanzia'),
                'options'     => finanzia_list_post_thumbnail('cms-popup', $args['default'], [
                    'none' => get_template_directory_uri() . '/assets/images/default-opt/none.jpg'
                ]),
                'default'     => $args['default_value'],
                'required' => [
                    'popup_custom', "=", 'on'
                ]
            ),
            'hide_popup' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Show Hide popup option','finanzia'),
                'default'       => false,
                'required' => [
                    'popup_custom', "=", 'on'
                ]
            ]),
            'popup_animate'    => finanzia_select_opts([
                'title'         => esc_html__('Animation Style', 'finanzia'),
                'default'       => $args['default'],
                'default_value' => $args['animate_value'],
                'options'       => [
                    'cms-fadeInUp'    => esc_html__('Fade In Up','finanzia'),
                    'cms-fadeInLeft'  => esc_html__('Fade In Left','finanzia'), 
                    'cms-fadeInRight' => esc_html__('Fade In Right','finanzia')
                ],
                'required' => [
                    'popup_custom', "=", 'on'
                ]
            ]),
            'popup_position'   => finanzia_select_opts([
                'title'         => esc_html__('Position', 'finanzia'),
                'default'       => $args['default'],
                'default_value' => $args['position_value'],
                'options'       => [
                    'align-items-start'                         => esc_html__('Top - Start','finanzia'),
                    'align-items-start justify-content-end'     => esc_html__('Top - End','finanzia'), 
                    'align-items-center'                        => esc_html__('Center - Start','finanzia'),
                    'align-items-center justify-content-center' => esc_html__('Center - Center','finanzia'),
                    'align-items-center justify-content-end'    => esc_html__('Center - End','finanzia'),
                    'align-items-end'                           => esc_html__('Bottom - Start','finanzia'),
                    'align-items-end justify-content-end'       => esc_html__('Bottom - End','finanzia'), 
                ],
                'required' => [
                    'popup_custom', "=", 'on'
                ]
            ]),
            'popup_max_w' => [
                'type'     => 'dimensions',
                'title'    => esc_html__('Popup Width', 'finanzia'),
                'subtitle' => esc_html__('Enter number.', 'finanzia'),
                'height'   => false,
                'required' => [
                    'popup_custom', "=", 'on'
                ]
            ]
        ];
        // Return
        return [
            'title'      => esc_html__('Pop Up', 'finanzia'),
            'fields'     => $custom_fields + $default_fields
        ];
    }
}

/***
 * Get CMS PopUp template
*/
if(!function_exists('finanzia_list_elementor_template')){
    function finanzia_list_elementor_template(){
        $elementor_templates = get_posts([
            'post_type'   => 'cms-popup',
            'numberposts' => -1,
            'post_status' => 'publish',
        ]);
        $elementor_templates_opt = [
            '_1' => esc_html__( 'Select Template', 'finanzia' ),
        ];
        if($elementor_templates){
            foreach ($elementor_templates as $template) {
                $elementor_templates_opt[$template->ID] = $template->post_title;
            }
        }
        return $elementor_templates_opt;
    }
}