<?php
// Silence is golden.
$args = [
    'title'    => esc_html__('Sidebar', 'finanzia'),
    'sections' => [
        'general' => [
            'title' => esc_html__('General', 'finanzia'),
            'fields' => [
                'sidebar_on' => finanzia_theme_show_hide_opts([
                    'title'    => esc_html__('Show Sidebar', 'finanzia'),
                    'subtitle' => esc_html__('Show/Hide sidebar on single post & archive page', 'finanzia')
                ]),
                'sidebar_pos' => [
                    'type'    => Theme_Core_Options::BUTTON_SET_FIELD,
                    'title'   => esc_html__('Sidebar Position','finanzia'),
                    'options' => [
                        'order-first' => esc_html__('Left','finanzia'),
                        'order-last'  => esc_html__('Right','finanzia')
                    ],
                    'default' => 'order-last',
                    'required' => [
                        'sidebar_on', '=', 'on'
                    ]
                ]
            ]
        ]
    ]
];
return $args;