<?php
// Silence is golden.
$fields_default = [
    'pagetitle' => finanzia_theme_show_hide_opts([
        'title'         => esc_html__('Page Title', 'finanzia'),
        'default'       => $default,
        'default_value' => $default_on,
        'required' => [
            'custom_ptitle',
            '=',
            'on'
        ]
    ]),
    'show_title' => finanzia_theme_show_hide_opts([
        'title'         => esc_html__('Title', 'finanzia'),
        'default'       => $default,
        'default_value' => $default_on,
        'required'      => [
            'pagetitle',
            '=',
            'on'
        ]
    ]),
    'show_breadcrumb' => finanzia_theme_show_hide_opts([
        'title'         => esc_html__('Breadcrumbs', 'finanzia'),
        'default'       => $default,
        'default_value' => $default_on,
        'required'      => [
            'pagetitle',
            '=',
            'on'
        ]
    ]),
    'ptitle_align'  => finanzia_them_content_align_opts([
        'required'      => [
            'pagetitle',
            '=',
            'on'
        ]
    ]),
    'ptitle_heading' => [
        'type'     => Theme_Core_Options::HEADING_FIELD,
        'title'    => esc_html__('Background Settings', 'finanzia'),
        'required' => [
            'pagetitle',
            '=',
            'on'
        ]
    ],
    'page_title_bg' => [
        'type'     => Theme_Core_Options::BACKGROUND_FIELD,
        'title'    => esc_html__('Background', 'finanzia'),
        'subtitle' => esc_html__('Choose Background color and image', 'finanzia'),
        'required' => [
            'pagetitle',
            '=',
            'on'
        ],
        'background-repeat'     => false,
        'background-size'       => false,
        'background-position'   => false,
        'background-attachment' => false
    ],
    'page_title_overlay' => [
        'type'     => Theme_Core_Options::RGBA_COLOR_FIELD,
        'title'    => esc_html__('Overlay Background Color', 'finanzia'),
        'required' => [
            'pagetitle',
            '=',
            'on'
        ]
    ]
];
$fields = [];
if($custom_opts){
    $fields = [
        'custom_ptitle' => finanzia_theme_on_off_opts([
            'title'         => esc_html__('Custom Page Title','finanzia'),
            'default'       => false,
            'default_value' => 'off'
        ])
    ];
}
$args = [
    'title'  => esc_html__('Page Tile', 'finanzia'),
    'fields' => $fields + $fields_default
];
return $args;