<?php
// Silence is golden.
$args = [
    'title'    => esc_html__('Header', 'finanzia'),
    'sections' => [
        'general' => [
            'title' => esc_html__('General', 'finanzia'),
            'fields' => [
                'header_layout' => finanzia_theme_header_layout_opts([
                    'default'       => $default,
                    'default_value' => $default_value
                ]),
                'header_menu' => [
                    'type'    => Theme_Core_Options::SELECT_FIELD,
                    'title'   => esc_html__('Main Navigation', 'finanzia'),
                    'options' => finanzia_menu_list(),
                    'default' => 'primary'
                ],
                'main_menu_color' => [
                    'type'  => Theme_Core_Options::LINK_COLOR_FIELD,
                    'title' => esc_html__('Menu Color', 'finanzia')
                ],
                'header_height' => [
                    'type'     => 'dimensions',
                    'title'    => esc_html__('Header Width / Height', 'finanzia'),
                    'subtitle' => esc_html__('Set width / height for your Header', 'finanzia'),
                    'width'    => false
                ],
                'extra' => [
                    'type'  => Theme_Core_Options::HEADING_FIELD,
                    'title' => esc_html__('Extra Settings', 'finanzia')
                ],
                'header_width' => finanzia_theme_content_width_opts([
                    'title'         => esc_html__('Header Content Width', 'finanzia'),
                    'default'       => $default,
                    'default_value' => $default_header_width
                ]),
                'header_sticky' => finanzia_theme_on_off_opts([
                    'title'         => esc_html__('Header Sticky', 'finanzia'),
                    'subtitle'      => esc_html__('Header will be sticked when applicable.', 'finanzia')
                ]),
                'header_sticky_mode' => finanzia_select_opts([
                    'title'         => esc_html__('Header Sticky Mode', 'finanzia'),
                    'subtitle'      => esc_html__('Header will when:', 'finanzia'),
                    'options'       => [
                        'srollup' => esc_html__('Scroll UP','finanzia'),
                        'always'  => esc_html__('Always', 'finanzia')  
                    ],
                    'default_value' => 'srollup',
                    'required' => [
                        'header_sticky', '=', 'on'
                    ]
                ]),
                'header_boxed' => finanzia_theme_on_off_opts([
                    'title'         => esc_html__('Header Boxed', 'finanzia'),
                    'subtitle'      => esc_html__('Make header boxed','finanzia'),
                    'default'       => $default,
                    'default_value' => $default_off
                ]),
                'header_shadow' => finanzia_theme_on_off_opts([
                    'title'         => esc_html__('Header Shadow', 'finanzia'),
                    'subtitle'      => esc_html__('Add shadow at bottom of header','finanzia'),
                    'default'       => $default,
                    'default_value' => $default_on
                ]),
                'header_divider' => finanzia_theme_on_off_opts([
                    'title'         => esc_html__('Divider', 'finanzia'),
                    'subtitle'      => esc_html__('Add divider at bottom of header','finanzia'),
                    'default'       => $default,
                    'default_value' => $default_off
                ])
            ]
        ],
        'logo' => [
            'title'  => esc_html__('Logo', 'finanzia'),
            'fields' => [
                'logo' => [
                    'type'  => Theme_Core_Options::MEDIA_FIELD,
                    'title' => esc_html__('Logo', 'finanzia')
                ],
                'logo_maxh' => [
                    'type'     => 'dimensions',
                    'title'    => esc_html__('Logo Dimensions', 'finanzia'),
                    'subtitle' => esc_html__('Enter number.', 'finanzia')
                ],
                'logo_mobile' => [
                    'type'  => Theme_Core_Options::MEDIA_FIELD,
                    'title' => esc_html__('Logo Tablet & Mobile', 'finanzia')
                ],
                'logo_maxh_sm' => [
                    'type'     => 'dimensions',
                    'title'    => esc_html__('Logo Tablet & Mobile Dimensions', 'finanzia'),
                    'subtitle' => esc_html__('Enter number.', 'finanzia')
                ],
            ],
        ],
        'header_ontop' => [
            'title' => esc_html__('Header Transparent', 'finanzia'),
            'fields' => [
                'header_transparent' => finanzia_theme_on_off_opts([
                    'title'         => esc_html__('Header Transparent', 'finanzia'),
                    'subtitle'      => esc_html__('Header transparent use with background.', 'finanzia'),
                    'default_value' => $default_off
                ]),
                'logo_light' => [
                    'type' => Theme_Core_Options::MEDIA_FIELD,
                    'title' => esc_html__('Logo', 'finanzia')
                ],
                'logo_light_mobile' => [
                    'type'  => Theme_Core_Options::MEDIA_FIELD,
                    'title' => esc_html__('Logo Tablet & Mobile', 'finanzia')
                ],
                'transparent_menu_color' => [
                    'type' => Theme_Core_Options::LINK_COLOR_FIELD,
                    'title' => esc_html__('Menu Color', 'finanzia')
                ]
            ]
        ],
        'attributes' => [
            'title' => esc_html__('Attributes','finanzia'),
            'fields' => array_merge(
                [
                    'search_icon' => finanzia_theme_on_off_opts([
                        'title'         => esc_html__('Search Icon', 'finanzia'),
                        'default'       => $default,
                        'default_value' => $default_off
                    ]),
                    'search_on_content' => array(
                        'type'     => Theme_Core_Options::SELECT_FIELD,
                        'title'    => esc_html__('Search Content As', 'finanzia'),
                        'options'  => [
                            '_1'     => esc_html__('Default','finanzia'),
                            'custom' => esc_html__('Custom', 'finanzia')
                        ],
                        'default'  => '_1',
                        'description' => sprintf(esc_html__('%sClick Here%s to add your custom content.','finanzia'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=cms-popup#add_new' ) ) . '" target="_blank">','</a>'),
                        'required' => array( 0 => 'search_icon', 1 => '=', 2 => 'on' )
                    ),
                    'search_on_content_content' => array(
                        'type'        => Theme_Core_Options::SELECT_FIELD,
                        'title'       => esc_html__('Choose custom search content', 'finanzia'),
                        'description' => esc_html__('Choose custom search content','finanzia'),    
                        'options'     => finanzia_list_elementor_template(),
                        'default'     => '_1',
                        'required'    => array( 0 => 'search_on_content', 1 => '=', 2 => 'custom' ),
                    ),
                    // Cart
                    'cart_icon' => finanzia_theme_on_off_opts([
                        'title'         => esc_html__('Cart Icon', 'finanzia'),
                        'default'       => $default,
                        'default_value' => $default_off
                    ])
                ],
                finanzia_woo_header_woocs_opts([
                    'default'       => $default,
                    'default_value' => $default_off
                ]),
                finanzia_woo_header_wishlist_opts([
                    'default'       => $default,
                    'default_value' => $default_off
                ]),
                finanzia_woo_header_compare_opts([
                    'default'       => $default,
                    'default_value' => $default_off
                ]),
                finanzia_header_login_opts([
                    'default'       => $default,
                    'default_value' => $default_off
                ]),
                finanzia_header_language_switcher_opts([
                    'default'       => $default,
                    'default_value' => $default_off
                ]),
                finanzia_theme_phone_settings([
                    'default'       => $default,
                    'default_value' => $default_off 
                ]),
                finanzia_theme_mail_settings([
                    'default'       => $default,
                    'default_value' => $default_off 
                ]),
                finanzia_theme_button_settings([
                    'default'       => $default,
                    'default_value' => $default_off 
                ]),
                finanzia_theme_button_settings([
                    'heading'       => esc_html__('Button Settings #2', 'finanzia'),
                    'name'          => 'h_btn2',
                    'default'       => $default,
                    'default_value' => $default_off 
                ]),
                finanzia_header_side_nav_opts([
                    'default'       => $default,
                    'default_value' => $default_off 
                ]),
                finanzia_header_social_opts([
                    'default'       => $default,
                    'default_value' => $default_off
                ])
            )
        ]
    ]
];
return $args;