<?php
// Silence is golden.
$args = [
    'title' => esc_html__('General','finanzia'),
    'sections' => [
        'colors' => [
            'title' => esc_html__('Colors', 'finanzia'),
            'fields' => [
                'accent_color' => [
                    'type'        => Theme_Core_Options::COLOR_SET_FIELD,
                    'title'       => esc_html__('Accent Color', 'finanzia'),
                    'options'     => finanzia_color_list_opts('accent_color')
                ],
                'primary_color' => [
                    'type'        => Theme_Core_Options::COLOR_SET_FIELD,
                    'title'       => esc_html__('Primary Color', 'finanzia'),
                    'options'     => finanzia_color_list_opts('primary_color')
                ],
                'heading_color' => array(
                    'type'    => Theme_Core_Options::COLOR_SET_FIELD,
                    'title'   => esc_html__('Heading Color', 'finanzia'),
                    'options' => finanzia_color_list_opts('heading_color')
                ),
                'body_color' => array(
                    'type'    => Theme_Core_Options::COLOR_SET_FIELD,
                    'title'   => esc_html__('Body Color', 'finanzia'),
                    'options' => [
                        'regular' => sprintf('%s (%s)', esc_html__('Default','finanzia'), finanzia_configs('body')['color'])
                    ]
                ),
                'link_color' => [
                    'type' => Theme_Core_Options::LINK_COLOR_FIELD,
                    'title' => esc_html__('Link Color', 'finanzia')
                ],
                // Custom Color
                'custom_color' => [
                    'type'        => Theme_Core_Options::COLOR_SET_FIELD,
                    'title'       => esc_html__('Custom Color', 'finanzia'),
                    'options'     => finanzia_color_list_opts('custom_color')
                ],
            ]
        ],
        'typos' => finanzia_typography_opts(),
        'tools' => [
            'title'  => esc_html__('Tools', 'finanzia'),
            'fields' => [
                'show_page_loading' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Enable Page Loading', 'finanzia'),
                    'subtitle' => esc_html__('Enable page loading effect when you load site.', 'finanzia'),
                ],
                'back_totop_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Back to Top Button', 'finanzia'),
                    'subtitle' => esc_html__('Show back to top button when scrolled down.', 'finanzia'),
                    'default'  => 1,
                ],
                'dev_mode' => [
                    'type'        => Theme_Core_Options::SWITCH_FIELD,
                    'title'       => esc_html__('Dev Mode (not recommended)', 'finanzia'),
                    'description' => esc_html__('no minimize , generate css over time...', 'finanzia'),
                ],
            ],
        ]
    ]
];
return $args;