<?php
// Silence is golden.
$args = [
    'title'    => esc_html__('Content', 'finanzia'),
    'sections' => [
        'general' => [
            'title' => esc_html__('General', 'finanzia'),
            'fields' => [
                'content_width' => finanzia_theme_content_width_opts(),
                'search_field_placeholder' => [
                    'type'        => Theme_Core_Options::TEXT_FIELD,
                    'title'       => esc_html__('Search Form - Text Placeholder', 'finanzia'),
                    'description' => esc_html__('Default: Search Keywords...', 'finanzia'),
                ]
            ]
        ],
        'archive' => [
            'title'  => esc_html__('Archive', 'finanzia'),
            'fields' => [
                'archive_author_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Author', 'finanzia'),
                    'subtitle' => esc_html__('Show author name on each post.', 'finanzia'),
                    'default'  => 1,
                ],
                'archive_date_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Date', 'finanzia'),
                    'subtitle' => esc_html__('Show date posted on each post.', 'finanzia'),
                    'default'  => 1,
                ],
                'archive_categories_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Categories', 'finanzia'),
                    'subtitle' => esc_html__('Show category names on each post.', 'finanzia'),
                    'default'  => 1,
                ],
                'archive_comments_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Comments', 'finanzia'),
                    'subtitle' => esc_html__('Show comments count on each post.', 'finanzia'),
                    'default'  => 1,
                ]
            ],
        ],
        'single-post' => [
            'title'  => esc_html__('Single Post', 'finanzia'),
            'fields' => [
                'post_author_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Author', 'finanzia'),
                    'subtitle' => esc_html__('Show author name on single post.', 'finanzia'),
                    'default'  => 1,
                ],
                'post_author_info_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Author Info', 'finanzia'),
                    'subtitle' => esc_html__('Show author info on single post.', 'finanzia'),
                ],
                'post_date_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Date', 'finanzia'),
                    'subtitle' => esc_html__('Show date on single post.', 'finanzia'),
                    'default'  => 1,
                ],
                'post_categories_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Categories', 'finanzia'),
                    'subtitle' => esc_html__('Show category names on single post.', 'finanzia'),
                    'default'  => 1,
                ],
                'post_tags_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Tags', 'finanzia'),
                    'subtitle' => esc_html__('Show tag names on single post.', 'finanzia'),
                    'default'  => 1,
                ],
                'post_comments_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Comments', 'finanzia'),
                    'subtitle' => esc_html__('Show comments count on single post.', 'finanzia'),
                    'default'  => 1,
                ],
                'post_social_share_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Social Share', 'finanzia'),
                    'subtitle' => esc_html__('Show social share on single post.', 'finanzia')
                ],
                'post_navigation_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Navigation', 'finanzia'),
                    'subtitle' => esc_html__('Show navigation on single post.', 'finanzia'),
                    'default'  => 1,
                ],
                'post_comments_form_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Comments Form', 'finanzia'),
                    'subtitle' => esc_html__('Show comments form on single post.', 'finanzia'),
                    'default'  => 1,
                ]
            ]
        ]
    ]
];
return $args;