<?php 
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;

function finanzia_nice_class($classes = []){
    $classes = (array) $classes;
    return implode(' ', array_unique(array_filter($classes)));
}
/**
 * Create the rating interface.
 * 
 * 
*/
if(!function_exists('finanzia_comment_rating_fields')){
    function finanzia_comment_rating_fields ($args =[]) {
        $args = wp_parse_args($args, [
            'echo'  => true,
            'class' => ''
        ]);
        $show_rating = finanzia_get_opts('post_comments_rating_on', '0', 'on');
        if('1' != $show_rating || !is_singular('post')) return;
        ob_start();
    ?>
        <div class="cms-comment-form-rating cms-comment-form-fields-wrap <?php echo esc_attr($args['class']); ?>">
            <div  class="comment-form-field">
                <?php echo esc_html__('Your Rating','finanzia');?><span class="required text-red">*</span>
            </div>
            <div class="comment-form-field comments-rating">
                <span class="rating-container stars">
                    <?php for ( $i = 5; $i >= 1; $i-- ) : ?>
                        <input type="radio" id="rating-<?php echo esc_attr($i);?>" class="star-<?php echo esc_attr($i);?>" name="rating" value="<?php echo esc_attr($i);?>" />
                        <label for="rating-<?php echo esc_attr($i);?>"><span class="d-none"><?php echo esc_html($i);?></span></label>
                    <?php endfor; ?>
                    <input type="radio" id="rating-0" class="star-cb-clear star-0" name="rating" value="0" /><label for="rating-0"><span class="d-none">0</span></label>
                </span>
                </div>
            </div>
        <?php
        if($args['echo']){
            printf('%s', ob_get_clean() );
        } else {
            return ob_get_clean();
        }
    }
}
if(!function_exists('finanzia_woocommerce_comment_rating_fields')){
    function finanzia_woocommerce_comment_rating_fields($args =[]){
        $args = wp_parse_args($args, [
            'echo' => true,
            'class' => ''
        ]);
        $rating = '';
        if(!function_exists('wc_review_ratings_enabled')) return;
        if (wc_review_ratings_enabled() && is_singular('product') ) {
            $rating .= '<div class="cms-comment-form-rating cms-comment-form-fields-wrap '.esc_attr($args['class']).'">';
                $rating .= '<div class="comment-form-field">' . esc_html__( 'Your rating', 'finanzia' ) . ( wc_review_ratings_required() ? '&nbsp;<span class="required text-red">*</span>' : '' ) . '</div>';
                $rating .= '<div class="comment-form-field comments-rating">';
                    $rating .= '<select name="rating" id="rating" required>
                        <option value="">' . esc_html__( 'Rate&hellip;', 'finanzia' ) . '</option>
                        <option value="5">' . esc_html__( 'Perfect', 'finanzia' ) . '</option>
                        <option value="4">' . esc_html__( 'Good', 'finanzia' ) . '</option>
                        <option value="3">' . esc_html__( 'Average', 'finanzia' ) . '</option>
                        <option value="2">' . esc_html__( 'Not that bad', 'finanzia' ) . '</option>
                        <option value="1">' . esc_html__( 'Very poor', 'finanzia' ) . '</option>
                    </select>';
                $rating .= '</div>';
            $rating .= '</div>';
        }
        if($args['echo']){
            printf('%s', $rating);
        } else {
            return $rating;
        }
    }
}
// add rating to after comment form fields
add_filter('comment_form_fields', 'finanzia_comment_rating_default_fields' );
if(!function_exists('finanzia_comment_rating_default_fields')){
    function finanzia_comment_rating_default_fields ($fields) {
        //$fields_rating = [];
        ob_start();
            finanzia_comment_rating_fields();
            finanzia_woocommerce_comment_rating_fields();
        $rating = ob_get_clean();
        //$fields_rating['rating'] = ob_get_clean();
        //$fields = array_merge($fields_rating, $fields);
        $fields['comment'] = $rating.$fields['comment'];
        return $fields;
    }
}

//Save the new meta added by theme  submitted by the user.
add_action( 'comment_post', 'finanzia_comment_rating_save_comment_meta' );
if(!function_exists('finanzia_comment_rating_save_comment_meta')){
    function finanzia_comment_rating_save_comment_meta( $comment_id ) {
        $rating = $address = '';
        // rating
        if ( ( isset( $_POST['rating'] ) ) && ( '' !== $_POST['rating'] ) )
        $rating = intval( $_POST['rating'] );
        // address
        if ( ( isset( $_POST['address'] ) ) && ( '' !== $_POST['address'] ) )
        $address = sanitize_text_field($_POST['address']);
        add_comment_meta( $comment_id, 'rating', $rating );
        add_comment_meta( $comment_id, 'address', $address );
    }
}
// Make the rating required.
add_filter( 'preprocess_comment', 'finanzia_comment_rating_require_rating' );
if(!function_exists('finanzia_comment_rating_require_rating')){
    
    function finanzia_comment_rating_require_rating( $commentdata ) {
        $show_rating = finanzia_get_opt('post_comments_rating_on','0');
        if('1' !== $show_rating) return $commentdata;

        if ( ! is_admin() && ( ! isset( $_POST['rating'] ) || 0 === intval( $_POST['rating'] ) ) )
        wp_die( esc_html__( 'Error: You did not add a rating. Hit the Back button on your Web browser and resubmit your comment with a rating.','finanzia' ) );
        return $commentdata;
    }
}

//Display the rating on a submitted comment.
if(!function_exists('finanzia_comment_rating_display_rating')){
    //add_filter( 'comment_text', 'finanzia_comment_rating_display_rating');
    function finanzia_comment_rating_display_rating( $comment_text ){
        if ( $rating = get_comment_meta( get_comment_ID(), 'rating', true ) ) {
            $stars = '<div class="stars">';
            for ( $i = 1; $i <= $rating; $i++ ) {
                $stars .= '<span class="rating-icon cms-rating-icon-filled"></span>';
            }
            $stars .= '</div>';
            $comment_text = $comment_text . $stars;
            return $comment_text;
        } else {
            return $comment_text;
        }
    }
}

//Get the average rating of a post.
if(!function_exists('finanzia_comment_rating_get_average_ratings')){
    function finanzia_comment_rating_get_average_ratings( $id ) {
        $comments = get_approved_comments( $id );
        if ( $comments ) {
            $i = 0;
            $total = 0;
            foreach( $comments as $comment ){
                $rate = get_comment_meta( $comment->comment_ID, 'rating', true );
                if( isset( $rate ) && '' !== $rate ) {
                    $i++;
                    $total += $rate;
                }
            }

            if ( 0 === $i ) {
                return false;
            } else {
                return round( $total / $i, 1 );
            }
        } else {
            return false;
        }
    }
}
// Display the star average rating only
if(!function_exists('finanzia_comment_rating_display_average')){
    function finanzia_comment_rating_display_average($args = []) {

        global $post;

        if ( false === finanzia_comment_rating_get_average_ratings( $post->ID ) ) {
            return false;
        }
        $args = wp_parse_args($args, [
            'width' => 20,
            'class' => ''
        ]);
        $stars   = '';
        $average = finanzia_comment_rating_get_average_ratings( $post->ID );

        for ( $i = 1; $i <= $average + 1; $i++ ) {
            
            $width = intval( $i - $average > 0 ? $args['width'] - ( ( $i - $average ) * $args['width'] ) : $args['width'] );

            if ( 0 === $width ) {
                continue;
            }
            $stars .= '<span style="overflow:hidden; width:' . $width . 'px" class="rating-icon cms-rating-icon-filled"></span>';

            if ( $i - $average > 0 ) {
                $stars .= '<span style="overflow:hidden; position:relative; left:-' . ($width - 1) .'px;" class="cms-rating-icon cms-rating-icon-empty"></span>';
            }
        }
        $classes = ['cms-average-rating cms-average-rating-star', $args['class']];
        $custom_content  = '<div class="'.implode(' ', $classes).'">' . $stars .'</div>';
        return $custom_content;
    }
}

//Display the average rating above the content.
if(!function_exists('finanzia_comment_rating_display_average_rating')){
    //add_filter( 'the_content', 'finanzia_comment_rating_display_average_rating' );
    function finanzia_comment_rating_display_average_rating( $content ) {

        global $post;

        if ( false === finanzia_comment_rating_get_average_ratings( $post->ID ) ) {
            return $content;
        }
        
        $stars   = '';
        $average = finanzia_comment_rating_get_average_ratings( $post->ID );

        for ( $i = 1; $i <= $average + 1; $i++ ) {
            
            $width = intval( $i - $average > 0 ? 20 - ( ( $i - $average ) * 20 ) : 20 );

            if ( 0 === $width ) {
                continue;
            }

            $stars .= '<span style="overflow:hidden; width:' . $width . 'px" class="rating-icon cms-rating-icon-filled"></span>';

            if ( $i - $average > 0 ) {
                $stars .= '<span style="overflow:hidden; position:relative; left:-' . $width .'px;" class="rating-icon cms-rating-icon-empty"></span>';
            }
        }
        
        $custom_content  = '<div class="average-rating">This post\'s average rating is: ' . $average .' ' . $stars .'</div>';
        $custom_content .= $content;
        return $custom_content;
    }
}
if(!function_exists('finanzia_comment_rating_display_feedback')){
    function finanzia_comment_rating_display_feedback($args=[]){
        $args = wp_parse_args($args,[
            'id'        => get_the_ID(),
            'mode'      => 'good', //bad
            'good_text' => esc_html__('positive feedback', 'finanzia'),
            'bad_text'  => esc_html__('negative feedback', 'finanzia'),
            'good_icon' => 'icofont-simple-smile',
            'bad_icon'  => 'icofont-sad'
        ]);
        $comments = get_approved_comments( $args['id'] );
        if ( $comments ) {
            $i = 0;
            $total = 0;
            $good_rate = $bad_rate = 0;
            foreach( $comments as $comment ){
                $rate = get_comment_meta( $comment->comment_ID, 'rating', true );
                if( isset( $rate ) && '' !== $rate ) {
                    $i++;
                    $total += $rate;
                }
                if(isset($rate) && $rate > 3){
                    $good_rate ++;
                }
                if(isset($rate) && $rate <= 3){
                    $bad_rate ++;
                }
            }

            if ( 0 === $i ) {
                return false;
            } else {
                //return  $total .' good:'.$good_rate.' bad:'.$bad_rate ;
                if($args['mode'] == 'good'){
                    return '<span class="cms-rating-good text-accent text-17 '.$args['good_icon'].'"></span> <span class="cms-rating-percent text-accent font-700">'.number_format_i18n( $good_rate*100 / $i, 2 ).'%</span> '.$args['good_text'];
                } else {
                    return '<span class="cms-rating-bad text-accent text-17 '.$args['bad_icon'].'"></span> <span class="cms-rating-percent text-accent font-700">'.number_format_i18n( $bad_rate*100 / $i, 2 ).'%</span> '.$args['bad_text'];
                }
            }
        } else {
            return false;
        }
    }
}
// Display the address on a submitted comment.
if(!function_exists('finanzia_comment_display_address')){
    //add_filter( 'comment_text', 'finanzia_comment_rating_display_rating');
    function finanzia_comment_display_address(){
        $address =  get_comment_meta( get_comment_ID(), 'address', true ) ;
        if(empty($address)) return;
        ?>
            <div class="cms-comment-address"><?php echo esc_html($address); ?></div>
        <?php
    }
}
/**
 * Elementor Gradient Options
 * */
if(!function_exists('finanzia_elementor_gradient_opts')){
    function finanzia_elementor_gradient_opts(){
        return array(
            ''                         => esc_html__('Default', 'finanzia' ),
            'dark-above-img'           => esc_html__('Dark Gradient Above Images', 'finanzia'),
            'dark-above-img2'          => esc_html__('Dark Gradient Above Images #2', 'finanzia'),
            'dark-above-img3'          => esc_html__('Dark Gradient Above Images #3', 'finanzia'),
            'dark-above-img4'          => esc_html__('Dark Gradient Above Images #4', 'finanzia'),
            'dark-above-img5'          => esc_html__('Dark Gradient Above Images #5', 'finanzia'),
            'dark-above-img6'          => esc_html__('Dark Gradient Above Images #6', 'finanzia'),
            '1'                        => esc_html__('Grey - Top to Bottom', 'finanzia'),
            '2'                        => esc_html__('Grey - Top to Bottom #2', 'finanzia'),
            'overlay-accent-darken-15' => esc_html__('Overlay - Accent Darken 15', 'finanzia'),
            'none'                     => esc_html__('None','finanzia')
        );
    }
}
/**
 * Custom Elementor
 * Elementor Container
 * 
 * */
if(!function_exists('finanzia_custom_container_register_controls')){
    add_action('etc-custom-container-register-controls', 'finanzia_custom_container_register_controls');
    function finanzia_custom_container_register_controls($container){
        // Custom
        $container->start_controls_section(
            'finanzia_container_custom',
            [
                'label' => esc_html__( 'Finanzia Custom', 'finanzia' ),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );  
            $container->add_control(
                'content_width_full_custom',
                [
                    'label'   => esc_html__( 'Content Width (Full)', 'finanzia' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        '' => esc_html__( 'Default', 'finanzia' ),
                        'boxed-wide'       => esc_html__( 'Boxed Wide', 'finanzia' ),
                        'full-space-start' => esc_html__( 'Full Width - Space Start', 'finanzia' ),
                        'full-space-end'   => esc_html__( 'Full Width - Space End', 'finanzia' ),
                        'full-header-left'   => esc_html__( 'Full Width - Header Left', 'finanzia' )
                    ],
                    'default'            => '',
                    'render_type'        => 'template',
                    'prefix_class'       => 'e-con-',
                    'editor_available'   => true,
                    'condition'          => [
                        'content_width' => [
                            'full'
                        ]
                    ]
                ]
            );
            $container->add_control(
                'container_width',
                [
                    'label'   => esc_html__( 'Container Width', 'finanzia' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        ''      => esc_html__( 'Default', 'finanzia' ),
                        'boxed' => esc_html__( 'Boxed', 'finanzia' )
                    ],
                    'default' => '',
                    'prefix_class' => 'cms-econ-',
                    'description'  => esc_html__('This option just apply for Parent container', 'finanzia')
                ]
            );
            $container->add_control(
                'container_space',
                [
                    'label'   => esc_html__( 'Container Space', 'finanzia' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        ''      => esc_html__( 'Default', 'finanzia' ),
                        'nospace' => esc_html__( 'No Space', 'finanzia' )
                    ],
                    'default' => '',
                    'prefix_class' => 'cms-econ-'
                ]
            );
            $container->add_control(
                'container_gradient',
                [
                    'label'              => esc_html__( 'Container Gradient', 'finanzia' ),
                    'type'               => Controls_Manager::SELECT,
                    'default'            => '',
                    'options'            => finanzia_elementor_gradient_opts(),
                    'frontend_available' => true 
                ]
            );
            $container->add_control(
                'container_bg',
                [
                    'label'       => esc_html__( 'Container Shape Color', 'finanzia' ),
                    'description' => esc_html__('Container Shape','finanzia'),
                    'type'        => Controls_Manager::COLOR,
                    'label_block' => false,
                    'selectors' => [
                        '{{WRAPPER}} .cms-econ-banner' => 'background-color:{{VALUE}};'
                    ],
                    //'separator' => 'before',
                    'classes' => 'cms-eseparator cms-description-as-label'
                ]
            );
            $container->add_control(
                'container_banner',
                [
                    'label'       => esc_html__( 'Container Shape Image', 'finanzia' ),
                    'type'        => Controls_Manager::MEDIA,
                    'label_block' => false,
                    'selectors' => [
                        '{{WRAPPER}} .cms-econ-banner' => '--cms-bg-lazyload: url("{{URL}}");background-image:var(--cms-bg-lazyload-loaded);'
                    ]
                ]
            );
            $container->add_responsive_control(
                'container_banner_width',
                [
                    'label'       => esc_html__( 'Container Shape Width', 'finanzia' ),
                    'type'        => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%'],
                    'range' => [
                        'px' => [
                            'min'  => 0, 
                            'max'  => 2560,
                            'step' => 1
                        ],
                        '%' => [
                            'min'  => 0, 
                            'max'  => 100,
                            'step' => 1
                        ]
                    ],
                    'default' => [
                        'unit' => '%',
                        'size' => 50,
                    ],
                    'selectors'    => [
                        '{{WRAPPER}} .cms-econ-banner' => 'width: {{SIZE}}{{UNIT}};',
                    ]
                ]
            );
            $container->add_control(
                'container_banner_pos',
                [
                    'label'       => esc_html__( 'Container Shape Position', 'finanzia' ),
                    'type'        => Controls_Manager::SELECT,
                    'label_block' => false,
                    'options'     => [
                        'left'       => esc_html__('Left', 'finanzia'),
                        'right'      => esc_html__('Right', 'finanzia'),
                        'full-start' => esc_html__('Full Left', 'finanzia'),
                        'full-end'   => esc_html__('Full Right', 'finanzia'),
                        'full-boxed-start' => esc_html__('Full Boxed Left', 'finanzia'),
                        'full-boxed-end'   => esc_html__('Full Boxed Right', 'finanzia')
                    ],
                    'default' => 'left'
                ]
            );
            // Container Pattern
            $container->add_control(
                'container_pattern_type',
                [
                    'description' => esc_html__('Container Pattern', 'finanzia'),
                    'label'       => esc_html__( 'Pattern Type', 'finanzia' ),
                    'type'        => Controls_Manager::SELECT,
                    'label_block' => false,
                    'options' => [
                        //'icon'  => esc_html__('Icon','finanzia'),
                        'image' => esc_html__('Image','finanzia'),
                        ''      => esc_html__('None','finanzia'),
                    ],
                    'default'   => '',
                    //'separator' => 'before',
                    'classes'   => 'cms-eseparator cms-description-as-label'
                ]
            );
            $container->add_control(
                'container_pattern_icon',
                [
                    'label'       => esc_html__('Pattern Icon','finanzia'),
                    'type'        => Controls_Manager::ICONS,
                    'default'     => [],
                    'skin'        => 'inline',
                    'label_block' => false,
                    'condition'   => [
                        'container_pattern_type' => 'icon'
                    ]
                ]
            );
            $container->add_control(
                'container_pattern_image',
                [
                    'label'       => esc_html__('Pattern Image', 'finanzia'),
                    'type'        => Controls_Manager::MEDIA,
                    'default'     => [],
                    'skin'        => 'inline',
                    'label_block' => false,
                    'condition'   => [
                        'container_pattern_type' => 'image'
                    ]
                ]
            );
            $container->add_control(
                'container_pattern_image_dimension',
                [
                    'label'       => esc_html__( 'Pattern Dimension', 'finanzia' ),
                    'type'        => Controls_Manager::IMAGE_DIMENSIONS,
                    'description' => esc_html__( 'Enter size in Pixel. You can also set a single value for height or width in order to keep the original size ratio.', 'finanzia' ),
                    'condition' => [
                        'container_pattern_type!' => '',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .cms-econ-pattern'     => 'width:{{WIDTH}}px; height:{{HEIGHT}}px;',
                        '{{WRAPPER}} .cms-econ-pattern img' => 'width:{{WIDTH}}px; height:{{HEIGHT}}px;',
                        '{{WRAPPER}} .cms-econ-pattern svg' => 'width:{{WIDTH}}px; height:{{HEIGHT}}px;'
                    ]
                ]
            );
            $container->add_control(
                'container_pattern_color',
                [
                    'label' => esc_html__('Pattern Icon Color','finanzia'),
                    'type'  => Controls_Manager::COLOR,
                    'condition' => [
                        'container_pattern_type' => 'icon',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .cms-econ-pattern' => 'color:{{VALUE}};'
                    ]
                ]
            );
            $container->add_control(
                'container_pattern_pos',
                [
                    'label'       => esc_html__('Pattern Position', 'finanzia'),
                    'type'        => Controls_Manager::SELECT,
                    'options' => [
                        'top-left'      => esc_html__('Top Left','finanzia'),
                        'top-right'     => esc_html__('Top Right','finanzia'),
                        'top-center'    => esc_html__('Top Center','finanzia'),
                        'center-left'   => esc_html__('Center Left','finanzia'),
                        'center-right'  => esc_html__('Center Right','finanzia'),
                        'center-center' => esc_html__('Center Center','finanzia'),
                        'bottom-left'   => esc_html__('Bottom Left','finanzia'),
                        'bottom-right'  => esc_html__('Bottom Right','finanzia'),
                        'bottom-center' => esc_html__('Bottom Center','finanzia'),
                        'custom'        => esc_html__('Custom','finanzia'),
                        ''              => esc_html__('Default','finanzia'),
                    ],
                    'default'     => '',
                    'label_block' => false,
                    'condition'   => [
                        'container_pattern_type!' => ''
                    ]
                ]
            );
            $container->add_control(
                'container_pattern_pos_space_start',
                [
                    'label'      => esc_html__( 'Pattern Space Start', 'finanzia' ),
                    'type'       => Controls_Manager::SLIDER,
                    //'responsive' => true,
                    'size_units' => [],
                    'default'    => [
                        'size' => '',
                    ],
                    'range' => [
                        'px' => [
                            'min' => -1200,
                            'max' => 1200,
                        ],
                    ],
                    'condition' => [
                        'container_pattern_pos' => [
                            'top-left',
                            'center-left',
                            'bottom-left'
                        ]
                    ],
                    //'separator' => 'before',
                    'classes'   => 'cms-eseparator',
                    'selectors' => [
                        '{{WRAPPER}} .cms-econ-pattern' => 'margin-inline-start:{{SIZE}}{{UNIT}}'
                    ]
                ]
            );
            $container->add_control(
                'container_pattern_pos_space_end',
                [
                    'label'      => esc_html__( 'Pattern Space End', 'finanzia' ),
                    'type'       => Controls_Manager::SLIDER,
                    //'responsive' => true,
                    'size_units' => [],
                    'default'    => [
                        'size' => '',
                    ],
                    'range' => [
                        'px' => [
                            'min' => -1200,
                            'max' => 1200,
                        ],
                    ],
                    'condition' => [
                        'container_pattern_pos' => [
                            'top-left',
                            'center-left',
                            'bottom-left'
                        ]
                    ],
                    //'separator' => 'before',
                    'classes'   => 'cms-eseparator',
                    'selectors' => [
                        '{{WRAPPER}} .cms-econ-pattern' => 'margin-inline-end:{{SIZE}}{{UNIT}}'
                    ]
                ]
            );
            $container->add_responsive_control(
                'xpos',
                [
                    'label' => esc_html__( 'X Position', 'finanzia' ),
                    'type' => Controls_Manager::SLIDER,
                    //'responsive' => true,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
                    'default' => [
                        'size' => 0,
                    ],
                    'tablet_default' => [
                        'size' => 0,
                    ],
                    'mobile_default' => [
                        'size' => 0,
                    ],
                    'range' => [
                        'px' => [
                            'min' => -800,
                            'max' => 800,
                        ],
                        'em' => [
                            'min' => -100,
                            'max' => 100,
                        ],
                        '%' => [
                            'min' => -100,
                            'max' => 100,
                        ],
                        'vw' => [
                            'min' => -100,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{SELECTOR}} .cms-econ-pattern' => 'left: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'container_pattern_pos' => [ 'custom' ]
                    ]
                ]
            );

            $container->add_responsive_control(
                'ypos',
                [
                    'label'      => esc_html__( 'Y Position', 'finanzia' ),
                    'type'       => Controls_Manager::SLIDER,
                    //'responsive' => true,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'vh', 'custom' ],
                    'default'    => [
                        //'size' => 0,
                    ],
                    'tablet_default' => [
                        //'size' => 0,
                    ],
                    'mobile_default' => [
                        //'size' => 0,
                    ],
                    'range' => [
                        'px' => [
                            'min' => -800,
                            'max' => 800,
                        ],
                        'em' => [
                            'min' => -100,
                            'max' => 100,
                        ],
                        '%' => [
                            'min' => -100,
                            'max' => 100,
                        ],
                        'vh' => [
                            'min' => -100,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{SELECTOR}} .cms-econ-pattern' => 'top:{{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'container_pattern_pos' => [ 'custom' ]
                    ]
                ]
            );
            $container->add_control(
                'parallax_yaxis',
                [
                    'label'      => esc_html__( 'Parallax Pattern Y Axis', 'finanzia' ),
                    'type'       => Controls_Manager::SLIDER,
                    //'responsive' => true,
                    'size_units' => [],
                    'default'    => [
                        'size' => 230,
                    ],
                    'range' => [
                        'px' => [
                            'min' => -2000,
                            'max' => 2000,
                        ],
                    ],
                    'condition' => [
                        'container_pattern_type!' => ''
                    ],
                    'separator' => 'before',
                    'classes'   => 'cms-eseparator'
                ]
            );
        $container->end_controls_section();
    }
}
/**
 * Add custom Container HTML in Elementor Editor
 * Container Gradient
 * 
 * */
add_filter('etc-custom-container/before-elementor-editor-container', 'finanzia_before_elementor_editor_container');
if(!function_exists('finanzia_before_elementor_editor_container')){
    function finanzia_before_elementor_editor_container(){
    ?>
        <# if('' !== settings.container_gradient) { #>
            <div class="cms-gradient-render cms-econ-gradient cms-gradient-{{settings.container_gradient}} cms-overlay"></div>
        <# } #>
        <# if('' !== settings.container_banner.id || '' !== settings.container_bg) { #>
            <div class="cms-econ-banner cms-lazy absolute top bottom {{settings.container_banner_pos}}"></div>
        <# } #>
        <# if('image' === settings.container_pattern_type && '' !== settings.container_pattern_image.url) { #>
            <div class="cms-econ-pattern absolute {{settings.container_pattern_pos}}" data-parallax='{"y": "{{settings.parallax_yaxis.size}}" }'><img src="{{settings.container_pattern_image.url}}" alt="<?php echo get_bloginfo('title'); ?>" title="<?php echo get_bloginfo('title'); ?>" loading="lazy" width="{{settings.container_pattern_image_dimension.width}}" height="{{settings.container_pattern_image_dimension.height}}"></div>
        <# } #>
        <# if('icon' === settings.container_pattern_type && '' !== settings.container_pattern_icon.value.id) { #>
            <div class="cms-econ-pattern absolute {{settings.container_pattern_pos}}" data-parallax='{"y":230}'>Icon Here</div>
        <# } #>
    <?php
    }
}
/**
 * Add custom Container HTML in Elementor Frontend
 * Container Gradient
 * 
 * */
add_filter('etc-custom-container/before-elementor-container', 'finanzia_before_elementor_container', 10, 2);
if(!function_exists('finanzia_before_elementor_container')){
    function finanzia_before_elementor_container($html, $settings){
        // Gradient
        if( isset($settings['container_gradient']) && '' !== $settings['container_gradient']) {
            $html .= '<div class="cms-gradient-render cms-econ-gradient cms-gradient-'.$settings['container_gradient'].' cms-overlay"></div>';
        }
        // Shape
        if( (isset($settings['container_banner']) && '' !== $settings['container_banner']['id']) || (isset($settings['container_bg']) && '' !== $settings['container_bg']) ) {
            $html .= '<div class="cms-econ-banner cms-lazy absolute top bottom '.$settings['container_banner_pos'].'"></div>';
        }
        // Pattern Image
        $container_pattern_image_dimension_w = isset($settings['container_pattern_image_dimension']) ? $settings['container_pattern_image_dimension']['width'] : '100%';
        $container_pattern_image_dimension_h = isset($settings['container_pattern_image_dimension']) ? $settings['container_pattern_image_dimension']['height'] : '100%';

        if( isset($settings['container_pattern_type']) && 'image' === $settings['container_pattern_type'] && '' !== $settings['container_pattern_image']['url'] ) {
            $html .= '<div class="cms-econ-pattern absolute '.$settings['container_pattern_pos'].'" data-parallax={"y":'.$settings['parallax_yaxis']['size'].'}><img src="'.$settings['container_pattern_image']['url'].'" title="'.\Elementor\Control_Media::get_image_title( $settings['container_pattern_image'] ).'" alt="'.\Elementor\Control_Media::get_image_title( $settings['container_pattern_image'] ).'" width="'.$container_pattern_image_dimension_w.'" height="'.$container_pattern_image_dimension_h.'" loading="lazy"/></div>';
        }
        // Pattern Icon
        if( isset($settings['container_pattern_type']) && 'icon' === $settings['container_pattern_type'] && '' !== $settings['container_pattern_icon']['url'] ) {
            ob_start();
                \Elementor\Icons_Manager::render_icon( $settings['container_pattern_icon'], [ 'aria-hidden' => 'true' ] );
            $container_pattern_icon = ob_get_clean();
            $html .= '<div class="cms-econ-pattern absolute '.$settings['container_pattern_pos'].'" data-parallax={"y":230}>'.$container_pattern_icon.'</div>';
        }
        return $html;
    }
}
/**
 * Custom Elementor
 * Elementor Shapes
 * 
 * */
add_filter('elementor/shapes/additional_shapes', 'finanzia_additional_shapes');
function finanzia_additional_shapes(){
    $shapes = [
        'cms-radius-top' => [
            'title'        => esc_html__( 'CMS Radius Top', 'finanzia' ),
            'url'          => get_stylesheet_directory_uri() . '/assets/shapes/radius-top.svg',
            'path'         => get_stylesheet_directory() . '/assets/shapes/radius-top.svg',
            'has_flip'     => true,
            'has_negative' => false,
            //'color'      => false 
            'height_only'  => true
        ],
        'cms-radius-bot' => [
            'title'        => esc_html__( 'CMS Radius Bottom', 'finanzia' ),
            'url'          => get_stylesheet_directory_uri() . '/assets/shapes/radius-bottom.svg',
            'path'         => get_stylesheet_directory() . '/assets/shapes/radius-bottom.svg',
            'has_flip'     => true,
            'has_negative' => false,
            //'color'      => false 
            'height_only'  => true
        ]
    ];
    return $shapes;
}

/**
 *  Filter add svg icon to image content
 * 
*/
add_filter('elementor/extended_allowed_html_tags/image', function () {
    $image = \Elementor\Utils::EXTENDED_ALLOWED_HTML_TAGS['image'];
    $svg = \Elementor\Utils::EXTENDED_ALLOWED_HTML_TAGS['svg'];
    return array_merge($image, $svg);
});
// Change html tag for Elementor image render
if(!function_exists('finanzia_elementor_image_size_get_attachment_image_html')){
    add_filter('elementor/image_size/get_attachment_image_html','finanzia_elementor_image_size_get_attachment_image_html', 10, 4);
    function finanzia_elementor_image_size_get_attachment_image_html($html, $settings, $image_size_key, $image_key){
        // Check variation for custom
        $settings['attachment_id'] = isset($settings['attachment_id']) ? $settings['attachment_id'] : '';
        $settings['as_background'] = isset($settings['as_background']) ? $settings['as_background'] : false;
        if($settings['as_background'] === true) $settings['as_background'] = 'yes';
        $settings['as_background_class'] = isset($settings['as_background_class']) ? $settings['as_background_class'] : '';
        $settings['max_height'] = isset($settings['max_height']) ? $settings['max_height'] : false;
        $settings['min_height'] = isset($settings['min_height']) ? $settings['min_height'] : false;
        $settings['lazy'] = isset($settings['lazy']) ? $settings['lazy'] : false;
        $settings['duration'] = isset($settings['duration']) ? $settings['duration'] : '';
        $settings['attrs'] = isset($settings['attrs']) ? $settings['attrs'] : [];
        // \Elementor\Group_Control_Image_Size::print_attachment_image_html( $settings, $args['image_size_key'], $args['name'] )
        //
        if ( ! $image_key ) {
            $image_key = $image_size_key;
        }
        $image = $settings[ $image_key ];
        if ( ! isset($settings[ $image_size_key . '_size' ]) || empty($settings[ $image_size_key . '_size' ]) ) {
            $settings[ $image_size_key . '_size' ] = $settings['size'];
        }
        // Lazy attribute
        $lazy_attr = '';
        if($settings['lazy']) $lazy_attr = ' loading="lazy"';

        $size = $settings[ $image_size_key . '_size' ];
        $image_class = $overlay_class = ['cms-lazy lazy-loading'];
        $image_class[] = isset($settings['img_class']) ? $settings['img_class'] : '';
        $image_class[] = ! empty( $settings['hover_animation'] ) ? 'elementor-animation-' . $settings['hover_animation'] : '';
        $image_class = implode(' ', array_filter($image_class));
        $overlay_class = implode(' ', array_filter($overlay_class));
        $html = '';
        // If is the new version - with image size.
        $image_sizes = get_intermediate_image_sizes();
        $image_sizes[] = 'full';

        if ( ! empty( $image['id'] ) && ! wp_attachment_is_image( $image['id'] ) ) {
            $image['id'] = '';
        }
        $is_static_render_mode = \Elementor\Plugin::$instance->frontend->is_static_render_mode();
        // On static mode don't use WP responsive images.
        if ( ! empty($image['id']) ) {
            $image_bg = wp_get_attachment_image_src( $image['id'], 'full');
        } else {
            $image_bg = [Utils::get_placeholder_image_src()];
        }

        // custom attrs class
        if(isset($settings['attrs']['class'])){
            $image_class .= ' '.$settings['attrs']['class'];
            unset($settings['attrs']['class']);
        }
        // overlay background
        if($settings['as_background'] == 'overlay'){
            $settings['min_height'] = true;
            $overlay_class .= ' relative '.$settings['img_class'];
            $image_class .= ' cms-overlay img-cover';
        }
        // as background
        if($settings['as_background'] == 'yes' ){
            $overlay_class .= ' cms-bg-cover '.$settings['as_background_class'];
        }
        // Render
        if ( ! empty( $image['id'] ) && in_array( $size, $image_sizes ) && ! $is_static_render_mode ) {
            // image attributes
            $image_attr = wp_get_attachment_image_src( $image['id'], $size);
            $image_attr['style'] = $image_overlay_style = '';
            // if have max-height style
            if($settings['max_height']){
                $image_attr['style'] .= 'max-height:'.$image_attr[2].'px;';
                $image_overlay_style .= 'max-height:'.$image_attr[2].'px;';
            }
            if($settings['min_height']){
                $image_attr['style'] .= 'min-height:'.$image_attr[2].'px;';
                $image_overlay_style .= 'min-height:'.$image_attr[2].'px;';
            }
            // As background style
            if($settings['as_background']){
                $image_attr['style'] .= '--cms-bg-lazyload:url('.$image_bg[0].');background-image:var(--cms-bg-lazyload-loaded);';
                if($settings['aspect_ratio']){
                    $image_attr['style'] .= 'aspect-ratio:'.$image_attr[1].'/'.$image_attr[2].';';
                }
            }
            // As Background Fix 
            $as_backgound_fix = '<div style="aspect-ratio:'.$image_attr[1].'/'.$image_attr[2].';max-width:'.$image_attr[1].'px; max-height:'.$image_attr[2].'px;"></div>';
            // image html
            $image_html_attrs = [ 'class'=> $image_class, 'loading' => 'lazy'];
            $image_html_attrs['data-duration'] =  $settings['duration'];
            $image_html_attrs['style'] =  $image_attr['style'];

            // custom attrs
            foreach ($settings['attrs'] as $key => $value) {
                $image_html_attrs[$key] = $value;
            }

            $image_html = wp_get_attachment_image( $image['id'], $size, false, $image_html_attrs);
            switch ($settings['as_background']) {
                case 'overlay':
                        $html = sprintf(
                            '<div class="%s" style="%s" data-as-background="%s">%s%s</div>',
                            $overlay_class,
                            $image_overlay_style,
                            $settings['as_background'],
                            $image_html,
                            $settings['content']
                        );
                        break;
                case 'yes' :
                    $html = sprintf(
                        '<div class="%s" style="%s" data-as-background="%s">%s%s</div>',
                        $overlay_class,
                        $image_attr['style'],
                        $settings['as_background'],
                        empty($settings['content']) ? $as_backgound_fix : '',
                        $settings['content']
                    );
                break;
                default:
                    $html = $image_html;
                break;
            }
        } else {
            $custom_dimension = isset($settings[ $image_key . '_custom_dimension' ]) ? $settings[ $image_key . '_custom_dimension' ] : ['width' => get_option('large_size_w'), 'height' => get_option('large_size_h')];
            $custom_dimension =  wp_parse_args($custom_dimension, ['width'=>'','height' => '']);
            $image_src = \Elementor\Group_Control_Image_Size::get_attachment_image_src( $image['id'], $image_size_key, $settings );
            if ( ! $image_src && isset( $image['url'] ) ) {
                $image_src = $image['url'];
            }

            if ( ! empty( $image_src ) ) {
                //$image_class_html = ! empty( $image_class ) ? ' class="' . $image_class . '"' : '';
                $image_style = $image_overlay_style = $data_bg = '';
                
                if($settings['as_background']){
                    $data_bg = '';
                    $image_style .= '--cms-bg-lazyload:url('.$image_bg[0].');background-image:var(--cms-bg-lazyload-loaded);';
                    
                    if($settings['aspect_ratio']){
                        $image_style .= 'aspect-ratio:'.$custom_dimension['width'].'/'.$custom_dimension['height'].';';
                    }
                }
                
                // if have max-height style
                $max_height = $min_height = '';
                if($settings['max_height']){
                    $max_height = 'max-height:'.$custom_dimension['height'].'px;';
                    $image_style .= $max_height;
                    $image_overlay_style .= $max_height;
                }
                if($settings['min_height']){
                    $min_height = 'min-height:'.$custom_dimension['height'].'px;';
                    $image_style .= $min_height;
                    $image_overlay_style .= $min_height;
                }

                if(!empty($image_style)) $image_style = ' style="'.$image_style.'"';
                if(!empty($image_overlay_style)) $image_overlay_style = ' style="'.$image_overlay_style.'"';

                // As Background Fix
                $aspect_ratio_padding = '56.25';
                if($custom_dimension['height']!== 0){
                    $aspect_ratio_padding = ($custom_dimension['width']/$custom_dimension['height'])*100;
                }
                /*$as_backgound_fix = '<div style="aspect-ratio:'.$custom_dimension['width'].'/'.$custom_dimension['height'].';max-width:'.$custom_dimension['width'].'px;max-height:'.$custom_dimension['height'].'px;padding-top:'.$aspect_ratio_padding.'%;"></div>';*/
                $as_backgound_fix = sprintf( '<img width="%s" height="%s" src="%s" class="%s" alt="%s" fetchpriority="high" loading="lazy" />', 
                    $custom_dimension['width'],
                    $custom_dimension['height'],
                    esc_attr( $image_src ), 
                    'as-bg-fix cms-lazy cms-invisible', 
                    \Elementor\Control_Media::get_image_alt( $image )
                );
                // Render
                switch ($settings['as_background']) {
                    case 'overlay':
                        $image = sprintf( '<img width="%s" height="%s" src="%s" class="%s" alt="%s" loading="lazy" />', 
                            $custom_dimension['width'],
                            $custom_dimension['height'],
                            esc_attr( $image_src ), 
                            $image_class, 
                            \Elementor\Control_Media::get_image_alt( $image )
                        );
                        $html = sprintf(
                            '<div class="%1$s" %2$s data-as-background="%3$s">%4$s%5$s</div>',
                            $overlay_class,
                            $image_overlay_style,
                            $settings['as_background'],
                            $image,
                            $settings['content']
                        );
                        break;
                    case 'yes' :
                        $html = sprintf(
                            '<div class="%1$s"%2$s data-as-background="%3$s">%4$s%5$s</div>',
                            $overlay_class,
                            $image_style,
                            $settings['as_background'],
                            empty($settings['content']) ? $as_backgound_fix : '',
                            $settings['content']
                        );
                        break;
                    default:
                        // custom attrs
                        $image_attrs = [];
                        foreach ($settings['attrs'] as $key => $value) {
                            $image_attrs[] = $key.'='.$value;
                        }
                        $_image_attrs = implode(' ', $image_attrs);
                        $html = sprintf( '<img width="%1$s" height="%2$s" src="%3$s" alt="%4$s" %5$s%6$s%7$s %8$s />', 
                            $custom_dimension['width'],
                            $custom_dimension['height'],
                            esc_attr( $image_src ),
                            \Elementor\Control_Media::get_image_alt( $image ),
                            !empty($image_class) ? 'class="'.$image_class.'"' : '',
                            $lazy_attr,
                            $image_style,
                            $_image_attrs
                        );
                        break;
                }
            }
        }
        return $html;
    }
}
// Elementor Image Render
if(!function_exists('finanzia_elementor_image_render')){
    function finanzia_elementor_image_render( $settings = [], $args = []){
        if(!class_exists('\Elementor\Plugin') || !class_exists('Elementor_Theme_Core')) return;
        $args = wp_parse_args($args, [
            'name'                => 'image',
            'attachment_id'       => '',
            'size'                => 'medium',
            'image_size_key'      => '',
            'img_class'           => '',
            'duration'            => '',
            'custom_size'         => ['width' => get_option('medium_size_w'), 'height' => get_option('medium_size_h')],
            'max_height'          => false,
            'min_height'          => false,
            'as_background'       => false,
            'as_background_class' => '',
            'lazy'                => true,
            'content'             => '',   
            'before'              => '',
            'after'               => '',
            'edge'                => [],
            'attrs'               => [],
            'aspect_ratio'        => false  
        ]);
        
        if(empty($args['image_size_key'])) $args['image_size_key'] = $args['name'];
        // image by attachment ID
        if(in_array($args['attachment_id'], ['','0', '-1'])){
            $attachment_url = Utils::get_placeholder_image_src();
        } else {
            $attachment_url = wp_get_attachment_image_url($args['attachment_id'], 'full');
        }
        if(!empty($args['attachment_id']) || $args['attachment_id'] == '0'  || $args['attachment_id'] == '-1'){
            $settings[$args['name']] = [
                'id'  => $args['attachment_id'],
                'url' => $attachment_url
            ];
        }
        $settings['img_class'] = $args['img_class'];
        $settings['duration'] = $args['duration'];
        $settings['aspect_ratio'] = $args['aspect_ratio'];
        
        if(!isset($settings[$args['name'].'_custom_dimension'])){
            $settings[$args['name'].'_custom_dimension'] = $args['custom_size'];
        } else {
            $settings[$args['name'].'_custom_dimension']['width'] = !empty($settings[$args['name'].'_custom_dimension']['width']) ? $settings[$args['name'].'_custom_dimension']['width'] : $args['custom_size']['width'];
            
            $settings[$args['name'].'_custom_dimension']['height'] = !empty($settings[$args['name'].'_custom_dimension']['height']) ? $settings[$args['name'].'_custom_dimension']['height'] : $args['custom_size']['height'];
        }
        // as Background
        $settings['as_background'] = $args['as_background'];
        $settings['as_background_class'] = $args['as_background_class'];
        $settings['content'] = $args['content'];
        // set min/max height
        $settings['min_height'] = $args['min_height'];
        $settings['max_height'] = $args['max_height'];
        //
        $settings['size'] = $args['size'];
        $settings['lazy'] = $args['lazy'];
        $settings['attrs'] = $args['attrs'];
        
        if(empty($settings[$args['name']]['url'])) return;
        printf('%s', $args['before']);
            // Print image
            \Elementor\Group_Control_Image_Size::print_attachment_image_html( $settings, $args['image_size_key'], $args['name'] );
        printf('%s', $args['after']);
    }
}
// Elementor Image Src Render
if(!function_exists('finanzia_elementor_image_src_render')){
    function finanzia_elementor_image_src_render($settings = [], $args = []){
        $args = wp_parse_args($args, [
            'name'           => 'image',
            'attachment_id'  => '',
            'size'           => 'full',
            'custom_size'    => ['width'=>768,'height'=>768],
            'image_size_key' => '',
            'default'        => true,
            'echo'           => true
        ]);
        $settings[$args['image_size_key'].'_size'] = $args['size'];
        $settings[$args['image_size_key'].'_custom_dimension'] = $args['custom_size'];

        $attachment_id = !empty($settings[$args['name']]['id']) ? $settings[$args['name']]['id'] : $args['attachment_id'];
        $image_src = \Elementor\Group_Control_Image_Size::get_attachment_image_src($attachment_id, $args['image_size_key'], $settings);
        if(empty($image_src) && $args['default']){
            $image_src = Utils::get_placeholder_image_src();
        }
        if(empty($image_src)) return false;
        
        if($args['echo']){
            printf('%s', $image_src);
        } else {
            return $image_src;
        }
    }
}
/**
 *  Elementor Button Video Render
 * */
// Elementor Button Video Stroke
if(!function_exists('finanzia_elementor_button_video_stroke')){
    function finanzia_elementor_button_video_stroke($args = []){
        $args = wp_parse_args($args, [
            'width'       => 232,
            'height'      => 232,
            'color'       => 'var(--cms-primary)',
            'color_hover' => 'var(--cms-accent)',
            'class'       => '',
            'icon'        => ''
        ]);
        $classes = ['cms-video-play-stroke', $args['class']];
    ?>
        <div class="cms-video-playstroke relative cms-transition">
            <svg class="<?php echo finanzia_nice_class($classes); ?>" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="<?php echo esc_attr($args['width']).'px'; ?>" height="<?php echo esc_attr($args['height'].'px'); ?>" viewBox="0 0 300 300" style="enable-background:new 0 0 300 300;" xml:space="preserve">
                <circle class="cms-stroke-1" fill="none" stroke="<?php echo esc_attr($args['color']); ?>" cx="150" cy="150" r="149"></circle>
                <circle class="cms-stroke-2" fill="none" stroke="<?php echo esc_attr($args['color_hover']) ?>" cx="150" cy="150" r="149"></circle>
            </svg>
            <?php printf('%s', $args['icon']); ?>
        </div>
    <?php
    }
}
if(!function_exists('finanzia_elementor_button_video_render')){
    function finanzia_elementor_button_video_render($widget = [], $settings = [], $args = []){
        $args = wp_parse_args($args, [
            '_id'        => '',   
            'name'       => 'video_link',
            'layout'     => '1',
            // text
            'text'       => '',
            'text_class' => 'flex-basic',
            'text_attrs' => [],
            //icon
            'icon'       => [
                'value'   => [
                    'url' => get_template_directory().'/assets/svgs/core/play.svg'
                ],
                'library' => 'svg'
            ],
            'icon_class'   => 'flex-auto',
            'icon_size'    => '20',
            'icon_color'   => '',
            'icon_before'  => '',
            'icon_after'   => '', 
            'icon_content' => '', 
            //class
            'class'         => '',
            // inner
            'inner_class'   => '',
            //content
            'content_class' => 'd-flex gap-10 align-items-center',

            'echo'          => true,
            'attrs'         => [],
            'loop'          => false,
            'loop_key'      => '',
            // circle
            'circle_settings' => [
                'class'      => '',
                'dimensions' => 145,
                'background' => 'white',
                'color'      => 'primary',
                'text'       => '',
                'echo'       => true,
                'before'     => '',
                'after'      => '',
                // 
                'svg_class'  => 'cms-spin ls-4',
                'icon'       => false
            ],
            // stroke 
            'stroke'      => false,
            'stroke_opts' => [
                'width'  => 140,
                'height' => 140,
                'color'       => '',
                'color_hover' => '',
                'class'       => '' 
            ],
            // Default
            'default'        => '',
            // custom html
            'before'         => '',
            'after'          => '',
            'content_before' => '',
            'content_after'  => '',
            'lightbox'       => 'yes'
        ]);

        $video_url = !empty($settings[$args['name']]) ? $settings[$args['name']] : $args['default'];
        if(empty($video_url)) return;

        $lightbox_id = 'cms-lightbox-'.$widget->get_setting('element_id', $args['_id']);
        
        $embed_params = [
            'mode'           => 'opaque',   
            'loop'           => 1,
            'autoplay'       => 1,
            'controls'       => 1,
            'mute'           => 0,
            'rel'            => 0,
            'modestbranding' => 0
        ];
        $embed_options = [];
        $lightbox_options = [
            'type'         => 'video',
            'videoType'    => 'youtube',
            'url'          => \Elementor\Embed::get_embed_url( $video_url, $embed_params, $embed_options ),
            'modalOptions' => [
                'id'                       => $lightbox_id,
                'entranceAnimation'        => '',
                'entranceAnimation_tablet' => '',
                'entranceAnimation_mobile' => '',
                'videoAspectRatio'         => 169 
            ]
        ];

        if(!$args['loop']){
            $video_key = 'video-attrs';
            $widget->add_render_attribute($video_key, [
                'class' => finanzia_nice_class([
                    'cms-btn-video', 
                    'layout-'.$args['layout'], 
                    $args['class'], 
                    'cms-transition'
                ])
            ]);
            if($args['lightbox']){
                $widget->add_render_attribute($video_key, [
                    'data-elementor-open-lightbox' => 'yes',
                    'data-elementor-lightbox'      => wp_json_encode( $lightbox_options )
                ]);
            }
            $widget->add_render_attribute($video_key, $args['attrs']);
            // inner
            $video_inner_key = 'video-inner-key';
            $widget->add_render_attribute($video_inner_key, [
                'class' => finanzia_nice_class([
                    'cms-btn--video',
                    $args['inner_class']
                ])
            ]);
            // Stroke
            if($args['stroke']){
                $widget->add_render_attribute($video_key, [
                    'class' => 'has-stroke'
                ]);
                //
                $widget->add_render_attribute($video_inner_key, [
                    'style' => 'width:'.$args['stroke_opts']['width'].'px;height:'.$args['stroke_opts']['height'].'px;'
                ]);
            }
        } else {
            $video_key = $widget->get_repeater_setting_key( 'video_key', 'cms_video', $args['loop_key'] );
            $widget->add_render_attribute($video_key, [
                'class' => finanzia_nice_class([
                    'cms-btn-video', 
                    'layout-'.$args['layout'], 
                    $args['class'], 
                    'cms-transition'
                ])
            ]);
            if($args['lightbox']){
                $widget->add_render_attribute($video_key, [
                    'data-elementor-open-lightbox' => 'yes',
                    'data-elementor-lightbox'      => wp_json_encode( $lightbox_options )
                ]);
            }
            $widget->add_render_attribute($video_key, $args['attrs']);
            // inner
            $video_inner_key = $widget->get_repeater_setting_key( 'video-inner-key', 'cms_video', $args['loop_key'] );
            $widget->add_render_attribute($video_inner_key, [
                'class' => finanzia_nice_class([
                    'cms-btn--video',
                    $args['inner_class']
                ])
            ]);
            // Stroke
            if($args['stroke']){
                $widget->add_render_attribute($video_key, [
                    'class' => 'has-stroke'
                ]);
                //
                $widget->add_render_attribute($video_inner_key, [
                    'style' => 'width:'.$args['stroke_opts']['width'].'px;height:'.$args['stroke_opts']['height'].'px;'
                ]);
            }
        }
        // content class
        $video_content_classe = ['cms-btn-video-content', $args['content_class']];
        // Text
        $widget->add_render_attribute('text',[
            'class' => [
                'cms-text empty-none',
                $args['text_class']
            ]
        ]);
        $widget->add_render_attribute('text',$args['text_attrs']);
        // Output
        ob_start();
            printf('%s', $args['before']);
        ?>
            <div <?php etc_print_html($widget->get_render_attribute_string($video_key)); ?>>
                <div <?php etc_print_html($widget->get_render_attribute_string($video_inner_key)); ?>>
                    <?php printf('%s', $args['content_before']); ?>
                    <div class="<?php echo finanzia_nice_class($video_content_classe); ?>">
                        <?php 
                        switch ($args['layout']) {
                            case 'circle-text':
                                // play icon
                                finanzia_elementor_icon_render($args['icon'], [], [
                                    'arial-hidden' => "true", 
                                    'class'        => ['cms-play-icon cms-icon', 'cms-transition', $args['icon_class']], 
                                    'icon_size'    => $args['icon_size'], 
                                    'icon_color'   => $args['icon_color'] 
                                ]);
                                // Circle Text
                                finanzia_circle_text($widget, $settings, $args['circle_settings']);
                                break;
                            default:
                                if($args['stroke']){
                                    finanzia_elementor_button_video_stroke($args['stroke_opts']);
                                }
                                    finanzia_elementor_icon_render($args['icon'], [], [
                                        'arial-hidden' => "true", 
                                        'class'        => ['cms-play-icon cms-icon', 'cms-transition', $args['icon_class']], 
                                        'icon_size'    => $args['icon_size'], 
                                        'icon_color'   => $args['icon_color'],
                                        'before'       => $args['icon_before'], 
                                        'after'        => $args['icon_after'],
                                        'content'      => $args['icon_content'] 
                                    ]);
                                ?>
                                <span <?php etc_print_html($widget->get_render_attribute_string('text')); ?>><?php etc_print_html($args['text']) ?></span>
                        <?php 
                            break;
                        } ?>
                    </div>
                    <?php  printf('%s', $args['content_after']); ?>
                </div>
            </div>
        <?php
            printf('%s', $args['after']);
        if($args['echo']){
            echo ob_get_clean();
        } else {
            return ob_get_clean();
        }
    }
}
// Elementor Post Image Render
if(!function_exists('finanzia_elementor_post_thumbnail_render')){
    function finanzia_elementor_post_thumbnail_render( $settings = [], $args = []){
        if(!class_exists('\Elementor\Plugin') || !class_exists('Elementor_Theme_Core')) return;
        $args = wp_parse_args($args, [
            'post_id'        => '',
            'image_size_key' => 'thumbnail',
            'size'           => 'custom',
            'custom_size'    => ['width' => get_option('medium_size_w'), 'height' => get_option('medium_size_h')],
            'lazy'           => true,
            'as_background'  => false,
            'max_height'     => false,   
            'min_height'     => false,
            'img_class'      => '',
            'content'        => '',
            'before'         => '',
            'after'          => ''
        ]);

        $settings['img_class']  = $args['img_class'];
        $settings['min_height'] = $args['min_height'];
        $settings['max_height'] = $args['max_height'];
        $settings['size']       = $args['size'];
        $settings['lazy']       = $args['lazy'];
        // as Background
        $settings['as_background'] = $args['as_background'];
        $settings['content'] = $args['content'];
        
        // post thumbnail or placeholder image
        $settings[$args['image_size_key']] = [
            'id'  => get_post_thumbnail_id($args['post_id']),
            'url' => !empty(get_the_post_thumbnail_url($args['post_id'])) ? get_the_post_thumbnail_url($args['post_id']) : \Elementor\Utils::get_placeholder_image_src()
        ];
        $settings[$args['image_size_key'].'_size'] = isset($settings[$args['image_size_key'].'_size']) ? $settings[$args['image_size_key'].'_size'] : $args['size'];

        if(!isset($settings[$args['image_size_key'].'_custom_dimension'])){
            $settings[$args['image_size_key'].'_custom_dimension'] = $args['custom_size'];
        } else {
            $settings[$args['image_size_key'].'_custom_dimension']['width'] = !empty($settings[$args['image_size_key'].'_custom_dimension']['width']) ? $settings[$args['image_size_key'].'_custom_dimension']['width'] : $args['custom_size']['width'];
            
            $settings[$args['image_size_key'].'_custom_dimension']['height'] = !empty($settings[$args['image_size_key'].'_custom_dimension']['height']) ? $settings[$args['image_size_key'].'_custom_dimension']['height'] : $args['custom_size']['height'];
        }
        printf('%s', $args['before']);
        // Print image
        \Elementor\Group_Control_Image_Size::print_attachment_image_html( $settings, $args['image_size_key'], $args['image_size_key'] );
        printf('%s', $args['after']);
    }
}
/**
 * Finanzia Elementor Animation
 * 
 * */
function finanzia_elementor_animation_settings($widget, $args = []){
    $args = wp_parse_args($args, [
        'name'            => 'cms_animation',
        'group'           => true,
        'tab'             => Controls_Manager::TAB_SETTINGS,
        'label_group'     => esc_html__('CMS Animation Settings', 'finanzia'),
        'label'           => esc_html__('CMS Animation','finanzia'),
        'default'         => '',
        'group_condition' => [],
        'condition'       => []
    ]);
    $_animations = [
        ''             => esc_html__('Default', 'finanzia'), 
        'none'         => esc_html__('None', 'finanzia'), 
        'cms-reveal'   => esc_html__('CMS Reveal', 'finanzia'),
        'cms-roll-out' => esc_html__('CMS Roll Out', 'finanzia')
    ];
    $custom_animations =  apply_filters('finanzia_elementor_animation', []);
    $animations = array_merge($_animations, $custom_animations);

    if($args['group']){
        $widget->start_controls_section(
            $args['name'].'_section',
            [
                'label'     => $args['label_group'],
                'tab'       => $args['tab'],
                'condition' => $args['group_condition']
            ]
        );
    }
        $widget->add_control(
            $args['name'],
            [
                'label'     => $args['label'],
                'type'      => Controls_Manager::SELECT,
                'options'   => $animations,
                //'default'   => $args['default'],
                'condition' => $args['condition']
            ]
        );
    if($args['group']){
        $widget->end_controls_section();
    }
}
function finanzia_elementor_animation_render($widget, $settings, $args = []){
    $args= wp_parse_args($args, [
        'name'    => 'cms_animation',
        'default' => '',
        'class'   => ''
    ]);
    $animation = $widget->get_setting($args['name'], $args['default']);
    if(empty($animation) || $animation == 'none') return [];
    return [
        'class' => [
            'elementor-invisible',
            'cms-animation',
            $animation,
            $args['class']
        ],
        'data-settings' =>  wp_json_encode(['animation' => $animation]) //'{"_animation":"'.$animation.'"}'
    ];
}

/**
 * Elementor Post Layout Options
 * use for layout option in : cms_blog_grid, cms_blog_carousel
 * cms_service_grid, cms_service_carousel, ...
 * 
 * */
function finanzia_elementor_post_layouts(){
    return [
        '1' => [
            'label' => esc_html__( 'Layout 1', 'finanzia' ),
            'image' => get_template_directory_uri() . '/elementor/templates/layout/1.webp'
        ],
        '2' => [
            'label' => esc_html__( 'Layout 2', 'finanzia' ),
            'image' => get_template_directory_uri() . '/elementor/templates/layout/2.webp'
        ],
        '3' => [
            'label' => esc_html__( 'Layout 3', 'finanzia' ),
            'image' => get_template_directory_uri() . '/elementor/templates/layout/3.webp'
        ],
        '4' => [
            'label' => esc_html__( 'Layout 4', 'finanzia' ),
            'image' => get_template_directory_uri() . '/elementor/templates/layout/4.webp'
        ],
        '5' => [
            'label' => esc_html__( 'Layout 5', 'finanzia' ),
            'image' => get_template_directory_uri() . '/elementor/templates/layout/5.webp'
        ],
        '6' => [
            'label' => esc_html__( 'Layout 6', 'finanzia' ),
            'image' => get_template_directory_uri() . '/elementor/templates/layout/6.webp'
        ],
        '7' => [
            'label' => esc_html__( 'Layout 7', 'finanzia' ),
            'image' => get_template_directory_uri() . '/elementor/templates/layout/7.webp'
        ],
        '8' => [
            'label' => esc_html__( 'Layout 8', 'finanzia' ),
            'image' => get_template_directory_uri() . '/elementor/templates/layout/8.webp'
        ],
        '9' => [
            'label' => esc_html__( 'Layout 9', 'finanzia' ),
            'image' => get_template_directory_uri() . '/elementor/templates/layout/9.webp'
        ],
        '10' => [
            'label' => esc_html__( 'Layout 10', 'finanzia' ),
            'image' => get_template_directory_uri() . '/elementor/templates/layout/10.webp'
        ],
        '-career' => [
            'label' => esc_html__( 'Layout Career', 'finanzia' ),
            'image' => get_template_directory_uri() . '/elementor/templates/layout/career.webp'
        ],
        '-list' => [
            'label' => esc_html__( 'Layout List', 'finanzia' ),
            'image' => get_template_directory_uri() . '/elementor/templates/layout/list.webp'
        ]
    ];
}
// Elementor Build Post Layout 
if(!function_exists('finanzia_get_post_grid')){
    function finanzia_get_post_grid($settings = [], $posts = [], $posts_data = [], $args = []){
        if(!class_exists('\Elementor\Plugin') || !class_exists('Elementor_Theme_Core')) return;
        //
        if(empty($posts) || !is_array($posts) || empty($posts_data) || !is_array($posts_data)){
            return false;
        }
        extract($posts_data); 
        // Start build post item 
        $count = 0;
        $item_bg = [
            'accent-lighten',
            'light-green',
            'light-orange'
        ];
        $count_item_bg = count($item_bg);
        $list_class = '';
        foreach ($posts as $key => $post):
            $count ++;
            $_item_bg = $item_bg[$key%$count_item_bg];

            if($count>1){
                $list_class = '';
            }
            ?>
            <div class="<?php echo implode(' ', array_filter(['cms-item', $posts_data['item_class'], 'item-'.$count])); ?>" data-target="cms-<?php echo esc_attr($post->ID);?>">
                <?php switch ($settings['layout']) {
                    case '10':
                ?>
                <div class="cms--item bg-white hover-image-zoom-out cms-hover-change">
                    <?php
                        // Read More
                        ob_start();
                    ?><div class="absolute center"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="box-87 circle text-white text-hover-white bg-hover-accent cms-hover-move-icon-right cms-backdrop-1 cms-hover-show zoom-out"><span class="screen-reader-text"><?php 
                            //text
                            etc_print_html($posts_data['readmore_text']);
                        ?></span>
                        <?php
                            //icon
                            finanzia_svgs_icon(['icon' => 'core/long-arrow-right', 'class' => 'text-17']); 
                        ?></a></div>
                    <?php
                        $post_thumb_content = ob_get_clean();
                        // Post Image
                        finanzia_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'img_class'   => 'img-cover swiper-nav-vert', 
                            'max_height'  => true,
                            'before'      => '<div class="cms-post-thumbnail relative overflow-hidden">',
                            'after'       => $post_thumb_content.'</div>'
                        ]);
                    ?>
                    <?php 
                        finanzia_the_terms($post->ID, $posts_data['taxonomy'], '', 'tag-thumb-link bg-white text-accent bg-hover-accent text-hover-white bdr-1 bdr-accent cms-radius-13 text-13 lh-1 p-tb-5 p-lr-10', ['before' => '<div class="tag-thumb pt-30 d-flex gap-5 text-13 pb-15 empty-none">', 'after' => '</div>']);
                    ?>
                    <h3 class="cms-heading text-line-3 text-21 lh-1238 text-accent"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-hover-underline"><?php echo get_the_title($post->ID); ?></a></h3>
                </div>
                <?php
                    break;
                    case '9':
                ?>
                <div class="cms--item bdr-1 bdr-divider cms-hover-shadow-2 cms-hover-change p-50 p-lr-smobile-20 bg-white cms-transition">
                    <h3 class="cms-heading text-line-2 text-21 lh-1238 mt-n7 bdr-b-2 bdr-divider bdr-on-hover-heading cms-transition pb-20 text-accent"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h3>
                    <div class="cms-content d-flex align-items-end gap-40 gap-smobile-20 pt-70">
                        <?php 
                            $icon = finanzia_get_post_format_value($post->ID, 'icon', '');
                            if(!empty($icon)){
                                finanzia_post_icon_render([
                                    'id'         => $post->ID, 
                                    'class'      => '',
                                    'icon_color' => 'white',
                                    'size'       => $posts_data['thumbnail_custom_dimension']['width'],
                                    'before'     => '<div class="box-78 bg-accent">',
                                    'after'      => '</div>'   
                                ]);
                            } else {
                                // Post Image
                                finanzia_elementor_post_thumbnail_render($settings, [
                                    'post_id'     => $post->ID,
                                    'custom_size' => $posts_data['thumbnail_custom_dimension'],
                                    'img_class'   => '', 
                                    'max_height'  => true,
                                    'before'      => '<div class="box-78 bg-accent">',
                                    'after'       => '</div>'
                                ]);
                            }
                        ?>
                        <div class="flex-basic mb-n7">
                            <div class="cms-excerpt text-15 text-line-<?php echo esc_attr($posts_data['num_line']);?>"><?php 
                                echo wp_kses_post($post->post_excerpt);
                                // Read More
                            ?></div>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-link font-700 text-15 cms-hover-underline cms-hover-move-icon-right pt-15 text-accent"><?php 
                                //text
                                etc_print_html($posts_data['readmore_text']);
                                //icon
                                finanzia_svgs_icon(['icon' => 'core/long-arrow-right', 'class' => 'text-17']); 
                                
                            ?></a>
                        </div>
                    </div>
                </div>
                <?php
                    break;
                    case '8':
                ?>
                <div class="cms--item cms-hover-change relative text-center overflow-hidden pt" style="--pt:282px;">
                    <div class="cms-content pt-40 pb-33 p-lr-40 p-lr-smobile-20 bg-hover-white bg-on-hover-white cms-transition relative z-top mb" style='--mb:0px;'>
                        <h3 class="cms-heading text-line-2 text-21 lh-1238 mt-n7 text-white text-on-hover-accent"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h3>
                        <?php finanzia_the_terms($post->ID, $posts_data['taxonomy'], ', ', 'cms-hover-underline text-white text-on-hover-accent', ['before' => '<div class="tag-thumb text-center text-13 pt-25">', 'after' => '</div>']); ?>
                        <div class="cms-excerpt text-15 text-line-<?php echo esc_attr($posts_data['num_line']);?> pt-23 mt-23 bdr-t-1 bdr-divider-30 cms-hover-show"><?php 
                            echo wp_kses_post($post->post_excerpt);
                            // Read More
                        ?></div>
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-link font-700 text-15 cms-hover-underline cms-hover-move-icon-right pt-15 mb-n7"><?php 
                            //text
                            etc_print_html($posts_data['readmore_text']);
                            //icon
                            finanzia_svgs_icon(['icon' => 'core/long-arrow-right', 'class' => 'text-17']); 
                            
                        ?></a>
                    </div>
                </div>
                <?php
                    break;
                    case '7':
                ?>
                <div class="cms--item bg-white p-50 p-lr-smobile-20 cms-shadow-1 cms-hover-shadow-6 cms-hover-change cms-transition">
                    <?php
                        $icon = finanzia_get_post_format_value($post->ID, 'icon', '');
                        if(!empty($icon)){
                            finanzia_post_icon_render([
                                'id'         => $post->ID, 
                                'class'      => 'pb-50',
                                'icon_color' => '',
                                'before'     => '',
                                'after'      => ''   
                            ]);
                        } else {
                            // Post Image
                            finanzia_elementor_post_thumbnail_render($settings, [
                                'post_id'     => $post->ID,
                                'custom_size' => $posts_data['thumbnail_custom_dimension'],
                                'img_class'   => '', 
                                'max_height'  => true,
                                'before'      => '<div class="pb-50">',
                                'after'       => '</div>'
                            ]);
                        }
                    ?>
                    <h3 class="cms-heading text-line-3 text-23 lh-1304 bdr-b-2 bdr-divider bdr-on-hover-primary pb-23 mt-n7 cms-transition text-accent"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h3>
                    <div class="cms-excerpt text-15 text-line-<?php echo esc_attr($posts_data['num_line']);?> pt-30 mb-n10"><?php 
                            echo wp_kses_post($post->post_excerpt);
                            // Read More
                        ?></div>
                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-link btn btn-smd btn-outline-accent text-accent btn-hover-accent text-hover-white cms-hover-move-icon-right mt-50 w-100 justify-content-center"><?php 
                        //text
                        etc_print_html('<span class="text relative z-top2">'.$posts_data['readmore_text'].'</span>');
                        //icon
                        finanzia_svgs_icon(['icon' => 'core/long-arrow-right', 'class' => 'text-17']); 
                    ?></a>
                </div>
                <?php
                    break;
                    case '6':
                ?>
                <div class="cms--item bg-white hover-image-zoom-out cms-hover-change p-50 p-lr-smobile-20 bdr-r-1 bdr-divider-dark">
                    <?php
                        $icon = finanzia_get_post_format_value($post->ID, 'icon', '');
                        if(!empty($icon)){
                            finanzia_post_icon_render([
                                'id'         => $post->ID, 
                                'class'      => 'bdr-b-2 bdr-divider bdr-on-hover-primary mb-40 pb-40',
                                'icon_color' => '',
                                'before'     => '',
                                'after'      => ''   
                            ]);
                        } else {
                            // Post Image
                            finanzia_elementor_post_thumbnail_render($settings, [
                                'post_id'     => $post->ID,
                                'custom_size' => $posts_data['thumbnail_custom_dimension'],
                                'img_class'   => '', 
                                'max_height'  => true,
                                'before'      => '<div class="bdr-b-2 bdr-divider bdr-on-hover-primary mb-40 pb-40">',
                                'after'       => '</div>'
                            ]);
                        }
                    ?>
                    <h3 class="cms-heading text-line-3 text-23 lh-1304"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h3>
                    <div class="cms-excerpt text-15 text-line-<?php echo esc_attr($posts_data['num_line']);?> pt-15"><?php 
                            echo wp_kses_post($post->post_excerpt);
                            // Read More
                        ?></div>
                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-link cms-hover-button font-700 text-15 text-hover-white cms-hover-move-icon-right mt-40"><?php 
                        //icon
                        finanzia_svgs_icon(['icon' => 'core/long-arrow-right', 'class' => 'text-17 box-icon box-47 circle bg-accent text-white relative cms-transition']); 
                        //text
                        etc_print_html('<span class="text relative z-top2">'.$posts_data['readmore_text'].'</span>');
                    ?></a>
                </div>
                <?php
                    break;
                    case '5':
                ?>
                <div class="cms--item cms-shadow-3 cms-hover-shadow-4 cms-transition bg-white hover-image-zoom-out cms-hover-change p-50 p-lr-smobile-20">
                    <?php
                        $icon = finanzia_get_post_format_value($post->ID, 'icon', '');
                        if(!empty($icon)){
                            finanzia_post_icon_render([
                                'id'         => $post->ID, 
                                'class'      => 'bdr-b-2 bdr-divider bdr-on-hover-primary mb-40 pb-40',
                                'icon_color' => '',
                                'before'     => '',
                                'after'      => ''   
                            ]);
                        } else {
                            // Post Image
                            finanzia_elementor_post_thumbnail_render($settings, [
                                'post_id'     => $post->ID,
                                'custom_size' => $posts_data['thumbnail_custom_dimension'],
                                'img_class'   => '', 
                                'max_height'  => true,
                                'before'      => '<div class="bdr-b-2 bdr-divider bdr-on-hover-primary mb-40 pb-40">',
                                'after'       => '</div>'
                            ]);
                        }
                    ?>
                    <h3 class="cms-heading text-line-3 text-23 lh-1304 text-accent"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h3>
                    <div class="cms-excerpt text-15 text-line-<?php echo esc_attr($posts_data['num_line']);?> pt-15"><?php 
                            echo wp_kses_post($post->post_excerpt);
                            // Read More
                        ?></div>
                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-link cms-hover-button font-700 text-15 text-hover-white cms-hover-move-icon-right mt-40 text-accent"><?php 
                        //icon
                        finanzia_svgs_icon(['icon' => 'core/long-arrow-right', 'class' => 'text-17 box-icon box-47 circle bg-accent text-white relative cms-transition']); 
                        //text
                        etc_print_html('<span class="text relative z-top2">'.$posts_data['readmore_text'].'</span>');
                    ?></a>
                </div>
                <?php
                    break;
                    case '4':
                ?>
                <div class="cms--item cms-shadow-1 cms-hover-shadow-2 cms-transition bg-white hover-image-zoom-out cms-hover-change">
                    <?php
                        // Read More
                        ob_start();
                    ?><div class="absolute center"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="box-87 circle text-white text-hover-white bg-hover-accent cms-hover-move-icon-right cms-backdrop-1 cms-hover-show zoom-out"><span class="screen-reader-text"><?php 
                            //text
                            etc_print_html($posts_data['readmore_text']);
                        ?></span>
                        <?php
                            //icon
                            finanzia_svgs_icon(['icon' => 'core/long-arrow-right', 'class' => 'text-17']); 
                        ?></a></div>
                    <?php
                        $post_thumb_content = ob_get_clean();
                        // Post Image
                        finanzia_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'img_class'   => 'img-cover swiper-nav-vert', 
                            'max_height'  => true,
                            'before'      => '<div class="cms-post-thumbnail relative overflow-hidden">',
                            'after'       => $post_thumb_content.'</div>'
                        ]);
                    ?>
                    <div class="cms-content pt-40 pb-33 p-lr-40 p-lr-smobile-20">
                        <?php 
                            finanzia_the_terms($post->ID, $posts_data['taxonomy'], '', 'tag-thumb-link bg-white text-accent bg-hover-accent text-hover-white bdr-1 bdr-accent cms-radius-13 text-13 lh-1 p-tb-5 p-lr-10', ['before' => '<div class="tag-thumb d-flex gap-5 text-13 pb-15 empty-none">', 'after' => '</div>']);
                        ?>
                        <h3 class="cms-heading text-accent text-line-3 text-21 lh-1238"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h3>
                    </div>
                </div>
                <?php
                    break;
                    case '3':
                ?>
                <div class="cms--item cms-shadow-1 cms-hover-shadow-2 cms-transition bg-white hover-image-zoom-out cms-hover-change relative text-center overflow-hidden">
                    <?php
                        // Post Image
                        finanzia_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'img_class'   => 'img-cover swiper-nav-vert', 
                            'max_height'  => true,
                            'before'      => '<div class="cms-post-thumbnail relative overflow-hidden">',
                            'after'       => '</div>'
                        ]);
                    ?>
                    <div class="cms-content pt-40 pb-33 p-lr-40 p-lr-smobile-20 bg-white cms-transition relative z-top min-h" style='--min-h:245px;'>
                        <h3 class="cms-heading text-accent text-line-2 text-21 lh-1238 mt-n7"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h3>
                        <?php finanzia_the_terms($post->ID, $posts_data['taxonomy'], ', ', 'cms-hover-underline', ['before' => '<div class="tag-thumb  text-center text-13 pt-20">', 'after' => '</div>']); ?>
                        <div class="cms-excerpt text-15 text-line-<?php echo esc_attr($posts_data['num_line']);?> pt-23 mt-23 bdr-t-1 bdr-divider-30 cms-hover-show"><?php 
                            echo wp_kses_post($post->post_excerpt);
                            // Read More
                        ?></div>
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-link font-700 text-15 cms-hover-underline cms-hover-move-icon-right pt-15 mb-n7"><?php 
                            //text
                            etc_print_html($posts_data['readmore_text']);
                            //icon
                            finanzia_svgs_icon(['icon' => 'core/long-arrow-right', 'class' => 'text-17']); 
                            
                        ?></a>
                    </div>
                </div>
                <?php
                    break;
                    case '2':
                ?>
                <div class="cms--item cms-shadow-1 cms-hover-shadow-2 cms-transition bg-white hover-image-zoom-out cms-hover-change h-100">
                    <?php
                        // Read More
                        ob_start();
                    ?>  <div class="absolute bottom w-100 p-40 p-smobile-20 cms-hover-show move-up cms-transition"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="btn btn-lg text-white text-hover-white bg-hover-accent cms-hover-move-icon-right w-100 cms-backdrop-1"><?php 
                            //text
                            etc_print_html($posts_data['readmore_text']);
                            //icon
                            finanzia_svgs_icon(['icon' => 'core/long-arrow-right', 'class' => 'text-17']); 
                            
                        ?></a></div>
                    <?php
                        $post_thumb_content = ob_get_clean();
                        // Post Image
                        finanzia_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'img_class'   => 'img-cover swiper-nav-vert', 
                            'max_height'  => true,
                            'before'      => '<div class="cms-post-thumbnail relative overflow-hidden">',
                            'after'       => $post_thumb_content.'</div>'
                        ]);
                    ?>
                    <div class="cms-content pt-40 pb-33 p-lr-40 p-lr-smobile-20">
                        <h3 class="cms-heading text-line-3 text-21 text-accent"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h3>
                        <div class="cms-excerpt text-15 text-line-<?php echo esc_attr($posts_data['num_line']);?> pt-20 empty-none"><?php 
                            echo wp_kses_post($post->post_excerpt);
                            // Read More
                        ?></div>
                        <?php 
                            finanzia_the_terms($post->ID, $posts_data['taxonomy'], '', 'tag-thumb-link bg-white text-accent bg-hover-accent text-hover-white bdr-1 bdr-accent cms-radius-13 text-13 lh-1 p-tb-5 p-lr-10', ['before' => '<div class="tag-thumb d-flex gap-5 text-13 pt-25 empty-none">', 'after' => '</div>']);
                        ?>
                    </div>
                </div>
                <?php
                    break;
                    default:
                ?>
                <div class="cms--item cms-hover-shadow-2 cms-transition bg-white hover-image-zoom-out">
                    <?php
                        // Taxonomy
                        ob_start();
                            finanzia_the_terms($post->ID, $posts_data['taxonomy'], '', 'tag-thumb-link bg-primary-lighten cms-radius-13 text-13 lh-1 p-tb-5 p-lr-10', ['before' => '<div class="tag-thumb post-tag absolute bottom-right mb-20 mr-20 d-flex gap-5 text-13">', 'after' => '</div>']);
                        $post_cat = ob_get_clean();
                        // Post Image
                        finanzia_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'img_class'   => 'img-cover swiper-nav-vert', 
                            'max_height'  => true,
                            'before'      => '<div class="cms-post-thumbnail relative overflow-hidden">',
                            'after'       => $post_cat.'</div>'
                        ]);
                    ?>
                    <div class="cms-content pt-40 pb-33 p-lr-40 p-lr-smobile-20">
                        <div class="cms-post-meta cms-archive-meta gap-10 pb-10 mt-n5 text-13 d-flex align-items-center">
                            <div class="meta-item author">
                                <?php finanzia_the_author_posts_link([
                                    'id'         => $post->ID,
                                    'text'       => '',
                                    'link_class' => 'text-accent'
                                ]); ?>
                            </div>
                            <?php
                            // Post Date
                            echo '<div class="separator"></div>';
                            echo get_the_date('', $post->ID);
                        ?></div>
                        <h3 class="cms-heading text-line-3 text-19 lh-1263 text-accent"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h3>
                        <div class="cms-excerpt text-15 text-line-<?php echo esc_attr($posts_data['num_line']);?> pt-33 mt-33 bdr-t-1 bdr-divider"><?php 
                            echo wp_kses_post($post->post_excerpt);
                            // Read More
                        ?></div>
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-link text-15 font-700 cms-hover-move-icon-right pt-30 text-accent"><?php 
                            //text
                            etc_print_html($posts_data['readmore_text']);
                            //icon
                            finanzia_svgs_icon(['icon' => 'core/long-arrow-right', 'class' => 'text-17']); 
                            
                        ?></a>
                    </div>
                </div>
                <?php
                    break;
                case '-career':
                ?>
                <div class="cms--item cms-hover-shadow-2 cms-transition bg-white bdr-1 bdr-divider p-50 p-lr-smobile-20">
                    <?php // Job Details
                        finanzia_post_career_render(['id' => $post->ID, 'class' => 'pb-15 text-13']); 
                    ?>
                    <h3 class="cms-heading text-line-4 text-23 text-accent bdr-b-2 pb-23 mb-23"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-hover-underline"><?php echo get_the_title($post->ID); ?></a></h3>
                    <div class="cms-excerpt text-15 text-line-<?php echo esc_attr($posts_data['num_line']);?>"><?php 
                        echo wp_kses_post($post->post_excerpt);
                        // Read More
                    ?></div>
                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="mt-23 btn btn btn-accent text-white btn-hover-accent-darken text-hover-white">
                        <?php
                            //text
                            etc_print_html($posts_data['readmore_text']);
                            //icon
                            finanzia_svgs_icon(['icon' => 'core/long-arrow-right', 'icon_size' => 17]); 
                        ?>
                    </a>    
                </div>
                <?php
                    break;
                    case '-list':
                ?>
                <a class="cms--item cms-hover-change d-flex gap-20 bdr-b-1 bdr-divider bdr-hover-accent pt-20 pb-10" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                    <?php 
                        $icon = finanzia_get_post_format_value($post->ID, 'icon', '');
                        if(!empty($icon)){
                            finanzia_post_icon_render([
                                'id'         => $post->ID, 
                                'class'      => 'flex-auto pt-5',
                                'icon_color' => '',
                                'before'     => '',
                                'after'      => '',
                                'size'       => $posts_data['thumbnail_custom_dimension']['width']
                            ]);
                        } else {
                            // Post Image
                            finanzia_elementor_post_thumbnail_render($settings, [
                                'post_id'     => $post->ID,
                                'custom_size' => $posts_data['thumbnail_custom_dimension'],
                                'img_class'   => '', 
                                'max_height'  => true,
                                'before'      => '<div class="flex-auto pt-5">',
                                'after'       => '</div>'
                            ]);
                        }
                    ?>
                    <h3 class="cms-heading text-line-2 text-17"><?php echo get_the_title($post->ID); ?></h3>
                </a>
                <?php
                    break;
                case 'all':
                    // Job Details
                    finanzia_post_career_render(['id' => $post->ID, 'class' => 'mb-20']);
                    // post icon
                    finanzia_post_icon_render([
                        'id'         => $post->ID, 
                        'class'      => 'cms-moving cms-moving-4 rtl-flip',
                        'icon_color' => 'primary text-on-hover-accent',
                        'after'      => '<span class="triangle cms-transition"></span>'   
                    ]);
                    // Post Date
                    ob_start();
                ?>
                    <div class="cms-post-thumb-date absolute top-left text-white text-13 d-flex z-top2">
                        <div class="date bg-primary"><?php echo zeroise( get_the_date('j', $post->ID), 2 );?></div>
                        <div class="month bg-accent"><?php echo get_the_date('M Y', $post->ID);?></div>
                    </div>
                <?php $post_date = ob_get_clean(); ?>
                <div class="cms--item cms-shadow-2 cms-hover-shadow-1 cms-transition bg-white mt-40 hover-divider-date hover-image-zoom-out">
                    <?php
                        // Post Image
                        finanzia_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'img_class'   => 'img-cover swiper-nav-vert', 
                            'max_height'  => true,
                            'before'      => '<div class="cms-post-thumbnail overflow-hidden relative ml-40 cms-translateY--40 divider divider-date divider-top divider-accent">',
                            'after'       => $post_date.'</div>'
                        ]);
                    ?>
                    <div class="cms-content p-lr-40 pb-40 p-lr-smobile-20 mt-n10">
                        <div class="cms-post-meta text-13 pb-10 mt-n5 d-flex gap-20"><?php 
                            // Taxonomy
                            finanzia_the_terms($post->ID, $posts_data['taxonomy'], ', ', 'text-accent text-hover-primary', ['before' => '<div class="meta-item">', 'after' => '</div>']);
                            // Author
                            finanzia_the_author_posts_link([
                                'id'         => $post->ID,
                                'before'     => '<div class="meta-item text-accent">', 
                                'after'      => '</div>'
                            ]);
                        ?></div>
                        <h3 class="cms-heading text-line-2 text-21 lh-1238 pr-10"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h3>
                        <div class="cms-excerpt text-15 pb-5 text-line-<?php echo esc_attr($posts_data['num_line']);?> pt-20 mb-15"><?php 
                            echo wp_kses_post($post->post_excerpt);
                            // Read More
                        ?></div>
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="btn btn-smd btn-outline-border text-primary btn-hover-primary text-hover-white">
                            <?php 
                                //text
                                etc_print_html($posts_data['readmore_text']);
                                //icon
                                finanzia_svgs_icon(['icon' => 'core/arrow-right', 'class' => 'text-12']); 
                            ?>
                        </a>
                    </div>
                </div>
                <?php    
                    break;
                } ?>
            </div>
        <?php
        endforeach;
    }
}
/**
 * Custom Post 
 * 
 * */
/**
 * Icon 
*/
if(!function_exists('finanzia_post_icon_opts')){
    function finanzia_post_icon_opts($args = []){
        $args = wp_parse_args($args, [
            'label'    => esc_html__('Icon', 'finanzia'),
            'icon'     => true,
            'video'    => false,
            'name'     => false,
            'position' => false
        ]);
        $fields = [];
        if($args['icon']){
            $fields['icon'] = [
                'type'        => Theme_Core_Options::MEDIA_FIELD,
                'title'       => __('Choose Icon', 'finanzia'),
                'default'     => ''  
            ];
        }
        //video
        if($args['video']){
            $fields['video'] = [
                'type'        => Theme_Core_Options::TEXT_FIELD,
                'title'       => __('YouTube Link', 'finanzia'),
                'default'     => 'https://www.youtube.com/watch?v=iYf3OgEdGmo'  
            ];
        }
        //name
        if($args['name']){
            $fields['name'] = [
                'type'        => Theme_Core_Options::TEXT_FIELD,
                'title'       => __('Name', 'finanzia'),
                'default'     => 'John Doe'  
            ];
        }
        // position
        if($args['position']){
            $fields['position'] = [
                'type'        => Theme_Core_Options::TEXT_FIELD,
                'title'       => __('Position', 'finanzia'),
                'default'     => 'Manager'  
            ];
        }
        return [
            'title'  => $args['label'],
            'fields' => $fields
        ];
    }
}
/**
 * Render Icon
*/
if(!function_exists('finanzia_post_icon_render')){
    function finanzia_post_icon_render($args = []){
        $args = wp_parse_args($args, [
            'id'          => get_the_ID(),
            'class'       => '',     
            'before'      => '',
            'after'       => '',
            'wrap_before' => '',
            'wrap_after'  => '',
            'icon_class'  => '',
            'icon_color'  => 'accent',
            'size'        => 64,
            'echo'        => true    
        ]);
        $icon = finanzia_get_post_format_value($args['id'], 'icon', '');
        
        if(empty($icon['url']) || !class_exists('\Elementor\Plugin') ) return;
        $icon_mime = substr($icon['url'], -4);
        
        ob_start();
            switch ($icon_mime) {
                case '.svg':
                    if(isset($icon['id'])){
                        $icon_path = get_attached_file($icon['id']);
                        if($icon_path){
                            include $icon_path;
                        }
                    }
                break;
                
                default:
                    finanzia_elementor_image_render([], [
                        'attachment_id' => $icon['id'],
                        'size'          => 'custom',
                        'custom_size'   => ['width'=>$args['size'], 'height' => $args['size']] 
                    ]);
                    break;
            }
        $icon_html = ob_get_clean();

        ob_start();
        printf('%s', $args['wrap_before']);
        ?>
            <div class="<?php echo implode(' ',array_filter(['cms-post-icon', 'text-'.$args['icon_color'],'text-'.$args['size'],'lh-0', $args['class']]));?>" style="--svg-size:<?php echo esc_attr($args['size']).'px' ?>"><?php 
                printf('%1$s%2$s%3$s', $args['before'], $icon_html, $args['after'] ); 
            ?></div>
        <?php
        printf('%s', $args['wrap_after']);
        if($args['echo']){
            echo ob_get_clean();
        } else {
            return ob_get_clean();
        }
    }
}
/**
 * Post Features 
*/
if(!function_exists('finanzia_post_feature_opts')){
    function finanzia_post_feature_opts($args = []){
        return [
            'title'  => esc_html__('Features', 'finanzia'),
            'fields' => [
                'features' => [
                    'type'        => Theme_Core_Options::REPEATER_FIELD,
                    'title'       => __('Add your feature', 'finanzia'),
                    'fields' => [
                        'text' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => __('Your feature','finanzia')
                        ]
                    ],
                    'title_field' => 'text'
                ]
            ]
        ];
    }
}
if(!function_exists('finanzia_post_feature_render')){
    function finanzia_post_feature_render($args = []){
        $args = wp_parse_args($args, [
            'id'         => get_the_ID(),
            'name'       => 'features',
            'before'     => '<div class="cms-post-feature text-secondary font-700 text-15">',
            'after'      => '</div>',
            'icon'       => 'cmsi-check text-10',
            'icon_class' => 'text-secondary-lighten',
            'item_class' => 'cms-list-item',
            'echo'       => true
        ]);
        $features = finanzia_get_post_format_value($args['id'], $args['name']);
        if(empty( $features)) return;
        ob_start();
            printf('%s', $args['before']);
                foreach ($features as $feature) {
                    $_icon = (isset($feature['icon']) && !empty($feature['icon'])) ? $feature['icon'] : $args['icon'];
                    $icon = !empty($_icon) ? '<div class="'.finanzia_nice_class(['flex-auto cms-list-icon', $args['icon_class'], $_icon]).'"></div>' : '';
                    printf('<div class="%s d-flex gap-15">%s<div class="flex-basic">%s</div></div>',$args['item_class'],$icon,$feature['text']);
                }
            printf('%s', $args['after']);
        if($args['echo']){
            echo ob_get_clean();
        } else  {
            return ob_get_clean();
        }
    }
}
/**
 * Career Opts 
*/
if(!function_exists('finanzia_post_career_opts')){
    function finanzia_post_career_opts($args = []){
        return [
            'title'  => esc_html__('General', 'finanzia'),
            'fields' => [
                'job_type' => [
                    'type'        => Theme_Core_Options::TEXT_FIELD,
                    'title'       => __('Job Type', 'finanzia')
                ],
                'job_address' => [
                    'type'        => Theme_Core_Options::TEXT_FIELD,
                    'title'       => __('Job Address', 'finanzia')
                ],
                'job_salary' => [
                    'type'        => Theme_Core_Options::TEXT_FIELD,
                    'title'       => __('Job Salary', 'finanzia')
                ]
            ]
        ];
    }
}
if(!function_exists('finanzia_post_career_render')){
    function finanzia_post_career_render($args = []){
        $args = wp_parse_args($args, [
            'id'    => null,
            'class' => ''
        ]);
        if(!$args['id']) return;
        $job_type   = finanzia_get_post_format_value($args['id'], 'job_type', '');
        $job_add    = finanzia_get_post_format_value($args['id'], 'job_address', '');
        $job_salary = finanzia_get_post_format_value($args['id'], 'job_salary', '');

        $classes = ['cms-job-details d-flex align-items-center gap-15', $args['class']];
    ?>
    <div class="<?php echo implode(' ', array_filter($classes)); ?>">
        <div class="job-type empty-none bg-primary-lighten text-white cms-radius-13 p-lr-10 pt-2"><?php echo esc_html($job_type); ?></div>
        <div class="job-add empty-none"><?php echo esc_html($job_add); ?></div>
        <div class="job-sallary empty-none"><?php echo esc_html($job_salary); ?></div>
    </div>
    <?php
    }
}
if(!function_exists('finanzia_chart_data_settings')){
    function finanzia_chart_data_settings($widget, $settings, $args = []){
        $args = wp_parse_args($args, [
            'name'             => 'cms_chart',
            'chart_container'  => 'cms-charts',
            'wrap_class'       => '',  
            'class'            => '',
            'chart_type'       => 'doughnut',
            'chart_dimensions' => 400,
            'chart_mode'       => 'circle',
            'chart_cutout'     => '50%',
            'custom_data'      => '',
            'before'           => '',
            'after'            => '' 
        ]);
        if($args['chart_mode'] === 'half-circle'){
            $chart_dimensions_height = $args['chart_dimensions']/2;
        } else {
            $chart_dimensions_height = $args['chart_dimensions'];
        }
        $charts = $widget->get_settings($args['name']);
        $chart_title = $chart_main_title = $chart_value = $chart_color = [];
        foreach ($charts as $key => $value) {
            $chart_title[] = $value['chart_title'];
            $chart_main_title[] = $value['chart_main_title'];
            $chart_value[] = $value['chart_value'];
            $chart_color[] = $value['chart_color'];
        }
        // Chart Wrap
        $widget->add_render_attribute('charts-wrap', [
            'class' => [
                'cms-charts-wrap',
                $args['wrap_class'],
                ($args['chart_mode'] === 'half-circle') ? 'cms-charts-half overflow-hidden' : ''
            ],
            'style' => 'max-width:'.$args['chart_dimensions'].'px;height:'.$chart_dimensions_height.'px;--cms-chart-width:'.$args['chart_dimensions'].'px;--cms-chart-height:'.$chart_dimensions_height.'px;'
        ]);
        // Chart Settings   
        $opts = [
            'type'            => $widget->get_setting('cms_chart_type', $args['chart_type']),   
            'labels'          => $chart_title,
            'value'           => $chart_value,
            'colors'          => $chart_color,
            'legend_display'  => $settings['legend_display'],
            'legend_position' => $settings['legend_position'],
            'title_display'   => $settings['title_display'],
            'title_position'  => $settings['title_position'],
            'title_text'      => $widget->get_setting('title_text','CMS Charts'),
            'chart_mode'      => $widget->get_setting('cms_chart_mode', $args['chart_mode']),
            'chart_cutout'    => $args['chart_cutout']
        ];

        if(!empty($args['custom_data'])){
            $opts = $args['custom_data'];
        }

        $widget->add_render_attribute( 'cms-chart-settings', [
            'id'            => etc_get_element_id($settings),
            'class'         => finanzia_nice_class( implode( ' ', [$args['chart_container'], $args['class']] ) ),
            'data-settings' => wp_json_encode($opts)
        ]);
    ?>
        <div <?php etc_print_html($widget->get_render_attribute_string( 'charts-wrap' )); ?>>
            <?php printf('%s', $args['before']); ?>
            <canvas <?php etc_print_html($widget->get_render_attribute_string( 'cms-chart-settings' )); ?>></canvas>
            <?php printf('%s', $args['after']); ?>
        </div>
    <?php
    }
}
if(!function_exists('finanzia_chart_bar_data_settings')){
    function finanzia_chart_bar_data_settings($widget, $settings, $args = []){
        $args = wp_parse_args($args, [
            'name'            => 'cms_chart',
            'chart_container' => 'cms-charts-bar',
            'wrap_class'      => '',  
            'class'           => '',
            'chart_type'      => 'bar',
            'title1'          => $widget->get_setting('chart1_title','Title #1'),
            'color1'          => $widget->get_setting('chart1_color','#616161'),
            'title2'          => $widget->get_setting('chart2_title','Title #2'),
            'color2'          => $widget->get_setting('chart2_color','#161616'),
            'title3'          => $widget->get_setting('chart3_title','Title #3'),
            'color3'          => $widget->get_setting('chart3_color','#fe5b2c'),
        ]);
        $charts = $widget->get_settings($args['name']);
        $chart_title = $chart_value = $chart_color = $chart_datasets = $charts_databar = [];
        foreach ($charts as $key => $value) {
            $charts_databar[] = [
                'x'      => $value['chart_title'],
                'val1'   => $value['chart1_value'],
                'val2'   => $value['chart2_value'], 
                'val3'   => $value['chart3_value']];
        }
        foreach ($charts as $key => $value) {
            $key ++;
            $chart_title[] = $value['chart_title'];
            if(isset($value['chart'.$key.'_value']) && !empty($value['chart'.$key.'_value'])){
                $chart_datasets[] = [
                    'label'           => $args['title'.$key],
                    'data'            => array_filter($charts_databar),
                    'backgroundColor' => $args['color'.$key],
                    'borderColor'     => $args['color'.$key],
                    'parsing'         => [
                        'yAxisKey' => 'val'.$key
                    ],
                    'barThickness'    => 22,
                    'maxBarThickness' => 15,
                ];
            }
        }
        // Chart Wrap
        $widget->add_render_attribute('charts-wrap', [
            'class' => [
                'cms-charts-wrap',
                $args['wrap_class']
            ]
        ]);
        // Chart Settings   
        $opts = [
            'type'            => $widget->get_setting('cms_chart_type', $args['chart_type']),
            //'labels'          => $chart_title,
            //'value'           => $chart_value,
            //'colors'          => $chart_color,
            'datasets'        => $chart_datasets,
            'legend_display'  => $settings['legend_display'],
            'legend_position' => $settings['legend_position'],
            'title_display'   => $widget->get_setting('title_display', false),
            'title_position'  => $widget->get_setting('title_position','top'),
            'title_text'      => $widget->get_setting('title_text','CMS Charts')
        ];
        $widget->add_render_attribute( 'cms-chart-settings', [
            'id'            => etc_get_element_id($settings),
            'class'         => implode( ' ', array_filter([$args['chart_container'], $args['class']]) ),
            'data-settings' => wp_json_encode($opts)
        ]);
    ?>
        <div <?php etc_print_html($widget->get_render_attribute_string( 'charts-wrap' )); ?>>
            <canvas <?php etc_print_html($widget->get_render_attribute_string( 'cms-chart-settings' )); ?>></canvas>
        </div>
    <?php
    }
}
if(!function_exists('finanzia_chart_line_data_settings')){
    function finanzia_chart_line_data_settings($widget, $settings, $args = []){
        $args = wp_parse_args($args, [
            'name'            => 'cms_chart_line',
            'chart_container' => 'cms-charts-line',
            'wrap_class'      => '',  
            'class'           => '',
            'chart_type'      => 'line',
            'labels'          => '',
            'border_width'    => 2,
            'point_radius'    => 0,
            'tension'         => '0.5',
            'fill'            => false  
        ]);
        $charts = $widget->get_settings($args['name']);
        $labels = explode(',', $args['labels']);
        foreach ($charts as $key => $value) {
            $chart_datasets[] = [
                'label'           => $value['chart_title'],
                'data'            => explode(',', $value['chart_value']),
                'borderColor'     => $value['chart_color'],
                'borderDash'      => explode(',', $value['chart_dash']),
                'borderWidth'     => $args['border_width'],
                'pointRadius'     => $args['point_radius'],
                'tension'         => $args['tension'],
                'fill'            => $args['fill']  
            ];
        }
        // Chart Wrap
        $widget->add_render_attribute('charts-wrap', [
            'class' => [
                'cms-charts-wrap',
                $args['wrap_class']
            ]
        ]);
        // Chart Settings   
        $opts = [
            'type'            => $args['chart_type'],
            'labels'          => explode(',', $args['labels']),
            'datasets'        => $chart_datasets,
            'legend_display'  => $widget->get_setting('legend_display','no'),
            'legend_position' => $widget->get_setting('legend_position','bottom'),
            'title_display'   => $widget->get_setting('title_display', 'no'),
            'title_position'  => $widget->get_setting('title_position', 'top'),
            'title_text'      => $widget->get_setting('title_text','CMS Charts Line')
        ];
        $widget->add_render_attribute( 'cms-chart-settings', [
            'id'            => etc_get_element_id($settings),
            'class'         => implode( ' ', array_filter([$args['chart_container'], $args['class']]) ),
            'data-settings' => wp_json_encode($opts)
        ]);
    ?>
        <div <?php etc_print_html($widget->get_render_attribute_string( 'charts-wrap' )); ?>>
            <canvas <?php etc_print_html($widget->get_render_attribute_string( 'cms-chart-settings' )); ?>></canvas>
        </div>
    <?php
    }
}
/**
 * Custom Post Type
 * 
 * **/
add_filter('cms_extra_post_types', 'finanzia_add_post_type');
if(!function_exists('finanzia_add_post_type')){
    function finanzia_add_post_type($postypes){
        $portfolio      = finanzia_get_opt('portfolio_slug', 'portfolio');
        $portfolio_name = finanzia_get_opt(
            'portfolio_name',
            esc_attr__('Portfolio', 'finanzia')
        );
        $postypes['portfolio'] = [
            'status'     => apply_filters('finanzia_enable_portfolio', false),
            'item_name'  => $portfolio_name,
            'items_name' => $portfolio_name,
            'args' => [
                'menu_icon'          => 'dashicons-admin-post',
                'supports'           => ['title', 'thumbnail', 'editor','excerpt'],
                'public'             => true,
                'publicly_queryable' => true,
                'rewrite'            => [
                    'slug' => $portfolio,
                ],
            ],
            'labels' => [],
        ];
        // Service
        $postypes['cms-service'] = [
            'status'     => apply_filters('finanzia_enable_service', false),
            'item_name'  => esc_html__('Service', 'finanzia'),
            'items_name' => esc_html__('Services', 'finanzia'),
            'args' => [
                'menu_icon'          => 'dashicons-admin-post',
                'supports'           => ['title', 'thumbnail', 'editor', 'excerpt'],
                'public'             => true,
                'publicly_queryable' => true,
                'rewrite'            => [
                    'slug' => apply_filters('finanzia_cms_service_slug', 'service'),
                ],
            ],
            'labels' => [],
        ];
        // Industry
        $postypes['cms-industry'] = [
            'status'     => apply_filters('finanzia_enable_industry', false),
            'item_name'  => esc_html__('Industry', 'finanzia'),
            'items_name' => esc_html__('Industries', 'finanzia'),
            'args' => [
                'menu_icon'          => 'dashicons-admin-post',
                'supports'           => ['title', 'thumbnail', 'editor', 'excerpt'],
                'public'             => true,
                'publicly_queryable' => true,
                'rewrite'            => [
                    'slug' => apply_filters('finanzia_cms_industry_slug', 'story'),
                ],
            ],
            'labels' => [],
        ];
        // Case
        $postypes['cms-case'] = [
            'status'     => apply_filters('finanzia_enable_case', false),
            'item_name'  => esc_html__('Case', 'finanzia'),
            'items_name' => esc_html__('Cases', 'finanzia'),
            'args' => [
                'menu_icon'          => 'dashicons-admin-post',
                'supports'           => ['title', 'thumbnail', 'editor', 'excerpt'],
                'public'             => true,
                'publicly_queryable' => true,
                'rewrite'            => [
                    'slug' => apply_filters('finanzia_cms_case_slug', 'cases'),
                ],
            ],
            'labels' => [],
        ];
        // career
        $postypes['cms-career'] = [
            'status'     => apply_filters('finanzia_enable_career', false),
            'item_name'  => esc_html__('Career', 'finanzia'),
            'items_name' => esc_html__('Careers', 'finanzia'),
            'args' => [
                'menu_icon'          => 'dashicons-admin-post',
                'supports'           => ['title', 'thumbnail', 'editor', 'excerpt'],
                'public'             => true,
                'publicly_queryable' => true,
                'rewrite'            => [
                    'slug' => apply_filters('finanzia_cms_career_slug', 'career'),
                ],
            ],
            'labels' => [],
        ];
        // Side Nav
        $postypes['cms-sidenav'] = [
            'status'     => apply_filters('finanzia_enable_sidenav', false),
            'item_name'  => esc_html__('Side Nav', 'finanzia'),
            'items_name' => esc_html__('Side Navs', 'finanzia'),
            'args'       => [
                'menu_icon'          => 'dashicons-editor-insertmore',
                'supports'           => ['title', 'editor', 'thumbnail'],
                'public'             => true,
                'publicly_queryable' => true,
                'exclude_from_search' => true
            ],
            'labels' => []
        ];
        // Header Top
        $postypes['cms-header-top'] = [
            'status'     => apply_filters('finanzia_enable_header_top', false),
            'item_name'  => esc_html__('Header Top', 'finanzia'),
            'items_name' => esc_html__('Headers Top', 'finanzia'),
            'args'       => [
                'menu_icon'          => 'dashicons-editor-insertmore',
                'supports'           => ['title', 'editor', 'thumbnail'],
                'public'             => true,
                'publicly_queryable' => true,
                'exclude_from_search' => true
            ],
            'labels' => []
        ];
        // Footer
        $postypes['cms-footer'] = [
            'status'     => apply_filters('finanzia_enable_footer', false),
            'item_name'  => esc_html__('Footer', 'finanzia'),
            'items_name' => esc_html__('Footers', 'finanzia'),
            'args'       => [
                'menu_icon'           => 'dashicons-editor-insertmore',
                'supports'            => ['title', 'editor', 'thumbnail'],
                'public'              => true,
                'publicly_queryable'  => true,
                'exclude_from_search' => true
            ],
            'labels' => []
        ];
        // Popup
        $postypes['cms-popup'] = [
            'status'     => apply_filters('finanzia_enable_popup', false),
            'item_name'  => esc_html__('Pop Up', 'finanzia'),
            'items_name' => esc_html__('Pop Ups', 'finanzia'),
            'args'       => [
                'menu_icon'           => 'dashicons-editor-insertmore',
                'supports'            => ['title', 'editor', 'thumbnail'],
                'public'              => true,
                'publicly_queryable'  => true,
                'exclude_from_search' => true
            ],
            'labels' => []
        ];
        return $postypes;
    }
}
add_filter('cms_extra_taxonomies', 'finanzia_add_tax');
if(!function_exists('finanzia_add_tax')){
    function finanzia_add_tax($taxonomies){
        // Portfolio
        $taxonomies['portfolio-category'] = [
            'status'      => apply_filters('finanzia_enable_portfolio', false),
            'post_type'   => ['portfolio'],
            'taxonomy'    => esc_html__('Portfolio Category', 'finanzia'),
            'taxonomies'  => esc_html__('Portfolio Categories', 'finanzia'),
            'args'        => [],
            'labels'      => [],
        ];
        if(apply_filters('finanzia_enable_service', false)){
            $taxonomies['service-category'] = [
                'status'      => apply_filters('finanzia_enable_service', false),
                'post_type'   => ['cms-service'],
                'taxonomy'    => esc_html__('Service Category', 'finanzia'),
                'taxonomies'  => esc_html__('Service Categories', 'finanzia'),
                'args'        => [],
                'labels'      => [],
            ];
            $taxonomies['service-tag'] = [
                'status'      => apply_filters('finanzia_enable_service', false),
                'post_type'   => ['cms-service'],
                'taxonomy'    => esc_html__('Service Tag', 'finanzia'),
                'taxonomies'  => esc_html__('Service Tags', 'finanzia'),
                'args'        => [],
                'labels'      => [],
            ];
        }
        if(apply_filters('finanzia_enable_industry', false)){
            $taxonomies['industry-category'] = [
                'status'      => apply_filters('finanzia_enable_industry', false),
                'post_type'   => ['cms-industry'],
                'taxonomy'    => esc_html__('Industry Category', 'finanzia'),
                'taxonomies'  => esc_html__('Industry Categories', 'finanzia'),
                'args'        => [],
                'labels'      => [],
            ];
            $taxonomies['industry-tag'] = [
                'status'      => apply_filters('finanzia_enable_industry', false),
                'post_type'   => ['cms-industry'],
                'taxonomy'    => esc_html__('Industry Tag', 'finanzia'),
                'taxonomies'  => esc_html__('Industry Tags', 'finanzia'),
                'args'        => [],
                'labels'      => [],
            ];
        }
        if(apply_filters('finanzia_enable_case', false)){
            $taxonomies['case-category'] = [
                'status'      => apply_filters('finanzia_enable_case', false),
                'post_type'   => ['cms-case'],
                'taxonomy'    => esc_html__('Case Category', 'finanzia'),
                'taxonomies'  => esc_html__('Case Categories', 'finanzia'),
                'args'        => [],
                'labels'      => [],
            ];
            $taxonomies['case-tag'] = [
                'status'      => apply_filters('finanzia_enable_case', false),
                'post_type'   => ['cms-case'],
                'taxonomy'    => esc_html__('Case Tag', 'finanzia'),
                'taxonomies'  => esc_html__('Case Tags', 'finanzia'),
                'args'        => [],
                'labels'      => [],
            ];
        }
        if(apply_filters('finanzia_enable_career', false)){
            $taxonomies['career-category'] = [
                'status'      => apply_filters('finanzia_enable_career', false),
                'post_type'   => ['cms-career'],
                'taxonomy'    => esc_html__('Career Category', 'finanzia'),
                'taxonomies'  => esc_html__('Career Categories', 'finanzia'),
                'args'        => [],
                'labels'      => [],
            ];
            $taxonomies['career-tag'] = [
                'status'      => apply_filters('finanzia_enable_career', false),
                'post_type'   => ['cms-career'],
                'taxonomy'    => esc_html__('Career Tag', 'finanzia'),
                'taxonomies'  => esc_html__('Career Tags', 'finanzia'),
                'args'        => [],
                'labels'      => [],
            ];
        }
        return $taxonomies;
    }
}
/**
 * ================================================
 * All function for Demo Data
 * 
 * @package CMS Theme
 * @subpackage Finanzia
 * @since 1.0
 * 
 * ================================================
 * 
*/
/* Create Demo Data */
if(!function_exists('finanzia_enable_export_mode')){
    function finanzia_enable_export_mode() {
        return defined('DEV_MODE') && DEV_MODE == true ? true : false;
    }
}
add_filter('swa_ie_export_mode', 'finanzia_enable_export_mode');
if (!function_exists('finanzia_cpt_dev_mode')) {
    function finanzia_cpt_dev_mode()
    {
        return defined('DEV_MODE') && DEV_MODE == true ? true : false;
    }
}
add_filter('cpt_dev_mode', 'finanzia_cpt_dev_mode');
/**
 * Update custom post type edit with Elementor
 * **/
if (!function_exists('finanzia_elementor_cpts')) {
    add_action('theme_core_ie_after_import', 'finanzia_elementor_cpts');
    add_action('after_switch_theme', 'finanzia_elementor_cpts');
    function finanzia_elementor_cpts(){
        $default = (array)get_option('elementor_cpt_support');
        $cpt_support = array_merge(
            $default, 
            [
                //core
                'post',
                'page',
                'cms-footer',
                'cms-header-top',
                'cms-mega-menu',
                'portfolio',
                // theme
                'cms-career',
                'cms-case',
                'cms-industry',
                'cms-service',
                'cms-sidenav',
                'cms-popup',
                // WooCommerce
                //'product'
            ]
        );
        update_option( 'elementor_cpt_support', $cpt_support );
    }
}
/*
 *  Dashboard Configurations
 */
if (!function_exists('finanzia_cms_cpt_dashboard_config')) {
    function finanzia_cms_cpt_dashboard_config()
    {
        return [
            'documentation_link'  => 'https://cmssuperheroes.gitbook.io/finanzia-wordpress-theme/',
            'ticket_link'         => 'https://cmssuperheroes.ticksy.com/',
            'video_tutorial_link' => 'https://www.youtube.com/c/CMSSuperheroes',
            'demo_link'           => 'https://demo.cmssuperheroes.com/themeforest/finanzia',
        ];
    }
}
if (!function_exists('finanzia_7oroof_cpt_dashboard_config')) {
    function finanzia_7oroof_cpt_dashboard_config()
    {
        return [
            'documentation_link'  => 'https://7oroof-themes.gitbook.io/finanzia-wordpress-theme/',
            'ticket_link'         => 'https://7oroof.com/support/',
            'video_tutorial_link' => 'https://www.youtube.com/channel/UCR57ptzvmUEhJ_jIB7QQavg',
            'demo_link'           => 'https://7oroof.com/tfdemos/finanzia/',
        ];
    }
}
if (!function_exists('finanzia_farost_cpt_dashboard_config')) {
    function finanzia_farost_cpt_dashboard_config()
    {
        return [
            'documentation_link'  => 'https://farost.gitbook.io/finanzia-wordpress-theme',
            'ticket_link'         => 'mailto:farost.agency@gmail.com',
            'video_tutorial_link' => 'https://www.youtube.com/channel/UCR57ptzvmUEhJ_jIB7QQavg',
            'demo_link'           => 'http://demo.7oroof.com/finanzia',
        ];
    }
}
$theme_upload_by = 'cms';
switch ($theme_upload_by) {
    case 'faro':
        add_filter('cpt_dashboard_config', 'finanzia_farost_cpt_dashboard_config');
        add_filter('cms_documentation_link', function(){ return finanzia_farost_cpt_dashboard_config()['documentation_link'];});
        add_filter('cms_ticket_link', function(){ return ['type' => 'url', 'link' => finanzia_farost_cpt_dashboard_config()['ticket_link']];});
        add_filter('cms_video_tutorial_link', function(){ return finanzia_farost_cpt_dashboard_config()['video_tutorial_link'];});
        break;

    case '7or':
        add_filter('cpt_dashboard_config', 'finanzia_7oroof_cpt_dashboard_config');
        add_filter('cms_documentation_link', function(){ return finanzia_7oroof_cpt_dashboard_config()['documentation_link'];});
        add_filter('cms_ticket_link', function(){ return ['type' => 'url', 'link' => finanzia_7oroof_cpt_dashboard_config()['ticket_link']];});
        add_filter('cms_video_tutorial_link', function(){ return finanzia_7oroof_cpt_dashboard_config()['video_tutorial_link'];});
        break;

    default:
        add_filter('cpt_dashboard_config', 'finanzia_cms_cpt_dashboard_config');
        add_filter('cms_documentation_link', function(){ return finanzia_cms_cpt_dashboard_config()['documentation_link'];});
        add_filter('cms_ticket_link', function(){ return ['type' => 'url', 'link' => finanzia_cms_cpt_dashboard_config()['ticket_link']];});
        add_filter('cms_video_tutorial_link', function(){ return finanzia_cms_cpt_dashboard_config()['video_tutorial_link'];});
        break;
}


/**
 * The Newsletter
 * 
 * Update Custom HTML Form
 * 
 * */
if(!function_exists('finanzia_thenewsletter_custom_html_form')){
    add_action('theme_core_ie_after_import', 'finanzia_thenewsletter_custom_html_form');
    function finanzia_thenewsletter_custom_html_form(){
        $htmlforms = (array)get_option('newsletter_htmlforms');
        $htmlforms['form_1'] = '<form method="post" action="http://localhost:8888/2024/finanzia/wp-admin/admin-ajax.php?action=tnp&na=s" class="cms-newsletter-sc-2 relative"><input type="hidden" name="nlang" value=""><div class="tnp-field tnp-field-email"><input class="tnp-email" type="email" name="ne" id="tnp-1" value="" placeholder="Your Email Address" required></div><div class="tnp-field tnp-field-button"><span class="absolute top-right mt-10 text-17 box-37 circle bg-accent text-white" type="submit"><svg viewBox="0 0 17 11" xmlns="http://www.w3.org/2000/svg"> <path d="M11.5248 10.309C11.2695 10.0543 11.2695 9.64136 11.5248 9.38667L14.7676 6.15217H0.653846C0.292737 6.15217 -3.15692e-08 5.86019 0 5.5C3.15692e-08 5.13981 0.292737 4.84783 0.653846 4.84783H14.7676L11.5248 1.61333C11.2695 1.35864 11.2695 0.945707 11.5248 0.691017C11.7802 0.436327 12.1942 0.436328 12.4495 0.691018L16.8085 5.03884C17.0638 5.29353 17.0638 5.70647 16.8085 5.96116L12.4495 10.309C12.1942 10.5637 11.7802 10.5637 11.5248 10.309Z"/> <path d="M11.5248 10.309C11.2695 10.0543 11.2695 9.64136 11.5248 9.38667L14.7676 6.15217H0.653846C0.292737 6.15217 -3.15692e-08 5.86019 0 5.5C3.15692e-08 5.13981 0.292737 4.84783 0.653846 4.84783H14.7676L11.5248 1.61333C11.2695 1.35864 11.2695 0.945707 11.5248 0.691017C11.7802 0.436327 12.1942 0.436328 12.4495 0.691018L16.8085 5.03884C17.0638 5.29353 17.0638 5.70647 16.8085 5.96116L12.4495 10.309C12.1942 10.5637 11.7802 10.5637 11.5248 10.309Z"/></svg></span><input class="tnp-submit cms-opacity-0" type="submit" value="Subscribe"></div></form>';
        //
        update_option( 'newsletter_htmlforms', $htmlforms );
    }
}

/**
 * =========================
 * End Demo Data
 * =========================
 * */
?>