<?php
// Silence is Golden
add_filter('tco_page_page_options_args', 'finanzia_page_options_args');
function finanzia_page_options_args(){
    $default       = true;
    $default_value = $default_on = $default_off = $default_width = '-1';
    $custom_opts   = true;

    $header_top = include get_template_directory() . '/inc/theme-options/args/header-top.php';
    $header     = include get_template_directory() . '/inc/post-type-options/args-page/header.php';
    $page_title = include get_template_directory() . '/inc/theme-options/args/page-title.php';
    $footer     = include get_template_directory() . '/inc/theme-options/args/footer.php';
    $popup      = include get_template_directory() . '/inc/theme-options/args/popup.php';

    $general = [
        'title' => esc_html__('General','finanzia'),
        'sections' => [
            'colors' => [
                'title' => esc_html__('Colors', 'finanzia'),
                'fields' => [
                    'color_custom' => finanzia_theme_on_off_opts([
                        'title'         => esc_html__('Custom Color','finanzia'),
                        'default'       => false,
                        'default_value' => 'off'
                    ]),
                    'accent_color' => [
                        'type'        => Theme_Core_Options::COLOR_SET_FIELD,
                        'title'       => esc_html__('Accent Color', 'finanzia'),
                        'options'     => finanzia_color_list_opts('accent_color'),
                        'required' => [
                            'color_custom', '=', 'on'
                        ]
                    ],
                    'primary_color' => [
                        'type'        => Theme_Core_Options::COLOR_SET_FIELD,
                        'title'       => esc_html__('Primary Color', 'finanzia'),
                        'options'     => finanzia_color_list_opts('primary_color'),
                        'required' => [
                            'color_custom', '=', 'on'
                        ]
                    ],
                    'heading_color' => array(
                        'type'    => Theme_Core_Options::COLOR_SET_FIELD,
                        'title'   => esc_html__('Heading Color', 'finanzia'),
                        'options' => finanzia_color_list_opts('heading_color'),
                        'required' => [
                            'color_custom', '=', 'on'
                        ]
                    ),
                    'body_color' => array(
                        'type'    => Theme_Core_Options::COLOR_SET_FIELD,
                        'title'   => esc_html__('Body Color', 'finanzia'),
                        'options' => [
                            'regular' => sprintf('%s (%s)', esc_html__('Default','finanzia'), finanzia_configs('body')['color'])
                        ],
                        'required' => [
                            'color_custom', '=', 'on'
                        ]
                    ),
                    'link_color' => [
                        'type' => Theme_Core_Options::LINK_COLOR_FIELD,
                        'title' => esc_html__('Link Color', 'finanzia'),
                        'required' => [
                            'color_custom', '=', 'on'
                        ]
                    ],
                    'custom_color' => [
                        'type'        => Theme_Core_Options::COLOR_SET_FIELD,
                        'title'       => esc_html__('Custom Color', 'finanzia'),
                        'options' => finanzia_color_list_opts('custom_color'),
                        'required' => [
                            'color_custom', '=', 'on'
                        ]
                    ]
                ]
            ],
            'typos'    => finanzia_typography_opts(),
            'advanced' => finanzia_general_advanced_opts()
        ]
    ];

    $content = [
        'title'  => esc_html__('Content', 'finanzia'),
        'fields' => [
            'content_width' => finanzia_theme_content_width_opts([
                'default'       => $default,
                'default_value' => $default_value
            ])
        ]
    ];

    $args = [  
        'general'    => $general,
        'header-top' => $header_top,
        'header'     => $header,
        'page-title' => $page_title,
        'content'    => $content,
        'footer'     => $footer,
        'popup'     => $popup,
    ];

    return $args;
}