<?php
// Silence is Golden
add_filter('tco_cms-industry_page_options_args', 'finanzia_cms_industry_options_args');
function finanzia_cms_industry_options_args(){
    $default       = true;
    $default_value = $default_on = $default_off = $default_width = '-1';
    $custom_opts   = true;


    $general = [
        'title' => esc_html__('General','finanzia'),
        'sections' => [
            'icons'    => finanzia_post_icon_opts([
                'label'    => esc_html__('Industry Info', 'finanzia'),
                'video'    => false,
                'name'     => false,
                'position' => false
            ])
        ]
    ];
    
    $args = [  
        'general'    => $general,
        'header'     => [
            'title' => esc_html__('Header', 'finanzia'),
            'fields' => array_merge(
                [
                    'header_custom' => finanzia_theme_on_off_opts([
                        'title'         => esc_html__('Custom Header','finanzia'),
                        'default'       => false,
                        'default_value' => 'off'
                    ]),
                    'header_transparent' => finanzia_theme_on_off_opts([
                        'title'         => esc_html__('Header Transparent', 'finanzia'),
                        'subtitle'      => esc_html__('Header transparent use with background.', 'finanzia'),
                        'default'       => $default,
                        'default_value' => $default_value,
                        'required' => [
                            'header_custom',
                            '=',
                            'on'
                        ]
                    ])
                ]
            )
        ]
    ];

    return $args;
}