<?php
// Silence is golden.
$args = [
    'title' => esc_html__('Header', 'finanzia'),
    'fields' => array_merge(
        [
            'header_custom' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Custom Header','finanzia'),
                'default'       => false,
                'default_value' => 'off'
            ]),
            'header_layout' => finanzia_theme_header_layout_opts([
                'default'       => $default,
                'default_value' => $default_value,
                'required'      => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ]),
            'header_menu' => [
                'type'     => Theme_Core_Options::SELECT_FIELD,
                'title'    => esc_html__('Main Navigation', 'finanzia'),
                'options'  => finanzia_menu_list(),
                'default'  => '_1',
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ],
            'main_menu_color' => [
                'type'     => Theme_Core_Options::LINK_COLOR_FIELD,
                'title'    => esc_html__('Menu Color', 'finanzia'),
                'required' => ['header_custom','=','on']
            ],
            'header_height' => [
                'type'     => 'dimensions',
                'title'    => esc_html__('Header Width / Height', 'finanzia'),
                'subtitle' => esc_html__('Set width / height for your Header', 'finanzia'),
                'width'    => false,
                'required' => [
                    'header_custom', '=','on'
                ]
            ],
            'extra' => [
                'type'  => Theme_Core_Options::HEADING_FIELD,
                'title' => esc_html__('Extra Settings', 'finanzia'),
                'required'      => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ],
            'header_width' => finanzia_theme_content_width_opts([
                'title'         => esc_html__('Header Content Width', 'finanzia'),
                'default'       => $default,
                'default_value' => $default_width,
                'required'      => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ]),
            'header_sticky' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Header Sticky', 'finanzia'),
                'subtitle'      => esc_html__('Header will be sticked when applicable.', 'finanzia'),
                'default'       => $default,
                'default_value' => $default_value,
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ]),
            'header_sticky_mode' => finanzia_select_opts([
                'title'         => esc_html__('Header Sticky Mode', 'finanzia'),
                'subtitle'      => esc_html__('Header will when:', 'finanzia'),
                'options'       => [
                    'srollup' => esc_html__('Scroll UP','finanzia'),
                    'always'  => esc_html__('Always', 'finanzia')  
                ],
                'default'       => true,
                'default_value' => '0',
                'required' => [
                    'header_sticky', '=', 'on'
                ]
            ]),
            'header_transparent' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Header Transparent', 'finanzia'),
                'subtitle'      => esc_html__('Header transparent use with background.', 'finanzia'),
                'default'       => $default,
                'default_value' => $default_value,
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ]),
            'transparent_menu_color' => [
                'type'        => Theme_Core_Options::LINK_COLOR_FIELD,
                'title'       => esc_html__('Menu Color', 'finanzia'),
                'subtitle' => esc_html__('Header Transparent Menu Color','finanzia'),
                'required'    => ['header_transparent', '=', 'on']
            ],
            'header_boxed' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Header Boxed', 'finanzia'),
                'subtitle'      => esc_html__('Make header boxed','finanzia'),
                'default'       => $default,
                'default_value' => $default_off,
                'required'      => ['header_custom','=','on']
            ]),
            'header_shadow' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Header Shadow', 'finanzia'),
                'subtitle'      => esc_html__('Add shadow at bottom of header','finanzia'),
                'default'       => $default,
                'default_value' => $default_value,
                'required' => ['header_custom','=','on']
            ]),
            'header_divider' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Divider', 'finanzia'),
                'subtitle'      => esc_html__('Add divider at bottom of header','finanzia'),
                'default'       => $default,
                'default_value' => $default_value,
                'required'      => ['header_custom','=','on']
            ]),
            'custom_logo' => [
                'type'  => Theme_Core_Options::HEADING_FIELD,
                'title' => esc_html__('Logo Settings', 'finanzia'),
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ],
            'logo' => [
                'type'  => Theme_Core_Options::MEDIA_FIELD,
                'title' => esc_html__('Logo', 'finanzia'),
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ],
            'logo_maxh' => [
                'type'     => 'dimensions',
                'title'    => esc_html__('Logo Dimensions', 'finanzia'),
                'subtitle' => esc_html__('Enter number.', 'finanzia'),
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ],
            'logo_mobile' => [
                'type'  => Theme_Core_Options::MEDIA_FIELD,
                'title' => esc_html__('Logo Tablet & Mobile', 'finanzia'),
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ],
            'logo_maxh_sm' => [
                'type'     => 'dimensions',
                'title'    => esc_html__('Logo Tablet & Mobile Dimensions', 'finanzia'),
                'subtitle' => esc_html__('Enter number.', 'finanzia'),
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ],

            'logo_light' => [
                'type' => Theme_Core_Options::MEDIA_FIELD,
                'title' => esc_html__('Logo - Header Transparent', 'finanzia'),
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ],
            'logo_light_mobile' => [
                'type'  => Theme_Core_Options::MEDIA_FIELD,
                'title' => esc_html__('Logo Tablet & Mobile - Header Transparent', 'finanzia'),
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ],
            'custom_attribute' => [
                'type'  => Theme_Core_Options::HEADING_FIELD,
                'title' => esc_html__('Attributes Settings', 'finanzia'),
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ],
            'search_icon' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Search Icon', 'finanzia'),
                'default'       => $default,
                'default_value' => $default_value,
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ]),
            'cart_icon' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Cart Icon', 'finanzia'),
                'default'       => $default,
                'default_value' => $default_value,
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ]),
            'h_mail_on' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Show/Hide Email', 'finanzia'),
                'default'       => $default,
                'default_value' => $default_value,
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ]),
            'h_phone_on' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Show/Hide Phone', 'finanzia'),
                'default'       => $default,
                'default_value' => $default_value,
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ]),
            'h_btn_on' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Show/Hide Button', 'finanzia'),
                'default'       => $default,
                'default_value' => $default_value,
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ]),
            'h_btn2_on' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Show/Hide Button #2', 'finanzia'),
                'default'       => $default,
                'default_value' => $default_value,
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ]),
            'show_header_social' => finanzia_theme_on_off_opts([
                'title'         => esc_html__('Show/Hide Social', 'finanzia'),
                'default'       => $default,
                'default_value' => $default_value,
                'required' => [
                    'header_custom',
                    '=',
                    'on'
                ]
            ])
        ],
        finanzia_woo_header_woocs_opts([
            'default'       => $default,
            'default_value' => $default_off,
            'required'      => [
                'header_custom',
                '=',
                'on'
            ]
        ]),
        finanzia_woo_header_wishlist_opts([
            'default'       => $default,
            'default_value' => $default_off,
            'required'      => [
                'header_custom',
                '=',
                'on'
            ]
        ]),
        finanzia_woo_header_compare_opts([
            'default'       => $default,
            'default_value' => $default_off,
            'required'      => [
                'header_custom',
                '=',
                'on'
            ]
        ]),
        finanzia_header_login_opts([
            'default'       => $default,
            'default_value' => $default_off,
            'required'      => [
                'header_custom',
                '=',
                'on'
            ]
        ]),
        finanzia_header_language_switcher_opts([
            'default'       => $default,
            'default_value' => $default_off,
            'required'      => [
                'header_custom',
                '=',
                'on'
            ]
        ]),
        finanzia_header_side_nav_opts([
            'default'       => true,
            'default_value' => '-1', 
            'required'      => [
                'header_custom',
                '=',
                'on'
            ]
        ])
    )
];
return $args;