<?php
// Video Banner
$settings['image']['id'] = !empty($settings['image']['id']) ? $settings['image']['id'] : get_post_thumbnail_id();
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => [
		'cms-evideo',
		'cms-evideo-'.$settings['layout'],
		'relative',
		'overflow-hidden'
	]
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'elementor-invisible',
		'pt'
	],
	'data-settings' => json_encode([
		'animation'       => 'fadeInUp',
		'animation_delay' => 300
	]),
	'style' => '--pt:100px;--pt-tablet:40px;'
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
<?php 
	finanzia_elementor_button_video_render($widget, $settings, [
		'name'       => 'video_link',
		// icon
		'icon'       => $widget->get_setting('video_icon'),
		'icon_size'	 => 15,
		'icon_color' => $widget->get_setting('video_text_color', 'white'),
		'icon_class' => 'absolute center rtl-flip box-95 circle cms-backdrop-1',
		// text
		'text'       => $widget->get_setting('video_text'),
		'text_class' => 'text-'.$widget->get_setting('video_text_color', 'accent'),
		// other
		'layout'        => '1',
		'class'         => '',
		'inner_class'   => 'relative',
		// content
		'content_class' => '',
		//
		'echo'          => true,
		'default'       => true,
		'stroke'        => true,
		'stroke_opts'   => [
			'width'       => 225,
			'height'      => 225,
			'color'       => 'var(--cms-'.$widget->get_setting('stroke_color', 'divider').')',
			'color_hover' => 'var(--cms-'.$widget->get_setting('stroke_color_hover', 'accent').')'		
		]
    ]);
?>
<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php echo nl2br( $settings['heading_text'] ); ?></h2>
</div>