<?php
$widget->add_render_attribute('wrap', [
	'class' => [
		'cms-evideo',
		($settings['lightbox'] != 'yes') ? 'cms-evideo-playback' : '',
		($settings['video_fit'] === 'yes') ? 'cms-evideo-fit' : '',
		'cms-evideo-'.$settings['layout'],
		'relative overflow-hidden',
		'cms-radius-24'
	],
]);
// Video Banner
$settings['image']['id'] = !empty($settings['image']['id']) ? $settings['image']['id'] : get_post_thumbnail_id();

if($settings['lightbox']!='yes' && !empty($settings['image']['id'])){
	$widget->add_render_attribute('wrap', [
		'style' => 'background-image:url('.wp_get_attachment_url($settings['image']['id']).');'
	]);
}
// video name
$video_name = !empty($settings['video_link_popup']) ? 'video_link_popup' : 'video_link';
// YT Video
$widget->add_render_attribute('yt-video',[
	'class'           => 'yt-video',
	'data-video-link' => $widget->get_setting('video_link'),
	'style'           => 'width: 100%;height:100%;'
]);
?>
<div class="pl-47 relative">
	<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
		<?php 
			if($settings['lightbox']!='yes'){
		?>
		<div <?php etc_print_html($widget->get_render_attribute_string('yt-video')); ?>></div>
		<?php } ?>
		<?php
			finanzia_elementor_image_render($settings, [
				'custom_size'   => ['width' => 730,'height' => 554],
				'img_class'     => 'img-cover cms-radius-24',
				'before'        => '',
				'min_height'	=> true,
				'max_height'	=> true,
				'after'         => ''
		    ]);
		?>
	</div>
	<?php 
		// button video
    	finanzia_elementor_button_video_render($widget, $settings, [
			'name'       => 'video_link_popup',
			// icon
			'icon'       => $widget->get_setting('video_icon'),
			'icon_size'	 => 15,
			'icon_color' => $widget->get_setting('video_text_color', 'white'),
			'icon_class' => '',
			// text
			'text'       => '', //$widget->get_setting('video_text'),
			'text_class' => '', //'text-'.$widget->get_setting('video_text_color', 'white'),
			// other
			'layout'        => '1',
			'class'         => 'box-67 absolute top-left mt-40 bg-secondary cms-radius-tltrbl-24 cms-hover-zoomout',
			'inner_class'   => 'inner_class',
			// content
			'content_class' => 'pt-5',
			//
			'echo'          => true,
			'default'       => true,
			'stroke'        => false,
			'stroke_opts' => [
				'width'       => 140,
				'height'      => 140,
				'color'       => 'var(--cms-'.$widget->get_setting('video_text_color', 'white').')',
				'color_hover' => 'var(--cms-'.$widget->get_setting('video_text_color', 'white').')'		
			],
			//
			'lightbox' => 'yes',
			'before'   => '',
			'after'	   => ''	
	    ]);
	?>
</div>
