<?php
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => [
		'cms-evideo',
		'cms-evideo-'.$settings['layout'],
		'relative'
	]
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-26',
		'text-'.$widget->get_setting('heading_color','heading'),
		'mt-n7 pb-15'
	]
]);
// Description Bold
$widget->add_inline_editing_attributes( 'desc_bold' );
$widget->add_render_attribute( 'desc_bold', [
	'class' => array_filter([
		'cms-desc-bold font-700 empty-none',
		'text-'.$widget->get_setting('desc_bold_color','heading'),
		'pb-25'
	])
]);
// Description
$widget->add_inline_editing_attributes( 'description_text' );
$widget->add_render_attribute( 'description_text', [
	'class' => array_filter([
		'cms-desc empty-none',
		'text-'.$widget->get_setting('description_color','body'),
		'pb-35'
	])
]);
// Description #2
$widget->add_inline_editing_attributes( 'description2_text' );
$widget->add_render_attribute( 'description2_text', [
	'class' => array_filter([
		'cms-desc2 empty-none',
		'text-'.$widget->get_setting('description2_color','body'),
		'pt-40'
	])
]);
?>
<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php echo nl2br( $settings['heading_text'] ); ?></h2>
<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc_bold' ) ); ?>><?php echo wpautop( $settings['desc_bold'] ); ?></div>
<div <?php etc_print_html( $widget->get_render_attribute_string( 'description_text' ) ); ?>><?php echo wpautop( $settings['description_text'] ); ?></div>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
<?php 
	// Video Banner
	$settings['image']['id'] = !empty($settings['image']['id']) ? $settings['image']['id'] : get_post_thumbnail_id();
    finanzia_elementor_image_render($settings, [
		'custom_size'   => ['width' => 840,'height' => 560],
		'img_class'     => 'img-cover',
		'before'        => '',
		'max_height'	=> true,
		'after'         => finanzia_elementor_button_video_render($widget, $settings, [
			'name'       => 'video_link',
			// icon
			'icon'       => $widget->get_setting('video_icon'),
			'icon_size'	 => 15,
			'icon_color' => $widget->get_setting('video_text_color', 'white'),
			'icon_class' => 'absolute center rtl-flip box-95 circle cms-backdrop-1',
			// text
			'text'       => $widget->get_setting('video_text'),
			'text_class' => 'text-'.$widget->get_setting('video_text_color', 'white').' text-nowrap absolute left-center cms-transition',
			// other
			'layout'      => '1',
			'class'       => 'cms-overlay',
			'inner_class' => 'absolute center cms-transition',
			// content
			'content_class' => '',
			//
			'echo'        => false,
			'default'     => true,
			'stroke'      => true,
			'stroke_opts' => [
				'width'       => 225,
				'height'      => 225,
				'color'       => 'var(--cms-'.$widget->get_setting('stroke_color', 'divider-30').')',
				'color_hover' => 'var(--cms-'.$widget->get_setting('stroke_color_hover', 'white').')'		
			]
	    ])
    ]);
?>
</div>
<div <?php etc_print_html( $widget->get_render_attribute_string( 'description2_text' ) ); ?>><?php echo wpautop( $settings['description2_text'] ); ?></div>
