<?php
// Wrap
$widget->add_render_attribute('wrap', [
    'class' => [
        'cms-eprocess-sticky',
        'cms-eprocess-sticky-'.$settings['layout'],
    ]
]);
// Items
$widget->add_render_attribute('items',[
    'class' => [
        'cms-eprocess-item',
        'd-flex',
    ]
]);
// Process Lists
$process = $widget->get_setting('process_list', []);
$count1 =  $count2 =0;
?>           
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
    <div class="cms-hidden-mobile-extra">
        <div <?php etc_print_html($widget->get_render_attribute_string('items')); ?>>
            <div class="col-6">
                <div class="cms-scroller overflow-hidden relative" data-percent="100">
                    <?php  foreach ($process as $key => $_process) { 
                        $item_key = $widget->get_repeater_setting_key( 'item', 'cms_scroll_sticky', $key );
                        $widget->add_render_attribute($item_key, [
                            'class' => [
                                'imageToShow',
                                'cms-sroller-item-right',
                                'w-100',
                                'd-flex align-items-center h-100vh'
                            ],
                            'data-equal' => 'cms-'.$_process['_id']
                        ]);
                        if($key!=0){
                            $widget->add_render_attribute($item_key,[
                                'class' => 'fromLeft absolute top',
                                'style' => [
                                    'right:100%;'
                                ]
                            ]);
                        }
                        ?>
                        <div <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>>
                            <?php 
                                finanzia_elementor_image_render($_process,[
                                    'name'           => 'banner',
                                    'image_size_key' => 'banner',
                                    'img_class'      => 'img-cover',
                                    'size'           => 'full',
                                    'custom_size'    => ['width' => 800, 'height' => 900],
                                    'max_height'     => true,  
                                    'attrs'          => [],
                                    'before'         => '',
                                    'after'          => ''
                                ]);
                            ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <div class="col-6">
                <?php foreach ($process as $key => $_process) { 
                    $count1++;
                ?>
                    <div class="cms-process-content h-100vh d-flex flex-column justify-content-center max-w p-tb-40 pl" id="cms-<?php echo esc_attr($_process['_id']) ?>" style="--max-w:640px;--pl:130px;--pl-tablet-extra:40px;">
                        <div class="cms-heading text-26 text-mobile-20 font-700 mt-n7 empty-none"><?php etc_print_html($_process['title']); ?></div>
                        <div class="desc pt-25 mb-n5 empty-none"><?php etc_print_html($_process['desc']); ?></div>
                        <?php 
                            finanzia_elementor_icon_image_render($widget, $settings, [
                                'size'        => 64,
                                'class'       => 'pt',
                                'color'       => '',        
                                'color_hover' => '',
                                'before'      => '',
                                'after'       => '',
                                'attrs'       => [
                                    'style' => '--pt:48px;'
                                ]
                            ], $_process);
                        ?>
                    </div>
                <?php 
                    }
                ?>
            </div>
        </div>
    </div>
    <div class="cms-hidden-min-mobile-extra">
        <?php // responsive 
            foreach ($process as $key => $_process) { 
            $count2++;
            // Items
            $item_key = $widget->get_repeater_setting_key('item_key', 'cms_process', $key);
            $widget->add_render_attribute($item_key, [
                'class' => [
                    'cms-process',
                    'd-flex gutter'
                ],
                'data-target' => 'cms-'.$_process['_id']
            ]);
            if($key>0){
                $widget->add_render_attribute($item_key, [
                    'class' => [
                        'pt-40'
                    ]
                ]);
            }
        ?>
            <div <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>>
                <div class="col-4 col-tablet-5 col-mobile-12">
                    <?php // Count
                        finanzia_leading_zero($count2, '<div class="pb" style="--pb:42px;">', '.</div>');
                    ?>
                    <div class="cms-heading text-26 text-mobile-20 font-700 mt-n7 empty-none"><?php etc_print_html($_process['title']); ?></div>
                    <div class="desc pt-25 mb-n5 empty-none"><?php etc_print_html($_process['desc']); ?></div>
                    <?php 
                        finanzia_elementor_icon_image_render($widget, $settings, [
                            'size'        => 64,
                            'class'       => 'pt',
                            'color'       => '',        
                            'color_hover' => '',
                            'before'      => '',
                            'after'       => '',
                            'attrs'       => [
                                'style' => '--pt:48px;'
                            ]
                        ], $_process);
                    ?>
                </div>
                <div class="col-8 col-tablet-7 col-mobile-12 order-mobile-first"><?php
                    finanzia_elementor_image_render($_process,[
                        'name'                => 'banner',
                        'image_size_key'      => 'banner',
                        'img_class'           => '',
                        'size'                => 'full',
                        'custom_size'         => ['width' => 770, 'height' => 514],
                        'before'              => '<div id="cms-'.$_process['_id'].'" class="cms-sticky">',
                        'after'               => '</div>'
                    ]);
                ?></div>
            </div>
        <?php
            }
        ?>
    </div>
</div>