<?php
$default_align = 'start';
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-eprocess-scroll',
		'cms-eprocess-scroll-'.$settings['layout'],
		'text-'.$widget->get_setting('align', $default_align),
		'd-flex'
	])
]);
// Small Heading
$widget->add_inline_editing_attributes( 'smallheading_text' );
$widget->add_render_attribute( 'smallheading_text', [
	'class' => [
		'cms-smallheading cms-nl2br',
		'text-15',
		'text-'.$widget->get_setting('smallheading_color','body'),
		'pb-20 m-tb-n7',
		'empty-none'
	]
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading cms-nl2br empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'm-tb-n10'
	]
]);
// Description
$widget->add_inline_editing_attributes( 'desc', 'none' );
$widget->add_render_attribute( 'desc', [
	'class' => [
		'cms-desc cms-nl2br empty-none',
		'text-'.$widget->get_setting('desc_color','body'),
		'm-tb-n7'
	]
]);
// Process
$process = $widget->get_setting('process_list2', []);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div class="cms-process-left flex-auto pt-130 pt-tablet-40 pb-110 pb-tablet-40 max-w" style="--max-w:550px;--max-w-tablet:100%;">
		<div <?php etc_print_html( $widget->get_render_attribute_string( 'smallheading_text' ) ); ?>><?php echo nl2br( $settings['smallheading_text'] ); ?></div>
		<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php echo nl2br( $settings['heading_text'] ); ?></h2>
		<div class="cms-swiper-vertical swiper cms-hidden-max-tablet mt" style="--mt:70px;">
			<div class="cms-swiper-wrapper swiper-wrapper">
				<?php 
					// Process Item
					$count = 0;
					foreach($process as $key => $_process){ 
					$count ++;
					// Items
					$item_key = $widget->get_repeater_setting_key('item_key', 'cms_process', $key);
					$widget->add_render_attribute($item_key, [
						'data-target' => 'cms-'.$_process['_id'],
						'class' => [
							'cms-process',
							'max-w',
							'relative',
							'pl-110 pl-tablet-40'
						]
					]);
					if($key>0){
						$widget->add_render_attribute($item_key, [
							'class' => [
								//'pt-100 pt-tablet-40'
							]
						]);
					}
				?>
				<div class="cms-swiper-slide swiper-slide">
					<div <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>>
						<?php 
							// Count
							finanzia_leading_zero($count, '<span class="absolute top-left pt-45">', '.</span>');
						?>
						<div class="d-flex flex-nowrap justify-content-between gap-20">
							<div class="flex-basic max-w" style="--max-w: 290px;">
								<div class="cms-heading text-19 mt-n5 empty-none"><?php etc_print_html($_process['title']); ?></div>
								<div class="desc text-15 pt-15 empty-none"><?php etc_print_html($_process['desc']); ?></div>
							</div>
							<?php 
								finanzia_elementor_icon_image_render($widget, $settings, [
									'size'        => 64,
									'class'       => 'flex-auto pt-30',
									'color'		  => '',		
									'color_hover' => '',
									'before'	  => '',
									'after'		  => ''
								], $_process);
							?>
						</div>
					</div>
				</div>
				<?php } ?>
			</div>
			<div class="cms-swiper-scrollbar cms-swiper-scrollbar-1"></div>
		</div>
		<div class="cms-edesc pt-70 pt-tablet-40 pl-110 pl-tablet-0 mt-tablet-40">
			<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc' ) ); ?>><?php echo nl2br( $settings['desc'] ); ?></div>
			<?php 
				// Button #1
				finanzia_elementor_link_render($widget, $settings, [
					'name' 		=> 'link1_',
					'mode'		=> 'btn',
					'text_icon'	=> finanzia_svgs_icon([
						'icon'       => 'core/long-arrow-right',
						'icon_class' => '',
						'echo'       => false,
						'class'      => 'text-17'
					]),
					'class'           => 'mt-40 cms-hover-move-icon-right',
					'btn_color'       => 'accent',
					'btn_color_hover' => 'accent-darken'
				]);
			?>
		</div>
	</div>
	<div class="cms-process-right flex-basic pl cms-hidden-max-tablet max-w pl h-100 cms-sticky" style="--max-w:calc(100% - 550px);--max-w-tablet:100%;--pl:90px;--pl-tablet-extra:40px;">
		<div class="cms-process-banners cms-sticky swiper">
			<div class="cms-process-banner swiper-wrapper">
				<?php 
					// Process Item
					foreach($process as $key => $_process){ 
				?>
					<div class="swiper-slide">
						<?php 
							// Banner
							finanzia_elementor_image_render($_process, [
								'name'        => 'banner',
								'size'        => 'custom',
								'custom_size' => ['width' => 800, 'height' => 900],
								'img_class'   => 'process-banner img-cover',
								'max_height'	=> true
							]);
						?>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
	<div class="cms-hidden-min-tablet-extra w-100 pt-40">
		<?php 
			// Process Item
			foreach($process as $key => $_process){ 
		?>
			<div class="cms-process-item d-flex gutter <?php if($key>0) echo 'pt-20'; ?>">
				<div class="col-6 col-mobile-12">
					<div class="cms-sticky" style="--cms-sticky:20px;"><?php 
							// Icon/ Image
							finanzia_elementor_icon_image_render($widget, $_process, [
								'size'        => 64,
								'color'       => 'accent',
								'color_hover' => 'accent',
								'icon_class'  => 'cms-icon',
								//
								'class'	 => '',
								'before' => '<div class="process-icon-img mb-30">',
								'after'	 => '</div>'
							]);
						?>
						<div class="cms-title text-22 lh-12727 font-600 text-primary mt-n7 pb-8"><?php etc_print_html($_process['title']); ?></div>
						<div class="cms-desc text-15"><?php etc_print_html($_process['desc']); ?></div>
					</div>
				</div>
				<?php 
					// Banner
					finanzia_elementor_image_render($_process, [
						'name'        => 'banner',
						'size'        => 'custom',
						'custom_size' => ['width' => 400, 'height' => 450],
						'img_class'   => 'process-banner img-cover',
						'max_height'  => true,
						'before'      => '<div class="col-6 col-mobile-12 order-mobile-first">',
						'after'       => '</div>'
					]);
				?>
			</div>
		<?php } ?>
	</div>
</div>