<?php
$html_id            = etc_get_element_id( $settings );
$active_section     = $widget->get_settings('active_section', 1);
$accordions         = $widget->get_settings('contents_2');
// wrap
$widget->add_render_attribute('wrap', [
	'class' => [
		'cms-accordion-sticky',
		'cms-accordion-sticky-'.$settings['layout']
	]
]);
// Item Heading
$widget->add_render_attribute('item-heading', [
	'class' => [
		'cms-accordion-item',
		'cms-accordion-item-heading',
		'd-flex',
		'overflow-hidden',
		// 'min-h'
	],
	// 'style' => '--min-h:500px;'
]);
// Small Heading
$widget->add_inline_editing_attributes( 'smallheading_text' );
$widget->add_render_attribute( 'smallheading_text', [
	'class' => [
		'cms-smallheading text-15',
		'text-'.$widget->get_setting('smallheading_color','body'),
		'm-tb-n7',
		'col-5 col-tablet-4 col-mobile-12'
	]
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'm-tb-n10',
		'col-7 col-tablet-8 col-mobile-12',
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div <?php etc_print_html($widget->get_render_attribute_string('item-heading')); ?>>
		<div <?php etc_print_html( $widget->get_render_attribute_string( 'smallheading_text' ) ); ?>><?php echo nl2br( $settings['smallheading_text'] ); ?></div>
		<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php echo nl2br( $settings['heading_text'] ); ?></h2>
	</div>
	<?php 
		$count = 0;
		foreach ( $accordions as $key => $value ):
			$count ++;
			$_id        = 'cms-accordion-'.$value['_id'];
			$ac_title   = isset( $value['ac_title'] ) ? $value['ac_title'] : '';
			$ac_content = isset( $value['ac_content'] ) ? $value['ac_content'] : '';
			$ac_content2 = isset( $value['ac_content2'] ) ? $value['ac_content2'] : '';
			$ac_border_color = isset( $value['ac_border_color'] ) ? $value['ac_border_color'] : 'primary-lighten';

			$sticky = ($key*97)+100;
			$sticky_tablet = ($key*97)+30;
			// item
			$item_key = $widget->get_repeater_setting_key( 'item_key', 'cms_accordion', $key );
			$widget->add_render_attribute( $item_key, [
				'class' => [ 
					'cms-accordion-item',
					'd-flex',
					'pt-40 pb-40 bdr-t-1 bdr-divider'
				]
			]);
			// item title
			$title_key = $widget->get_repeater_setting_key( 'title_key', 'cms_accordion', $key );
			$widget->add_render_attribute( $title_key, [
				'class' => [ 
					'cms-accordion-title',
					'cms-nl2br empty-none',
					'text-19 font-700 text-primary',
					'pb m-tb-n8'
				],
				'data-target' => '#'.$_id,
				'style' => '--pb:60px;'
			]);
			// content #1
			$content_key1 = $widget->get_repeater_setting_key( 'ac_content1', 'cms_accordion', $key );
			$widget->add_render_attribute( $content_key1, [
				'class' => [ 
					'cms-accordion-content-heading heading',
					'cms-nl2br empty-none',
					'text-26 lh-1307',
					'text-heading',
					'm-tb-n7'
				]
			] );
			// content
			$content_key2 = $widget->get_repeater_setting_key( 'ac_content2', 'cms_accordion', $key );
			$widget->add_render_attribute( $content_key2, [
				'id'    => $_id,
				'class' => [ 
					'cms-accordion-content-2',
					'cms-nl2br empty-none',
					'text-body',
					'pt-30 m-tb-n7'
				]
			] );
		?>
		<div class="relative bg-white overflow-hidden">
			<div <?php etc_print_html( $widget->get_render_attribute_string( $item_key ) ); ?>>
				<div class="col-5 col-tablet-4 col-mobile-12"></div>
				<div class="col-7 col-tablet-8 col-mobile-12">
					<div class="pr-110 pr-tablet-extra-0">
						<div <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>>
					    	<?php echo nl2br( $ac_title ); ?>
					    </div>
						<?php 
							// Icon
							finanzia_elementor_icon_image_render($widget, $settings,[
								'size'        => 48,
					            'color'       => $widget->get_setting('icon_color','accent'),
					            'color_hover' => $widget->get_setting('icon_color','accent'),
					            // icon
					            'icon_tag'    => 'div',
					            'icon_default' => [],
					            // default
					            'class'      => 'mb-55',
					            'before'     => '',
					            'after'      => '',
					            'echo'       => true
							], $value);
						?>
					    <div <?php etc_print_html( $widget->get_render_attribute_string( $content_key1 ) ); ?>><?php 
							echo nl2br( $ac_content );
						?></div>
						<div <?php etc_print_html( $widget->get_render_attribute_string( $content_key2 ) ); ?>><?php 
							echo nl2br( $ac_content2 );
						?></div>
					</div>
				</div>
			</div>
		</div>
		<?php
		endforeach;
	?>
</div>