<?php
$default_align = 'start';
$testimonials = $widget->get_setting('testimonials', []);
$layout_mode = $widget->get_setting('layout_mode', 'carousel');
// Arrows
$arrows = $widget->get_setting('arrows');
$widget->add_render_attribute('arrows', [
    'class' => [
        'cms-swiper-buttons d-flex gap-10 flex-auto',
        finanzia_add_hidden_device_controls_render($settings, 'arrows_')
    ]
]);
$arrows_classes = [
    'cms-carousel-button text-19',
    'box-67 circle',
    'text-'.$widget->get_setting('arrow_color','accent'),
    'bg-'.$widget->get_setting('arrow_bg_color','grey'),
    'text-hover-'.$widget->get_setting('arrow_hover_color','white'),
    'bg-hover-'.$widget->get_setting('arrow_bg_hover_color','accent')
];
$arrows_classes_prev = finanzia_nice_class(array_merge(['cms-carousel-button-prev prev'],$arrows_classes));
$arrows_classes_next = finanzia_nice_class(array_merge(['cms-carousel-button-next next'],$arrows_classes));

// Dots
$dots = $widget->get_setting('dots');
$widget->add_render_attribute('dots', [
    'class' => [
        'cms-carousel-dots cms-carousel-dots-bullets',
        'justify-content-end gap-10 flex-basic',
        finanzia_add_hidden_device_controls_render($settings, 'dots_')
    ],
    'style' => [
        '--cms-dots-color:var(--cms-grey);',
        '--cms-dots-hover-color:var(--cms-accent);'
    ]
]);

// Wrap
$widget->add_render_attribute('wrap', [
    'class' => [
        'cms-ettmn',
        'cms-ettmn-'.$widget->get_setting('layout_mode','carousel'),
        'cms-ettmn-'.$settings['layout']
    ]
]);
if($layout_mode == 'grid'){
    $widget->add_render_attribute('wrap', [
        'class' => [
            finanzia_elementor_get_grid_columns($widget, $settings)
        ]
    ]);
}
// Description 
$widget->add_render_attribute('description',[
    'class' => [
       'cms-ttmn-desc heading text-26 text-mobile-20 lh-1461 font-500',
       'text-'.$widget->get_setting('desc_color','heading'),
       'text-'.$default_align,
       'm-tb-n7 pb'
    ],
    'style' => [
        '--pb:70px;',
        '--pb-mobile-extra:20px;'
    ]
]);
// Author Name
$widget->add_render_attribute('ttmn-author',[
    'class' => [
        'cms-ttmn--name cms-heading text-17 empty-none',
        'text-'.$widget->get_setting('author_color', 'heading')
    ]
]);
// Author Position
$widget->add_render_attribute('ttmn-author-pos',[
    'class' => [
        'cms-ttmn--pos text-15 pt-5 mb-n5',
        'text-'.$widget->get_setting('author_pos_color', 'body')
    ]
]);

// Items
$widget->add_render_attribute('ttmn-item',[
    'class' => [
        'cms-ttmn-item'
    ]
]);
// Quote Icon
$quote_icon = finanzia_svgs_icon([
    'icon'  => 'quote',
    'class' => 'absolute bottom-right text-white text-64 mr-n2',
    'echo'  => false
]);
?>
<div class="d-flex justify-content-end">
    <div class="col-7 col-tablet-extra-9 col-tablet-10 col-mobile-extra-12 cms-nl2br text-15 pb-30 pl-20 pl-mobile-extra-0 m-tb-n5"><?php 
        echo nl2br($settings['eheading']);
    ?></div>
</div>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
    <?php switch ($layout_mode) {
        case 'grid':
            $widget->add_render_attribute('ttmn-item', [
                'class' => 'cms-ttmn-grid-item'
            ]);
            break;
        
        default:
            $widget->add_render_attribute('ttmn-item', [
                'class' => 'cms-carousel-item swiper-slide'
            ]);
    ?>
        <div class="cms-carousel swiper">
            <div class="swiper-wrapper">
    <?php
            break;
    } ?>
            <?php foreach ($testimonials as $key => $testimonial) {
            ?>
                <div <?php etc_print_html($widget->get_render_attribute_string('ttmn-item')); ?>>
                    <div class="cms-ttmn--item d-flex gutter-custom" style="--gutter:40px;--gutter-mobile-extra:20px;">
                        <div class="cms-ttmn-info col-5 col-tablet-extra-3 col-tablet-2 col-mobile-3 col-smobile-12">
                            <?php
                                finanzia_elementor_image_render($testimonial,[
                                    'name'           => 'image',
                                    'image_size_key' => 'image',
                                    'img_class'      => 'cms-ttmn--img cms-radius-5',
                                    'size'           => 'custom',
                                    'custom_size'    => ['width' => 180, 'height' => 240],
                                    'attrs'          => [],
                                    'before'         => '<div class="cms-ttmn-img relative mb mt d-inline-block" style="--mt:-45px;--mt-mobile-extra:0;--mb:25px;">',
                                    'after'          => $quote_icon.'</div>'
                                ]);
                            ?>
                            <div <?php etc_print_html($widget->get_render_attribute_string('ttmn-author')); ?>><?php echo esc_html($testimonial['name']); ?></div>
                            <div <?php etc_print_html($widget->get_render_attribute_string('ttmn-author-pos')); ?>><?php echo esc_html($testimonial['position']); ?></div>
                        </div>
                        <div class="cms-ttmn-content col-7 col-tablet-extra-9 col-tablet-10 col-mobile-9 col-smobile-12">
                            <div <?php etc_print_html($widget->get_render_attribute_string('description')); ?>><?php 
                                etc_print_html($testimonial['description']); 
                            ?></div>
                        </div>
                    </div>
                </div>
            <?php } ?>
    <?php switch ($layout_mode) {
        case 'grid':
            // code...
            break;
        default:
            // code...
    ?>
            </div>
        </div>
        <div class="d-flex gutter-40 justify-content-end mt" style="--mt:-53px;--mt-mobile-extra:0;">
            <div class="col-7 col-tablet-extra-9 col-tablet-10 col-mobile-9 col-smobile-12 cms-swiper-buttons-dots d-flex gap-20 align-items-end justify-content-between empty-none"><?php
                // Arrows
                if ($arrows == 'yes'){ ?>
                    <div <?php etc_print_html($widget->get_render_attribute_string('arrows')); ?>><?php 
                        finanzia_elementor_icon_render(
                            [], 
                            [
                                'library' => 'svg',
                                'value'   => [
                                    'id'  => '',
                                    'url' => get_template_directory().'/assets/svgs/core/arrow-left.svg'
                                ]
                            ], 
                            [
                                'class'     => $arrows_classes_prev,
                                'icon_size' => 19
                            ], 
                            'div'
                        );
                        finanzia_elementor_icon_render(
                            [], 
                            [
                                'library' => 'svg',
                                'value'   => [
                                    'id'  => '',
                                    'url' => get_template_directory().'/assets/svgs/core/arrow-right.svg'
                                ]
                            ], 
                            [
                                'class'     => $arrows_classes_next,
                                'icon_size' => 19
                            ], 
                            'div'
                        );
                    ?></div>
                <?php }
                // Dots
                if ($dots == 'yes') { ?>
                    <div <?php etc_print_html($widget->get_render_attribute_string('dots')); ?>></div>
                <?php } 
            ?></div>
        </div>
    <?php
            break;
    } ?>
</div>
