<?php
$default_align = 'start';
$testimonials = $widget->get_setting('testimonials', []);
$layout_mode = $widget->get_setting('layout_mode', 'carousel');
// Arrows
$arrows = $widget->get_setting('arrows');
$widget->add_render_attribute('arrows', [
    'class' => [
        'cms-swiper-buttons d-flex gap-10 flex-auto',
        finanzia_add_hidden_device_controls_render($settings, 'arrows_')
    ]
]);
$arrows_classes = [
    'cms-carousel-button text-19',
    'box-67 circle',
    'text-'.$widget->get_setting('arrow_color','accent'),
    'bg-'.$widget->get_setting('arrow_bg_color','grey'),
    'text-hover-'.$widget->get_setting('arrow_hover_color','white'),
    'bg-hover-'.$widget->get_setting('arrow_bg_hover_color','accent')
];
$arrows_classes_prev = finanzia_nice_class(array_merge(['cms-carousel-button-prev prev'],$arrows_classes));
$arrows_classes_next = finanzia_nice_class(array_merge(['cms-carousel-button-next next'],$arrows_classes));

// Dots
$dots = $widget->get_setting('dots');
$widget->add_render_attribute('dots', [
    'class' => [
        'cms-carousel-dots cms-carousel-dots-bullets',
        'justify-content-start gap-10 flex-basic',
        finanzia_add_hidden_device_controls_render($settings, 'dots_')
    ],
    'style' => [
        '--cms-dots-color:var(--cms-grey);',
        '--cms-dots-hover-color:var(--cms-accent);'
    ]
]);

// Wrap
$widget->add_render_attribute('wrap', [
    'class' => [
        'cms-ettmn',
        'cms-ettmn-'.$widget->get_setting('layout_mode','carousel'),
        'cms-ettmn-'.$settings['layout'],
        'd-flex gutter',
        'relative'
    ]
]);
if($layout_mode == 'grid'){
    $widget->add_render_attribute('wrap', [
        'class' => [
            finanzia_elementor_get_grid_columns($widget, $settings)
        ]
    ]);
}
// Description 
$widget->add_render_attribute('description',[
    'class' => [
       'cms-ttmn-desc heading text-26 text-mobile-20 lh-1461 font-700',
       'text-'.$widget->get_setting('desc_color','heading'),
       'text-'.$default_align,
       'swiper-nav-vert',
       'm-tb-n10'
    ]
]);
// Author Name
$widget->add_render_attribute('ttmn-author',[
    'class' => [
        'cms-ttmn--name cms-heading text-17 empty-none',
        'text-'.$widget->get_setting('author_color', 'heading')
    ]
]);
// Author Position
$widget->add_render_attribute('ttmn-author-pos',[
    'class' => [
        'cms-ttmn--pos text-15 mb-n5',
        'text-'.$widget->get_setting('author_pos_color', 'body')
    ]
]);

// Items
$widget->add_render_attribute('ttmn-item',[
    'class' => [
        'cms-ttmn-item'
    ]
]);
// Quote Icon
$quote_icon = finanzia_svgs_icon([
    'icon'  => 'quote',
    'class' => 'absolute bottom-right text-white text-48 mr-n1',
    'echo'  => false
]);
// Parallax icon/image
wp_enqueue_style('e-animation-zoomIn');
wp_enqueue_style('e-animation-zoomOut');
$widget->add_render_attribute('parallax', [
    'class' => [
        'absolute top-left',
        'cms-parallax',
        'elementor-invisible'
    ],
    'data-parallax' => json_encode([
        'y' => 300,
        //'x' => 0,
        //'z' => 40,
        //'rotate' => 360
    ]),
    'data-settings' => json_encode([
        'animation' => 'zoomOut'
    ])
]);
finanzia_elementor_icon_image_render($widget, $settings, [
    'size'   => 290,
    'before' => '<div '.$widget->get_render_attribute_string('parallax').'>',
    'after'  => '</div>'
]);
?>
<div class="d-flex justify-content-end">
    <div class="col-7 col-tablet-9 col-mobile-extra-12 cms-nl2br text-15 pb-30 pl-20 pl-mobile-extra-0 m-tb-n5"><?php 
        echo nl2br($settings['eheading']);
    ?></div>
</div>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
    <?php switch ($layout_mode) {
        case 'grid':
            $widget->add_render_attribute('ttmn-item', [
                'class' => 'cms-ttmn-grid-item'
            ]);
            break;
        
        default:
            $widget->add_render_attribute('ttmn-item', [
                'class' => 'cms-carousel-item swiper-slide'
            ]);
    ?>
        <div class="cms-carousel swiper col-7 col-tablet-9 col-mobile-extra-12">
            <div class="swiper-wrapper">
    <?php
            break;
    } ?>
            <?php foreach ($testimonials as $key => $testimonial) {
            ?>
                <div <?php etc_print_html($widget->get_render_attribute_string('ttmn-item')); ?>>
                    <div class="cms-ttmn-content">
                        <div <?php etc_print_html($widget->get_render_attribute_string('description')); ?>><?php 
                            etc_print_html($testimonial['description']); 
                        ?></div>
                        <div class="cms-ttmn-info pt-100 pt-tablet-50 d-flex align-items-center gap-30 flex-nowrap align-items-end">
                            <?php
                                finanzia_elementor_image_render($testimonial,[
                                    'name'           => 'image',
                                    'image_size_key' => 'image',
                                    'img_class'      => 'cms-ttmn--img max-w cms-radius-5',
                                    'size'           => 'custom',
                                    'custom_size'    => ['width' => 90, 'height' => 120],
                                    'attrs'          => ['style' => '--max-w:90px;'],
                                    'before'         => '<div class="cms-ttmn-img relative flex-auto">',
                                    'after'          => $quote_icon.'</div>'
                                ]);
                            ?>
                            <div class="cms-ttmn-name flex-basic">
                                <div <?php etc_print_html($widget->get_render_attribute_string('ttmn-author')); ?>><?php echo esc_html($testimonial['name']); ?></div>
                                <div <?php etc_print_html($widget->get_render_attribute_string('ttmn-author-pos')); ?>><?php echo esc_html($testimonial['position']); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
    <?php switch ($layout_mode) {
        case 'grid':
            // code...
            break;
        default:
            // code...
    ?>
            </div>
        </div>
        <div class="cms-swiper-buttons-dots d-flex gap-20 align-items-end justify-content-between empty-none col-5 col-tablet-3 col-mobile-extra-12 order-first order-mobile-extra-last"><?php
            // Arrows
            if ($arrows == 'yes'){ ?>
                <div <?php etc_print_html($widget->get_render_attribute_string('arrows')); ?>><?php 
                    finanzia_elementor_icon_render(
                        [], 
                        [
                            'library' => 'svg',
                            'value'   => [
                                'id'  => '',
                                'url' => get_template_directory().'/assets/svgs/core/arrow-left.svg'
                            ]
                        ], 
                        [
                            'class'     => $arrows_classes_prev,
                            'icon_size' => 19
                        ], 
                        'div'
                    );
                    finanzia_elementor_icon_render(
                        [], 
                        [
                            'library' => 'svg',
                            'value'   => [
                                'id'  => '',
                                'url' => get_template_directory().'/assets/svgs/core/arrow-right.svg'
                            ]
                        ], 
                        [
                            'class'     => $arrows_classes_next,
                            'icon_size' => 19
                        ], 
                        'div'
                    );
                ?></div>
            <?php }
            // Dots
            if ($dots == 'yes') { ?>
                <div <?php etc_print_html($widget->get_render_attribute_string('dots')); ?>></div>
            <?php } 
        ?></div>
    <?php
            break;
    } ?>
</div>
