<?php 
$cms_tabs = $widget->get_setting('cms_tabs2', []);
$tabs = $widget->get_setting('tabs', []);
$active_tab = $settings['active_tab'];
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => [
		'cms-tabs',
		'cms-tabs-'.$settings['layout']
	]
]);
// Tab Title icon
$title_icon_classes = finanzia_nice_class([ 
	'tab-title-icon pb-70 pb-tablet-40 pb-mobile-extra-0',
	'text-'.$widget->get_setting('tab_title_color', 'body'),
	'text-hover-'.$widget->get_setting('tab_title_color_hover', 'body'),
	'text-active-'.$widget->get_setting('tab_title_color_hover', 'body')
]);
// Tab Title text
$widget->add_render_attribute('tab-title-text',[
	'class' => [
		'tab-title-text',
		'text-15',
		'm-tb-n7',
		'max-w'
	],
	'style' => [
		'--max-w:270px;'
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div class="cms-tabs-title d-flex flex-col-3 flex-col-mobile-extra-1 relative z-top">
		<?php 
		$count = 0;
		foreach ($cms_tabs as $key => $cms_tab) {
			$count ++;
			$is_active = ( $key + 1 ) === $active_tab ? true : false;
			$title = !empty($cms_tab['tab_title']) ? $cms_tab['tab_title'] : 'Tab #'.($key+1);
			// title
			$title_key = $widget->get_repeater_setting_key( 'tab_title', 'cms_tabs', $key );
			$widget->add_render_attribute( $title_key, [
				'class' => array_filter([ 
					'cms-tab-title',
					'text-'.$widget->get_setting('tab_title_color', 'body'),
					'text-hover-'.$widget->get_setting('tab_title_color_hover', 'body'),
					'text-active-'.$widget->get_setting('tab_title_color_hover', 'body'),
					'bg-'.$widget->get_setting('tab_title_bg_color', 'white'),
					'bg-hover-'.$widget->get_setting('tab_title_bg_color_hover', 'white'),
					'bg-active-'.$widget->get_setting('tab_title_bg_color_hover', 'white'),
					$is_active ? 'active' : '',
					'text-15',
					'relative',
					'cms-hover-change',
					($key == 0) ? 'pr-70 pr-tablet-20' : 'p-lr-70 p-lr-tablet-20',
					'p-lr-mobile-20',
					'cms-hover-change'
				]),
				'data-target' => '#cms-'.$cms_tab['_id'],
				'data-active' => $is_active?'active':''
			]);
		?>
			<div <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>>
				<div class="cms-tab-title--title bg-white relative z-top p-tb-50 p-tb-smobile-20 d-mobile-extra-flex align-items-center gap-20">
					<?php
					// Icon
					finanzia_elementor_icon_render( $cms_tab['tab_title_icon'], [], ['aria-hidden' => 'true', 'class' => $title_icon_classes, 'icon_size' => 64], 'div');
					?>
					<div <?php etc_print_html($widget->get_render_attribute_string('tab-title-text')); ?>><?php 
						// text
						echo nl2br($title);
					?></div>	
				</div>
				<div class="cms-tab-title-content p-40 p-tablet-0 pb-tablet-40 bg-white cms-hover-show move-down w-100 cms-transition mt-1">
					<div class="cms-tab-title--content">
						<?php 
							// Feature
							$tab_content_features = json_decode($cms_tab['tab_content_feature'], true);
							$count = 0;
							foreach ($tab_content_features as $key => $tab_content_feature) {
								$count ++;
						?>
							<div class="cms-tab--feature d-flex flex-nowrap gap-30 gap-tablet-10 align-items-center text-15 <?php if($count>1) echo 'pt-25'; ?>"><?php
								//icon
								finanzia_svgs_icon([
									'icon' => 'core/check',
									'class' => 'text-green text-12 flex-auto'
								]);
								//text
								echo nl2br($tab_content_feature['title']);
							?></div>
						<?php } ?>
					</div>
				</div>	
			</div>
			
		<?php } ?>
	</div>
	<div class="cms-tabs-contents relative cms-hidden-tablet"><?php 
		// Tabs Content
		foreach ($cms_tabs as $content_key => $cms_tab) {
			$is_active = ( $content_key + 1 ) === $active_tab ? true : false;
			$content_key_attrs = $widget->get_repeater_setting_key( 'tab_content', 'cms_tabs', $content_key );
			$widget->add_render_attribute( $content_key_attrs, [
				'id'	=> 'cms-'.$cms_tab['_id'],
				'class' => array_filter([
					'cms-tabs-content',
					'top-left',
					'cms-transition',
					'w-100',
					$is_active ? 'active relative' : 'absolute cms-invisible'
				]),
				'data-active' => $is_active ? 'active' : 'invisible'
			] );
		?>
		<?php // Tab Content ?>
		<div <?php etc_print_html( $widget->get_render_attribute_string( $content_key_attrs ) ); ?>>
			<?php 
				// Banner 
				finanzia_elementor_image_render($cms_tab, [
					'name'           => 'tab_content_banner',
					'image_size_key' => 'tab_content_banner',
					'size'           => 'custom',
					'custom_size'    => ['width' => 1500, 'height' => 800],
					'img_class'		 => 'img-cover',
					'max_height'	 => true,
					'min_height'	 => false,		
					'after'  		 => '',
				]);
			?>
		</div>
		<?php } 
	?></div>
</div>