<?php
// Enquere default css
wp_enqueue_style('e-animation-fadeInLeft');
wp_enqueue_style('e-animation-fadeInRight');
wp_enqueue_style('e-animation-fadeInUp');
//
$cms_slides = $widget->get_setting('cms_slides', []);
$arrows     = $widget->get_setting('arrows','');
$dots       = $widget->get_setting('dots','');
$autoplay_speed = $widget->get_setting('autoplay_speed',5000) - 500;

// Arrow
$widget->add_render_attribute('arrows', [
    'class' => [
        'cms-slider-arrows d-flex gap-50 absolute bottom-left ml-container mb-110 mb-tablet-40 mb-smobile-20',
        finanzia_add_hidden_device_controls_render($settings, 'arrows_')
    ]
]);
// Dots
$dots_type = $widget->get_setting('dots_type', 'bullets');
$widget->add_render_attribute('dots', [
    'class' => [
        'cms-carousel-dots',
        'cms-carousel-dots-'.$settings['dots_type'],
        'justify-content-center',
        finanzia_add_hidden_device_controls_render($settings, 'dots_'),
        'absolute bottom z-top',
        'mb-40'
    ],
    'style' => [
        '--cms-dots-color:var(--cms-white-70);',
        '--cms-dots-hover-color:var(--cms-white);'
    ]
]);
switch ($dots_type) {
    case 'bullets':
        $dot_gap = 10;
        break;
    case 'custom':
        $dot_gap = '40 gap-tablet-20';
        break;
    default:
        $dot_gap = 0;
        break;
}
$widget->add_render_attribute('dots', [
    'class' => 'gap-'.$dot_gap
]);
// Wrapper
$widget->add_render_attribute('wrap', [
    'class' => [
        'cms-eslider',
        'cms-eslider-'.$settings['layout'],
        'cms-carousel', 'swiper'
    ]
]);
// Container
$widget->add_render_attribute('container', [
    'class' => [
        'container',
        'd-flex gap-40',
        'justify-content-between',
        'align-items-end'
    ]
]);
// Subtitle
$widget->add_render_attribute('subtitle', [
    'class' => [
        'cms-slider-subtitle text-line-3 mt-n8 mb-25 empty-none',
        'text-17 font-700',
        'text-'.$widget->get_setting('subtitle_color', 'white'),
        finanzia_add_hidden_device_controls_render($settings, 'subtitle_')
    ],
    'data-cms-animation'       => 'subtitle_animation',
    'data-cms-animation-delay' => 'subtitle_animation_delay'
]);
// Title 
$widget->add_render_attribute('title', [
    'class' => [
        'cms-slider-title heading mt-n15 empty-none cms-nl2br',
        'text-size lh-104',
        'text-'.$widget->get_setting('title_color','white'),
        finanzia_add_hidden_device_controls_render($settings, 'title_')
    ],
    'style' => '--text-size:85px;--text-size-tablet:60px;--text-size-mobile:40px;--text-size-smobile:30px;',
    'data-cms-animation'       => 'title_animation',
    'data-cms-animation-delay' => 'title_animation_delay'
]);
// Description
$widget->add_render_attribute('desc', [
    'class' =>  [
        'cms-slider-desc empty-none cms-nl2br',
        'text-17 font-700 lh-147',
        'text-'.$widget->get_setting('desc_color', 'white'),
        finanzia_add_hidden_device_controls_render($settings, 'desc_'),
        'pt-25 m-tb-n7'
    ],
    'data-cms-animation'       => 'description_animation',
    'data-cms-animation-delay' => 'description_animation_delay'
]);
if($default_align === 'center'){
    $widget->add_render_attribute('desc', [ 
        'class' => 'm-lr-auto'
    ]);
}
// Buttons
$widget->add_render_attribute('buttons', [
    'class' => [
        'cms-slider-buttons d-flex gap-30',
        'justify-content-'.$default_align,
        'pt-40',
        'empty-none'
    ]
]);
// Static Content
$widget->add_render_attribute('static-content',[
    'class' => [
        'static-content',
        'flex-auto max-w text-end text-tablet-start',
        'elementor-invisible'
    ],
    'data-settings' => json_encode([
        'animation' => 'fadeInRight',
        'animation_delay' => 500
    ]),
    'style' => '--max-w:220px;'
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')) ?>>
    <div class="swiper-wrapper">
        <?php foreach ($cms_slides as $key => $cms_slide) { ?>
            <div class="cms-slider-item swiper-slide relative cms-gradient-render cms-gradient-<?php echo esc_attr($settings['overlay_style']) ?>">
                <?php 
                    $cms_slide['lazy']       = false;
                    $cms_slide['image_size'] = 'full';
                    // image
                    finanzia_elementor_image_render($cms_slide, [
                        'img_class' => 'cms-slider-img cms-slider-img-effect img-cover',
                        'duration'  => $autoplay_speed
                    ]);
                ?>
                <div class="cms-slider-content cms-overlay d-flex align-items-end pb" style="--pb:110px;--pb-tablet:40px;">
                    <div <?php etc_print_html($widget->get_render_attribute_string('container')); ?>>
                        <div class="cms-slider--content flex-basic">
                            <div <?php etc_print_html($widget->get_render_attribute_string('subtitle')); ?>><?php echo etc_print_html($cms_slide['subtitle']); ?></div>
                            <h2 <?php etc_print_html($widget->get_render_attribute_string('title')); ?>><?php echo nl2br($cms_slide['title']); ?></h2>
                            <div class="pl-110 pl-tablet-0">
                                <div <?php etc_print_html($widget->get_render_attribute_string('desc')); ?>><?php echo nl2br($cms_slide['description']); ?></div>
                                <div <?php etc_print_html($widget->get_render_attribute_string('buttons')); ?>><?php
                                    // Button Primary
                                    if ( ! empty( $cms_slide['button_primary'] ) ) :
                                        switch ($cms_slide['button_primary_type']) {
                                            case 'page':
                                                $button_primary_url = !empty($cms_slide['button_primary_page_link']) ? get_permalink($cms_slide['button_primary_page_link']) : '#';
                                                break;
                                            default:
                                                $button_primary_url = $cms_slide['button_primary_link']['url'];
                                                break;
                                        }
                                ?>
                                    <a href="<?php echo esc_attr($button_primary_url); ?>" class="cms-slider-btn btn btn-white text-accent btn-hover-grey text-hover-accent cms-hover-move-icon-right <?php echo finanzia_add_hidden_device_controls_render($settings, 'btn1_'); ?>" data-cms-animation="button_primary_animation" data-cms-animation-delay="button_primary_animation_delay">
                                        <?php 
                                            // text
                                            echo etc_print_html( $cms_slide['button_primary'] ); 
                                            // icon
                                            finanzia_svgs_icon([
                                                'icon'  => 'core/long-arrow-right',
                                                'class' => 'text-17'
                                            ]);
                                        ?>
                                    </a>
                                <?php endif;
                                    // Button Secondary
                                    if ( ! empty( $cms_slide['button_secondary'] ) ) :
                                        switch ($cms_slide['button_secondary_type']) {
                                            case 'page':
                                                $button_secondary_url = !empty($cms_slide['button_secondary_page_link']) ? get_permalink($cms_slide['button_secondary_page_link']) : '#';
                                                break;
                                            default:
                                                $button_secondary_url = $cms_slide['button_secondary_link']['url'];
                                                break;
                                        }
                                ?>
                                    <a href="<?php echo esc_url($button_secondary_url); ?>" class="cms-slider-btn btn btn-outline-white text-white btn-hover-white text-hover-primary <?php echo finanzia_add_hidden_device_controls_render($settings, 'btn2_'); ?>" data-cms-animation="button_secondary_animation" data-cms-animation-delay="button_secondary_animation_delay">
                                        <?php echo etc_print_html( $cms_slide['button_secondary'] ); ?>
                                    </a>
                                <?php endif; 
                                    // Video button
                                    finanzia_elementor_button_video_render($widget, $cms_slide, [
                                        '_id'        => $cms_slide['_id'],   
                                        'name'       => 'video_link',
                                        'icon_class' => 'cms-transition',
                                        'text'       => $cms_slide['video_text'],
                                        'layout'     => '1 btn btn-accent text-white btn-hover-outline-white text-hover-white gap-10',
                                        'class'      => finanzia_add_hidden_device_controls_render($settings, 'btn_video_'),
                                        'echo'       => true,
                                        'loop'       => true,
                                        'loop_key'   => $key, 
                                        'attrs'      => [
                                            'data-cms-animation'       => 'button_video_animation',
                                            'data-cms-animation-delay' => 'button_video_animation_delay'
                                        ]
                                    ]);
                                ?></div>
                            </div>
                        </div>
                        <div <?php etc_print_html($widget->get_render_attribute_string('static-content')); ?>>
                            <?php 
                                finanzia_elementor_icon_image_render($widget, $settings, [
                                    'name'        => 'static_icon',
                                    'size'        => 32,
                                    'color'       => 'primary-lighten',
                                    'color_hover' => 'white' 
                                ]);
                            ?>
                            <div class="text-primary-lighten pt-20 mb-n7"><?php echo nl2br($settings['static_title']); ?></div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        }
        ?>
    </div>
    <?php
    // Arrows
    if ($arrows == 'yes'){
    ?>
    <?php 
        finanzia_svgs_icon([
            'icon'  => 'core/arrow-prev',
            'class' => 'cms-carousel-button-prev text-27 text-white text-hover-white cms-opacity-05 cms-hover-opacity-1 absolute center-left ml '.finanzia_add_hidden_device_controls_render($settings, 'arrows_'),
            'tag'   => 'div',
            'attrs' => [
                'style' => '--ml:50px;--ml-tablet-extra:30px;--ml-tablet:10px;'
            ]
        ]);
        finanzia_svgs_icon([
            'icon'  => 'core/arrow-next',
            'class' => 'cms-carousel-button-next text-27 text-white text-hover-white cms-opacity-05 cms-hover-opacity-1 absolute center-right mr '.finanzia_add_hidden_device_controls_render($settings, 'arrows_'),
            'tag'   => 'div',
            'attrs' => [
                'style' => '--mr:50px;--mr-tablet-extra:30px;--mr-tablet:10px;'
            ]
        ]);
    ?>
    <?php }
    // Dots
    if ($dots == 'yes') { ?>
        <div <?php etc_print_html($widget->get_render_attribute_string('dots')); ?>><?php 
            if($settings['dots_type'] == 'custom'){
                foreach ($cms_slides as $key => $dot){
            ?>
                <div class="dots-custom">
                    <div class="text-13 bdr-b-1 brd-divider pb-5"><?php finanzia_leading_zero($key+1); ?>.</div>
                    <div class="font-700 pt-15"><?php echo etc_print_html($cms_slide['subtitle']); ?></div>
                </div>
            <?php
                }
            }
        ?></div>
    <?php } ?>
</div>