<?php
// Enquere default css
wp_enqueue_style('e-animation-fadeInLeft');
wp_enqueue_style('e-animation-fadeInRight');
wp_enqueue_style('e-animation-fadeInUp');
//
$default_align = 'start';
$cms_slides = $widget->get_setting('cms_slides', []);
$arrows     = $widget->get_setting('arrows','');
$dots       = $widget->get_setting('dots','');
$autoplay_speed = $widget->get_setting('autoplay_speed',5000) - 500;

// Arrow
$widget->add_render_attribute('arrows', [
    'class' => [
        'cms-slider-arrows d-flex gap-50 absolute bottom-left ml-container mb-110 mb-tablet-40 mb-smobile-20',
        finanzia_add_hidden_device_controls_render($settings, 'arrows_')
    ]
]);
// Dots
$dots_type = $widget->get_setting('dots_type', 'bullets');
$widget->add_render_attribute('dots', [
    'class' => [
        'cms-carousel-dots z-top',
        'cms-carousel-dots-'.$settings['dots_type'],
        finanzia_add_hidden_device_controls_render($settings, 'dots_'),
        'max-w',
        'pl-container',
        'absolute bottom-left',
        'mb'
    ],
    'style' => [
        '--cms-dots-color:var(--cms-white-70);',
        '--cms-dots-hover-color:var(--cms-white);',
        '--max-w:calc(100% - 600px);',
        '--max-w-mobile:100%;',
        '--mb:127px;--mb-tablet-extra:50px;--mb-mobile:10px;'
    ]
]);
switch ($dots_type) {
    case 'bullets':
        $dot_gap = 10;
        break;
    case 'custom':
        $dot_gap = '40 gap-tablet-20';
        break;
    default:
        $dot_gap = 0;
        break;
}
$widget->add_render_attribute('dots', [
    'class' => 'gap-'.$dot_gap
]);
// Wrapper
$widget->add_render_attribute('wrap', [
    'class' => [
        'cms-eslider',
        'cms-eslider-'.$settings['layout'],
        'cms-carousel', 'swiper'
    ]
]);
// Container
$widget->add_render_attribute('container', [
    'class' => [
        'container',
        'd-flex',
        'justify-content-'.$default_align,
        'text-'.$default_align,
        'text-white'
    ]
]);
// Subtitle
$widget->add_render_attribute('subtitle', [
    'class' => [
        'cms-slider-subtitle text-line-3 empty-none cms-nl2br',
        'text-17 font-700',
        'text-'.$widget->get_setting('subtitle_color', 'white'),
        finanzia_add_hidden_device_controls_render($settings, 'subtitle_'),
        'm-tb-n7 mb-25'
    ],
    'data-cms-animation'       => 'subtitle_animation',
    'data-cms-animation-delay' => 'subtitle_animation_delay'
]);
// Title 
$widget->add_render_attribute('title', [
    'class' => [
        'cms-slider-title heading empty-none cms-nl2br',
        'text-26 text-mobile-20 lh',
        'text-'.$widget->get_setting('title_color','white'),
        finanzia_add_hidden_device_controls_render($settings, 'title_'),
        'mt-n10'
    ],
    'data-cms-animation'       => 'title_animation',
    'data-cms-animation-delay' => 'title_animation_delay',
    'style' => '--lh:1.308;'
]);
// Description
$widget->add_render_attribute('desc', [
    'class' =>  [
        'cms-slider-desc empty-none cms-nl2br',
        'text-17 lh',
        'text-'.$widget->get_setting('desc_color', 'grey'),
        finanzia_add_hidden_device_controls_render($settings, 'desc_'),
        'pt-33 m-tb-n7'
    ],
    'data-cms-animation'       => 'description_animation',
    'data-cms-animation-delay' => 'description_animation_delay',
    'style'                    => '--lh:1.588235294117647;'
]);
// Buttons
$widget->add_render_attribute('buttons', [
    'class' => [
        'cms-slider-buttons d-flex gap-30',
        'justify-content-'.$default_align,
        'pt-40',
        'empty-none'
    ]
]);
// Count 
$widget->add_render_attribute('count', [
    'class' => [
        'count m-tb-n7 pb-40 text-white'
    ],
    'data-cms-animation'       => 'title_animation',
    'data-cms-animation-delay' => 'title_animation_delay'
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')) ?>>
    <div class="swiper-wrapper">
        <?php foreach ($cms_slides as $key => $cms_slide) { ?>
            <div class="cms-slider-item swiper-slide relative cms-gradient-render cms-gradient-<?php echo esc_attr($settings['overlay_style']) ?> mb-50 mb-mobile-0">
                <?php 
                    $cms_slide['lazy']       = false;
                    $cms_slide['image_size'] = 'full';
                    // image
                    finanzia_elementor_image_render($cms_slide, [
                        'img_class' => 'cms-slider-img cms-slider-img-effect img-cover',
                        'duration'  => $autoplay_speed
                    ]);
                ?>
                <div class="cms-slider-content absolute bottom-right mb mr cms-backdrop-1 p-70 p-tablet-extra-40 p-lr-tablet-20 max-w overflow-hidden" style="--mb:-50px;--mb-mobile:120px;--mr:50px;--mr-tablet-extra:20px;--mr-mobile:0;--max-w:550px;">
                    <div <?php etc_print_html($widget->get_render_attribute_string('count')); ?>><?php finanzia_leading_zero($key+1); ?>.</div>
                    <?php if($dots_type!='custom'){ ?>
                    <div <?php etc_print_html($widget->get_render_attribute_string('subtitle')); ?>><?php echo etc_print_html($cms_slide['subtitle']); ?></div>
                    <?php } ?>
                    <h2 <?php etc_print_html($widget->get_render_attribute_string('title')); ?>><?php echo nl2br($cms_slide['title']); ?></h2>
                    <div <?php etc_print_html($widget->get_render_attribute_string('desc')); ?>><?php echo nl2br($cms_slide['description']); ?></div>
                    <?php 
                        // Icon
                        finanzia_elementor_icon_image_render($widget, $settings,[
                            'size'        => 64,
                            'color'       => 'white',
                            'color_hover' => 'white',
                            // icon
                            'icon_tag'    => 'div',
                            'icon_default' => [],
                            // default
                            'class'      => 'pt-40',
                            'before'     => '',
                            'after'      => '',
                            'echo'       => true,
                            'attrs'      => [
                                'data-cms-animation'       => 'description_animation',
                                'data-cms-animation-delay' => 'description_animation_delay'
                            ]
                        ], $cms_slide);
                    ?>
                    <div <?php etc_print_html($widget->get_render_attribute_string('buttons')); ?>><?php
                        // Button Primary
                        if ( ! empty( $cms_slide['button_primary'] ) ) :
                            switch ($cms_slide['button_primary_type']) {
                                case 'page':
                                    $button_primary_url = !empty($cms_slide['button_primary_page_link']) ? get_permalink($cms_slide['button_primary_page_link']) : '#';
                                    break;
                                default:
                                    $button_primary_url = $cms_slide['button_primary_link']['url'];
                                    break;
                            }
                    ?>
                        <a href="<?php echo esc_attr($button_primary_url); ?>" class="cms-slider-btn btn btn-white text-primary btn-hover-accent text-hover-white cms-hover-move-icon-right <?php echo finanzia_add_hidden_device_controls_render($settings, 'btn1_'); ?>" data-cms-animation="button_primary_animation" data-cms-animation-delay="button_primary_animation_delay">
                            <?php 
                                // text
                                echo etc_print_html( $cms_slide['button_primary'] ); 
                                // icon
                                finanzia_svgs_icon([
                                    'icon'  => 'core/long-arrow-right',
                                    'class' => 'text-17'
                                ]);
                            ?>
                        </a>
                    <?php endif;
                        // Button Secondary
                        if ( ! empty( $cms_slide['button_secondary'] ) ) :
                            switch ($cms_slide['button_secondary_type']) {
                                case 'page':
                                    $button_secondary_url = !empty($cms_slide['button_secondary_page_link']) ? get_permalink($cms_slide['button_secondary_page_link']) : '#';
                                    break;
                                default:
                                    $button_secondary_url = $cms_slide['button_secondary_link']['url'];
                                    break;
                            }
                    ?>
                        <a href="<?php echo esc_url($button_secondary_url); ?>" class="cms-slider-btn btn btn-outline-white text-white btn-hover-white text-hover-primary <?php echo finanzia_add_hidden_device_controls_render($settings, 'btn2_'); ?>" data-cms-animation="button_secondary_animation" data-cms-animation-delay="button_secondary_animation_delay">
                            <?php echo etc_print_html( $cms_slide['button_secondary'] ); ?>
                        </a>
                    <?php endif; 
                        // Video button
                        finanzia_elementor_button_video_render($widget, $cms_slide, [
                            '_id'        => $cms_slide['_id'],   
                            'name'       => 'video_link',
                            'icon_class' => 'cms-transition',
                            'text'       => $cms_slide['video_text'],
                            'layout'     => '1 btn btn-accent text-white btn-hover-outline-white text-hover-white gap-10',
                            'class'      => finanzia_add_hidden_device_controls_render($settings, 'btn_video_'),
                            'echo'       => true,
                            'loop'       => true,
                            'loop_key'   => $key, 
                            'attrs'      => [
                                'data-cms-animation'       => 'button_video_animation',
                                'data-cms-animation-delay' => 'button_video_animation_delay'
                            ]
                        ]);
                    ?></div>
                </div>
            </div>
            <?php
        }
        ?>
    </div>
    <?php
    // Arrows
    if ($arrows == 'yes'){
    ?>
    <?php 
        finanzia_svgs_icon([
            'icon'  => 'core/arrow-prev',
            'class' => 'cms-carousel-button-prev text-27 text-white text-hover-white cms-opacity-05 cms-hover-opacity-1 absolute center-left ml '.finanzia_add_hidden_device_controls_render($settings, 'arrows_'),
            'tag'   => 'div',
            'attrs' => [
                'style' => '--ml:50px;--ml-tablet-extra:30px;--ml-tablet:10px;'
            ]
        ]);
        finanzia_svgs_icon([
            'icon'  => 'core/arrow-next',
            'class' => 'cms-carousel-button-next text-27 text-white text-hover-white cms-opacity-05 cms-hover-opacity-1 absolute center-right mr '.finanzia_add_hidden_device_controls_render($settings, 'arrows_'),
            'tag'   => 'div',
            'attrs' => [
                'style' => '--mr:50px;--mr-tablet-extra:30px;--mr-tablet:10px;'
            ]
        ]);
    ?>
    <?php }
    // Dots
    if ($dots == 'yes') { ?>
        <div <?php etc_print_html($widget->get_render_attribute_string('dots')); ?>><?php 
            if($settings['dots_type'] == 'custom'){
                foreach ($cms_slides as $key => $dot){
            ?>
                <div class="dots-custom">
                    <div class="text-13 bdr-b-1 brd-divider-70 pb-5"><?php finanzia_leading_zero($key+1); ?>.</div>
                    <div class="font-700 pt-15 text-line-1"><?php echo etc_print_html($dot['subtitle']); ?></div>
                </div>
            <?php
                }
            }
        ?></div>
    <?php } ?>
</div>