<?php
	// Wrap 
	$widget->add_render_attribute('wrap',[
		'class' => [
			'cms-eqc',
			'cms-eqc-'.$settings['layout'],
			finanzia_elementor_get_alignment_class($widget, $settings, ['name' => 'align'])
		]
	]);
	// Title
	$widget->add_inline_editing_attributes( 'title', 'Quick Contact' );
	$widget->add_render_attribute( 'title', [
		'class' => [
			'cms-title',
			'cms-heading',
			'text-'.$widget->get_setting('title_color','heading'),
			'text-19 pb-20 mt-n7'
		]
	]);
	// Email
		$icon_email_color = $widget->get_setting('icon_email_color', 'accent');
		$email_color = $widget->get_setting('email_color', 'accent');
		$email_color_hover = $widget->get_setting('email_color_hover', 'accent');
		$widget->add_render_attribute( 'email-item', [
			'class' => [
				'cms-eqc-item',
				'd-flex align-items-center gap-10',
				finanzia_elementor_get_alignment_class($widget, $settings, ['name' => 'align','prefix_class' => 'justify-content-']),
				'cms-email',
				'text-'.$email_color,
				'text-hover-'.$email_color_hover
			],
			'href'   => 'mailto:'.$settings['email'],
			'target' => '_blank'
		]);
		// email icon
		$widget->add_render_attribute( 'email-icon', [
			'class' => [
				'cms-icon',
				'cms-icon-color',
				'text-'.$icon_email_color,
				'cmsi-email',
				'text-16'
			]
		]);
		// email title
		$widget->add_inline_editing_attributes( 'email_title' );
		$widget->add_render_attribute( 'email_title', [
			'class' => [
				'cms-email-title empty-none',
				'cms-icon-color',
				'text-'.$icon_email_color,
				finanzia_add_hidden_device_controls_render($settings, 'title_')
			]
		]);
		// email
		$widget->add_inline_editing_attributes( 'email' );
		$widget->add_render_attribute( 'email', [
			'class' => [
				'cms-email-text',
				'cms-hover-underline'
				//finanzia_add_hidden_device_controls_render($settings, 'title_')
			]
		]);
	// Phone
	$icon_phone_color = $widget->get_setting('icon_phone_color', 'accent');
	$phone_color = $widget->get_setting('phone_color', 'accent');
	$phone_color_hover = $widget->get_setting('phone_color_hover', 'accent');
	$phone_link  = str_replace(' ', '', $settings['phone']);
	$widget->add_render_attribute( 'phone-item',[ 
		'class' => [
			'cms-eqc-item',
			'd-flex align-items-center gap-10',
			finanzia_elementor_get_alignment_class($widget, $settings, ['name' => 'align','prefix_class' => 'justify-content-']),
			'cms-phone',
			'text-'.$phone_color,
			'text-hover-'.$phone_color_hover
		],
		'href' => 'tel:'.$phone_link
	]);
		// phone icon
		$widget->add_render_attribute( 'phone-icon', [
			'class' => [
				'cms-icon',
				'cms-icon-color',
				'text-'.$icon_phone_color,
				'cmsi-phone-alt'
			]
		]);
		// phone title
		$widget->add_inline_editing_attributes('phone_title');
		$widget->add_render_attribute( 'phone_title',[ 
			'class' => [
				'cms-phone-title empty-none',
				'cms-icon-color',
				'text-'.$icon_phone_color,
				finanzia_add_hidden_device_controls_render($settings, 'title_')
			]
		]);
		// phone number
		$widget->add_inline_editing_attributes('phone');
		$widget->add_render_attribute( 'phone',[ 
			'class' => [
				'cms-phone-text',
				'cms-hover-underline'
				//finanzia_add_hidden_device_controls_render($settings, 'title_')
			]
		]);
	// Time
		$icon_time_color = $widget->get_setting('icon_time_color', 'accent');
		$time_color = $widget->get_setting('time_color', 'body');
		$time_color_hover = $widget->get_setting('time_color_hover', 'accent');
		$widget->add_render_attribute( 'time-item', [
			'class' => [
				'cms-eqc-item',
				finanzia_elementor_get_alignment_class($widget, $settings, ['name' => 'align','prefix_class' => 'justify-content-']),
				'cms-time',
				'text-'.$time_color,
				'text-hover-'.$time_color_hover,
				'text-15',
				'pt-40'
			]
		]);
		// time icon
		$widget->add_render_attribute( 'time-icon', [
			'class' => [
				'cms-icon',
				'cms-icon-color',
				'text-'.$icon_time_color
			]
		]);
		// time title
		$widget->add_inline_editing_attributes( 'time_title' );
		$widget->add_render_attribute( 'time_title', [
			'class' => [
				'cms-time-title',
				'cms-heading',
				'cms-icon-color',
				'text-'.$icon_time_color,
				finanzia_add_hidden_device_controls_render($settings, 'title_'),
				'text-19 pb-20'
			]
		]);
		// time
		$widget->add_inline_editing_attributes( 'time' );
		$widget->add_render_attribute( 'time', [
			'class' => [
				'cms-time-text',
				//finanzia_add_hidden_device_controls_render($settings, 'title_')
			]
		]);
	// Adress
		$icon_address_color = $widget->get_setting('icon_address_color', 'heading');
		$address_color = $widget->get_setting('address_color', 'body');
		$address_color_hover = $widget->get_setting('address_color_hover', 'accent');

		$address     = $settings['address'];
		$map_zoom    = 14;
		$map_api_key = finanzia_get_opt('gm_api_key');
		$map_params  = [
		    rawurlencode( $address ),
		    absint( $map_zoom )
		];
		$map_url = 'https://maps.google.com/maps?q=%1$s&amp;t=m&amp;z=%2$d&amp;iwloc=near';
		
		$widget->add_render_attribute( 'address-item', [
			'class' => [
				'cms-eqc-item',
				finanzia_elementor_get_alignment_class($widget, $settings, ['name' => 'align','prefix_class' => 'justify-content-']),
				'cms-address',
				'text-'.$address_color,
				'text-hover-'.$address_color_hover,
				'd-block pt-40'
			],
			'href'   => vsprintf( $map_url, $map_params ),
			'target' => '_blank'
		]);
		// address icon
		$widget->add_render_attribute( 'address-icon', [
			'class' => [
				'cms-icon',
				'cms-icon-color',
				'text-'.$icon_address_color,
				'cmsi-map-marker',
				'text-16'
			]
		]);
		// address title
		$widget->add_inline_editing_attributes( 'address_title' );
		$widget->add_render_attribute( 'address_title', [
			'class' => [
				'cms-address-title empty-none',
				'cms-heading',
				'cms-icon-color',
				'text-'.$icon_address_color,
				finanzia_add_hidden_device_controls_render($settings, 'title_'),
				'text-19 pb-20'
			]
		]);
		// address
		$widget->add_inline_editing_attributes( 'address' );
		$widget->add_render_attribute( 'address', [
			'class' => [
				'cms-address-text',
				'text-15',
				'cms-nl2br',
				'cms-hover-underline'
				//finanzia_add_hidden_device_controls_render($settings, 'title_')
			]
		]);
	// Socials
	$icons = $widget->get_setting('icons', []);
	$hover_animation = $widget->get_setting('hover_animation', '');
	$class_animation = '';
	if(!empty($hover_animation)){
		$class_animation = 'elementor-animation-' . $hover_animation;
	}
	//Icons wrap
	$widget->add_render_attribute('icon-wrap', [
		'class' => [
			'cms-social-icons',
			'cms-social-icons-'.$settings['layout'],
			'd-flex align-items-center',
			'gap-'.$widget->get_setting('gap',15),
			'text-13',
			finanzia_elementor_get_alignment_class($widget, $settings, [
				'name' 		   => 'align',
				'prefix_class' => 'justify-content-'
			])
		]
	]);
	// Social title
		$widget->add_inline_editing_attributes( 'social_title' );
		$widget->add_render_attribute( 'social_title', [
			'class' => [
				'cms-social-title',
				'cms-heading',
				'text-'.$icon_time_color,
				finanzia_add_hidden_device_controls_render($settings, 'title_'),
				'text-19 pb-20 pt-40'
			]
		]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php if (!empty($widget->get_setting('title'))) { ?>
		<div <?php etc_print_html( $widget->get_render_attribute_string( 'title' ) ); ?>><?php 
			echo etc_print_html( $widget->get_setting('title') ); 
		?></div>
	<?php } 
	// Email
	if(!empty($settings['email'])){
	?>
	<a <?php etc_print_html( $widget->get_render_attribute_string( 'email-item' ) ); ?>>
		<span <?php etc_print_html($widget->get_render_attribute_string('email_title')); ?>><?php echo esc_html($settings['email_title']); ?></span>
		<span <?php etc_print_html($widget->get_render_attribute_string('email')); ?>><?php echo esc_html($settings['email']); ?></span>
	</a>
	<?php }
	// Phone
	if(!empty($settings['phone'])) { ?>
		<a <?php etc_print_html( $widget->get_render_attribute_string( 'phone-item' ) ); ?>>
			<span <?php etc_print_html($widget->get_render_attribute_string('phone_title')); ?>><?php echo esc_html($settings['phone_title']); ?></span>
			<span <?php etc_print_html($widget->get_render_attribute_string('phone')); ?>><?php echo esc_html($settings['phone']); ?></span>
		</a>
	<?php }
	// Address
	if(!empty($address)) { ?>
		<a <?php etc_print_html( $widget->get_render_attribute_string( 'address-item' ) ); ?>>
			<div <?php etc_print_html($widget->get_render_attribute_string('address_title')); ?>><?php echo esc_html($settings['address_title']); ?></div>
			<span <?php etc_print_html($widget->get_render_attribute_string('address')); ?>><?php echo nl2br($settings['address']); ?></span>
		</a>
	<?php }
	// Time
	if(!empty($settings['time'])){
	?>
	<div <?php etc_print_html( $widget->get_render_attribute_string( 'time-item' ) ); ?>>
		<div <?php etc_print_html($widget->get_render_attribute_string('time_title')); ?>><?php echo esc_html($settings['time_title']); ?></div>
		<div <?php etc_print_html($widget->get_render_attribute_string('time')); ?>><?php echo esc_html($settings['time']); ?></div>
		<div class="exclude-time text-secondary empty-none w-100 text-heading"><?php etc_print_html($settings['exclude_time']); ?></div>
	</div>
	<?php } ?>
	<?php // Socials 
		if (!empty($widget->get_setting('social_title'))) { ?>
		<div <?php etc_print_html( $widget->get_render_attribute_string( 'social_title' ) ); ?>><?php 
			echo etc_print_html( $widget->get_setting('social_title') ); 
		?></div>
	<?php }
	?>
	<div <?php etc_print_html($widget->get_render_attribute_string('icon-wrap')); ?>>
		<?php
			foreach ( $icons as $key => $value ) {
				$_id = isset( $value['_id'] ) ? $value['_id'] : '';
				$link_key = $widget->get_repeater_setting_key( 'link', 'icons', $key );
				$widget->add_render_attribute( $link_key, 'class', [
						'cms-social-item d-flex align-items-center gap-10',
						$class_animation,
						'elementor-repeater-item-' . $_id,
						'text-'.$widget->get_setting('icon_color','accent'),
						'text-hover-'.$widget->get_setting('icon_hover_color', 'white'),
						'bg-'.$widget->get_setting('bg_color', 'grey'),
						'bg-hover-'.$widget->get_setting('bg_hover_color', 'accent-darken'),
						'box-40 circle'
					] );

				$widget->add_link_attributes( $link_key, $value['link'] );

				$title_key = $widget->get_repeater_setting_key( 'title', 'icons', $key );
				$widget->add_render_attribute($title_key, [
					'class' => [
						'cms-stitle',
						'text-'.$widget->get_setting('social_title_color','accent'),
						finanzia_add_hidden_device_controls_render($settings, 'title_')
					]
				]);
				$widget->add_inline_editing_attributes($title_key);
		?>
		<a <?php etc_print_html($widget->get_render_attribute_string( $link_key )); ?>>
			<?php finanzia_elementor_icon_render( $value['social_icon'], [], [ 'aria-hidden' => 'true', 'class' => 'cms-icon text-20' ] ); ?>
			<?php if ( 'yes' === $settings['show_title'] ) { ?><span <?php etc_print_html($widget->get_render_attribute_string( $title_key )); ?>><?php echo esc_html($value['title']); ?></span><?php } ?>
		</a>
		<?php } ?>
	</div>
</div>