<?php 
// Progress Bar
$progressbar_list = $widget->get_setting('progressbar_list', []);
$widget->add_render_attribute('progressbar-wrap', [
	'class' => [
		'cms-eprogress-bar',
		'cms-eprogress-bar-'.$settings['layout'],
		'd-flex align-items-end',
		finanzia_elementor_get_grid_columns($widget, $settings, [
            'default' => '5',
            'tablet'  => '3',
            'gap'	  => 0,
            'gap_prefix' => 'gap-'
        ])
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('progressbar-wrap')); ?>>
	<?php foreach ( $progressbar_list as $key => $progressbar ):
		$wrap_items = $widget->get_repeater_setting_key('wrap-items', 'progressbar_list', $key);
		$wrapper_key = $widget->get_repeater_setting_key( 'wrapper', 'progressbar_list', $key );
		$progress_bar_key = $widget->get_repeater_setting_key( 'progress_bar', 'progressbar_list', $key );
		$title_key = $widget->get_repeater_setting_key( 'title', 'progressbar_list', $key );
		//
		$progressbar_h = !empty($progressbar['height']['size'])  ? $progressbar['height']['size'] : 247;
		$progressbar_color = !empty($progressbar['color']) ? $progressbar['color'] : 'accent';
		$widget->add_inline_editing_attributes( $title_key );
		// Progress item
		$widget->add_render_attribute($wrap_items,[
			'class' => [
				'cms-progress-bar-wrap',
				'd-flex align-items-end'
			],
			'style' => 'height:'.$progressbar_h.'px'
		]);
		// progress bar
		$widget->add_render_attribute( $progress_bar_key, [
			'class'       => [
				'cms-progress-bar',
				'cms-progress-bar-h',
				'bg-'.$progressbar_color,
				'w-100',
				'p-40 p-lr-smobile-20',
				'd-flex flex-column justify-content-between'
			],
			'data-height' => $progressbar_h,
			'style'		  => 'min-height:140px;'	
		]);
		?>
		<div class="cms-progress-item">
			<div <?php etc_print_html( $widget->get_render_attribute_string( $wrap_items ) ); ?>>
				<div <?php etc_print_html( $widget->get_render_attribute_string( $progress_bar_key ) ); ?>>
					<?php if ( ! empty( $progressbar['title'] ) ) { ?>
		            	<div class="d-flex flex-nowrap heading lh-08 text-nowrap text-40 text-white w-100 bdr-b-1 bdr-solid bdr-divider-30 pb-30">
			            	<span class="prefix empty-none"><?php etc_print_html($progressbar['prefix']) ?></span>
			            	<span class="cms-progress-bar-number" data-duration="3000" data-delimiter="" data-to-value="<?php echo esc_attr($progressbar['percent']['size']); ?>"></span>
			            	<span class="suffix empty-none"><?php etc_print_html($progressbar['suffix']) ?></span>
			            </div>
		            	<div class="heading font-700 text-19 text-white mb-n10 align-self-end w-100"><?php echo esc_html( $progressbar['title'] ); ?></div>
					<?php } ?>
				</div>
	        </div>
	    </div>
	<?php endforeach; ?>
</div>