<?php 
// Progress Bar
$progressbar_list = $widget->get_setting('progressbar_list', []);
$widget->add_render_attribute('progressbar-wrap', [
	'class' => [
		'cms-eprogress-bar',
		'cms-eprogress-bar-'.$settings['layout']
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('progressbar-wrap')); ?>>
	<?php foreach ( $progressbar_list as $key => $progressbar ):
		$title_key = $widget->get_repeater_setting_key( 'title', 'progressbar_list', $key );
		$wrapper_key = $widget->get_repeater_setting_key( 'wrapper', 'progressbar_list', $key );
		$progress_bar_key = $widget->get_repeater_setting_key( 'progress_bar', 'progressbar_list', $key );
		$progressbar_h = !empty($progressbar['height']['size'])  ? $progressbar['height']['size'] : 6;
		$progressbar_color = !empty($progressbar['color']) ? $progressbar['color'] : 'accent';
		$widget->add_inline_editing_attributes( $title_key );
		$widget->add_render_attribute( $title_key, [
			'class'=>[
				'cms-progress-bar-title',
				'text-15 font-700 text-body',
				'd-flex justify-content-between no-wrap'
			],
			'style' => 'width:'.$progressbar['percent']['size'].'%'
		]);

		$widget->add_render_attribute( $wrapper_key, [
			'class'         => 'cms-progress-wrap cms-progress-wrap-w',
			'role'          => 'progressbar',
			'aria-valuemin' => '0',
			'aria-valuemax' => '100',
			'aria-valuenow' => $progressbar['percent']['size'],
			'style'		    => '--height:'.$progressbar_h.'px'
		] );
		
		$widget->add_render_attribute( $progress_bar_key, [
			'class'      => 'cms-progress-bar cms-progress-bar-w bg-'.$progressbar_color,
			'data-width' => $progressbar['percent']['size'],
			'style'		 => '--height:'.$progressbar_h.'px'
		] );
		?>
		<div class="cms-progress-bar-wrap">
			<?php if ( ! empty( $progressbar['title'] ) ) { ?>
	            <div <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>>
	            	<?php echo esc_html( $progressbar['title'] ); ?>
	            	<span class="text-14"><span class="cms-progress-bar-number" data-duration="2000" data-delimiter="" data-to-value="<?php echo esc_attr($progressbar['percent']['size']); ?>"></span>%</span>	
	            </div>
			<?php } ?>
	        <div <?php etc_print_html( $widget->get_render_attribute_string( $wrapper_key ) ); ?>>
	            <div <?php etc_print_html( $widget->get_render_attribute_string( $progress_bar_key ) ); ?>></div>
	        </div>
        </div>
	<?php endforeach; ?>
</div>