<?php
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-eprocess-slider',
		'cms-eprocess-slider-'.$settings['layout'],
		'relative',
		'cms-lazy',
		// 'cms-bg-cover',
		'h-100vh w-100',
		'd-flex align-items-end'
	]),
	// 'style' => 'background-image:var(--cms-bg-lazyload-loaded);'
]);
// Process Lists
$process = $widget->get_setting('process_list', []);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php 
	$count = 0;
	foreach($process as $key => $_process){ 
		$count ++;
		// Items
		$item_key = $widget->get_repeater_setting_key('item_key', 'cms_process', $key);
		$widget->add_render_attribute($item_key, [
			'class' => [
				'cms-slider-process cms-nl2br',
				'cms-slider-process-'.$count,
				'text-'.$widget->get_setting('ptitle_color','white'),
				'absolute bottom-left',
				'ml-container',
				'p-lr-20',
				'pb'
			],
			'style' => [
				'--pb:95px;--pb-tablet:45px;',
				'z-index'.($count+1).';'
			]
		]);
		// Count
		$count_key = $widget->get_repeater_setting_key('count_key', 'cms_process', $key);
		$widget->add_render_attribute($count_key, [
			'class' => [
				'count count-'.$count,
				'font-500 text-white text-size lh-07',
				'absolute bottom-right'
			],
			'style' => [
				'--text-size:1000px;--text-mobile-extra:500px;',
				'z-index'.($count+1).';'
			]
		]);
	?>
		<div class="elementor-repeater-item-<?php echo esc_attr($_process['_id']); ?> cms-lazy">
			<div class="cms-gradient-render cms-gradient-custom-1 cms-overlay cms-bg-cover" style="background-image:var(--cms-bg-lazyload-loaded);"></div>
			<h2 <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>><?php 
				echo nl2br($_process['title']);
			?></h2>
			<div <?php etc_print_html($widget->get_render_attribute_string($count_key)); ?>><?php echo esc_html($count); ?></div>
		</div>
	<?php } 
?></div>