<?php
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-eprocess',
		'cms-eprocess-'.$settings['layout'],
		'relative',
		'd-flex'
	])
]);
// Small Heading
$widget->add_inline_editing_attributes( 'smallheading_text' );
$widget->add_render_attribute( 'smallheading_text', [
	'class' => [
		'cms-smallheading',
		'text-'.$widget->get_setting('smallheading_color','accent'),
		'pb-15 mt-n7',
		'font-500',
		'empty-none'
	]
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'mt-n5'
	]
]);
// Description
$widget->add_inline_editing_attributes( 'desc' );
$widget->add_render_attribute( 'desc', [
	'class' => array_filter([
		'cms-desc empty-none',
		'text-'.$widget->get_setting('desc_color','body')
	])
]);
// Process Lists
$process = $widget->get_setting('process_list', []);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php 
	$count = 0;
	$zindex = '';
	foreach($process as $key => $_process){ 
		$count ++;
		// Items
		$item_key = $widget->get_repeater_setting_key('item_key', 'cms_process', $key);
		$widget->add_render_attribute($item_key, [
			'class' => [
				'cms-process',
				'd-flex gutter'
			],
			'data-target' => 'cms-'.$_process['_id']
		]);
		if($key>0){
			$widget->add_render_attribute($item_key, [
				'class' => [
					'pt-70 pt-tablet-40'
				]
			]);
		}
	?>
		<div <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>>
			<div class="col-4 col-tablet-5 col-mobile-12">
				<?php 
					// Count
					finanzia_leading_zero($count, '<div class="pb" style="--pb:42px;">', '.</div>');
				?>
				<div class="cms-heading text-26 text-mobile-20 font-700 mt-n7 empty-none"><?php etc_print_html($_process['title']); ?></div>
				<div class="desc pt-25 mb-n5 empty-none"><?php etc_print_html($_process['desc']); ?></div>
				<?php 
					finanzia_elementor_icon_image_render($widget, $settings, [
						'size'        => 64,
						'class'       => 'pt',
						'color'		  => '',		
						'color_hover' => '',
						'before'	  => '',
						'after'		  => '',
						'attrs'		  => [
							'style' => '--pt:48px;'
						]
					], $_process);
				?>
			</div>
			<div class="col-8 col-tablet-7 col-mobile-12 order-mobile-first"><?php
				finanzia_elementor_image_render($_process,[
					'name'                => 'banner',
					'image_size_key'      => 'banner',
					'img_class'           => '',
					'size'                => 'full',
					'custom_size'         => ['width' => 770, 'height' => 514],
					'before'              => '<div id="cms-'.$_process['_id'].'" class="pl-70 pl-tablet-extra-0 cms-sticky">',
					'after'               => '</div>'
		        ]);
	        ?></div>
		</div>
	<?php } ?>
</div>