<?php
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-eprocess',
		'cms-eprocess-'.$settings['layout'],
		'relative',
		'd-flex'
	])
]);
// Small Heading
$widget->add_inline_editing_attributes( 'smallheading_text' );
$widget->add_render_attribute( 'smallheading_text', [
	'class' => [
		'cms-smallheading',
		'text-'.$widget->get_setting('smallheading_color','body'),
		'pb-15 mt-n7',
		'font-500',
		'empty-none'
	]
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'mt-n5'
	]
]);
// Description
$widget->add_inline_editing_attributes( 'desc' );
$widget->add_render_attribute( 'desc', [
	'class' => array_filter([
		'cms-desc empty-none',
		'text-'.$widget->get_setting('desc_color','body')
	])
]);
// Process Lists
$process = $widget->get_setting('process_list', []);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div class="cms-eprocess-left max-w pr-90 pr-tablet-20 pr-mobile-extra-0 pt-110 pb-90 p-tb-tablet-40 flex-auto flex-mobile-extra-full" style="--max-w:640px;--max-w-tablet:100%;">
		<div class="cms-eheading pb-55 pb-tablet-25">
			<div <?php etc_print_html( $widget->get_render_attribute_string( 'smallheading_text' ) ); ?>><?php echo nl2br( $settings['smallheading_text'] ); ?></div>
			<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php echo nl2br( $settings['heading_text'] ); ?></h2>
		</div>
		<div class="cms--eprocess relative pt-tablet-40">
			<div class="cms--eprocess-scrollbar">
				<div class="cms--eprocess-scrollbar-track"></div>
				<div class="cms--eprocess-scrollbar-thumb"></div>
			</div>
			<?php 
			$count = 0;
			$zindex = '';
			foreach($process as $key => $_process){ 
				$count ++;
				// Items
				$item_key = $widget->get_repeater_setting_key('item_key', 'cms_process', $key);
				$widget->add_render_attribute($item_key, [
					'class' => [
						'cms-process',
						'max-w',
						'relative',
						'pl-110 pl-tablet-40'
					],
					'data-target' => 'cms-'.$_process['_id']
				]);
				if($key>0){
					$widget->add_render_attribute($item_key, [
						'class' => [
							'mt-100 mt-tablet-40 pt-tablet-40'
						]
					]);
				}
			?>
				<div <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>>
					<?php 
						// Count
						finanzia_leading_zero($count, '<span class="absolute top-left pt-45">', '.</span>');
					?>
					<div class="d-flex flex-nowrap justify-content-between gap-20">
						<div class="flex-basic max-w" style="--max-w: 290px;">
							<div class="cms-heading text-19 mt-n7 empty-none"><?php etc_print_html($_process['title']); ?></div>
							<div class="desc text-15 pt-15 mb-n5 empty-none"><?php etc_print_html($_process['desc']); ?></div>
						</div>
						<?php 
							finanzia_elementor_icon_image_render($widget, $settings, [
								'size'        => 64,
								'class'       => 'pt-10',
								'color'		  => '',		
								'color_hover' => '',
								'before'	  => '<div class="flex-auto">',
								'after'		  => '</div>'
							], $_process);
						?>
					</div>
				</div>
			<?php } ?>
		</div>
		<div class="cms-edesc pt-60 pt-tablet-40 pl-110 pl-tablet-0 mt-tablet-40">
			<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc' ) ); ?>><?php echo nl2br( $settings['desc'] ); ?></div>
			<?php 
				finanzia_elementor_link_render($widget, $settings, [
					'name' 		=> 'link1_',
					'mode'		=> 'btn',
					'text_icon'	=> finanzia_svgs_icon([
						'icon'       => 'core/long-arrow-right',
						'icon_class' => '',
						'echo'       => false,
						'class'      => 'text-17'
					]),
					'class' => [
						'mt-33',
						'btn-'.$widget->get_setting('link1_btn_color','accent'),
						'text-'.$widget->get_setting('link1_text_color','white'),
						'btn-hover-'.$widget->get_setting('link1_btn_color_hover', 'primary'),
						'text-hover-'.$widget->get_setting('link1_text_color_hover','white')
					]
				]);
			?>
		</div>
	</div>
	<div class="cms-eprocess-right relative flex-basic flex-tablet-full cms-hidden-tablet">
		<div class="cms-bg-cover-wrapper">
			<?php
			foreach($process as $key => $_process){
			?>
				<?php
				finanzia_elementor_image_render($_process,[
					'name'                => 'banner',
					'image_size_key'      => 'banner',
					
					'img_class'           => '',
					'size'                => 'custom',
					'custom_size'         => ['width' => 800, 'height' => 900],
					'max_height'          => true,
					'as_background'       => true,
					'as_background_class' => 'absolute w-100',
					'before'              => '',
					'after'               => ''
		        ]);
		        ?>
			<?php
			}
			?>
		</div>
	</div>
</div>