<?php 
// Feature
$features = $widget->get_setting('cms_feature', []);
// wrap
$widget->add_render_attribute('wrap', [
	'class' => [
		'cms-epricing',
		'cms-epricing-'.$settings['layout'],
		'p-50 p-lr-tablet-20 relative z-top',
		'bdr-1 bdr-accent',
		'bg-white'
	]
]);
?>
<div class="bg-accent w-100" style="height: 30px;"></div>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php 
		// Icon
		finanzia_elementor_icon_render($settings['cms_icon'],[],['class' => 'cms-pricing-icon', 'icon_color' => 'accent', 'icon_size' => 68] );
	?>
	<div class="cms-smallheading text-15 pb-15 m-tb-n7 empty-none"><?php etc_print_html($settings['subheading_text']) ?></div>
	<div class="cms-title cms-heading text-23 text-accent m-tb-n8 empty-none bdr-b-2 pb-23"><?php etc_print_html($settings['heading_text']) ?></div>

	<?php if(!empty($settings['price'])) { ?>
		<div class="cms-pricing-price d-flex gap-15 align-items-end empty-none pt" style="--pt:50px;">
			<span class="price-heading heading text-primary text-40 lh-1"><?php etc_print_html($settings['price']); ?></span>
			<span class="price-pack text-15 lh-1 pb-5"><?php etc_print_html($settings['price_pack']); ?></span>
		</div>
	<?php } ?>
	<div class="cms-desc text-15 empty-none font-700 m-tb-n7 pt-40"><?php etc_print_html($settings['description_text_bold']) ?></div>
	<div class="cms-desc text-15 empty-none m-tb-n7 pt-40"><?php etc_print_html($settings['description_text']) ?></div>
	<div class="cms-pricing-features pt-40 empty-none text-15 text-<?php echo esc_attr($widget->get_setting('feature_text_color', 'body')) ?>">
		<?php 
			foreach ( $features as $key => $cms_feature ):
				$title_key = $widget->get_repeater_setting_key( 'title', 'cms_list', $key );
				$widget->add_render_attribute($title_key, [
					'class' => [
						'flex-basic',
						'feature-title',
						'm-tb-n7'
					]
				]);
				$widget->add_inline_editing_attributes( $title_key, 'none' );
				// Items
				$item_key = $widget->get_repeater_setting_key('item', 'cms_pricing', $key);
				$widget->add_render_attribute($item_key, [
					'class' => finanzia_nice_class([
						'cms-list d-flex gap-30',
						($key !== 0) ? 'pt-20' : '',
						($key !== (count($features) - 1)) ? 'pb-20 bdr-b-1 bdr-divider' : ''
					])
				]);
			?>
		        <div <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>>
		            <?php 
		            	if(!empty($cms_feature['icon']['value'])){
			            	finanzia_elementor_icon_render($cms_feature['icon'], [], [ 
								'aria-hidden' => 'true', 
								'class'       => 'cms-eicon flex-auto',
								'icon_size'   => 48,
								'icon_color'  => $widget->get_setting('feature_icon_color','green')
			            	]);
			            } else {
			            	finanzia_svgs_icon([
			            		'icon'  => 'check',
			            		'class'	=> 'cms--ficon flex-auto text-11 text-'.$widget->get_setting('feature_icon_color','green')
			            	]);
			            }
		            ?>
		            <span <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php echo esc_html( $cms_feature['title'] ) ?></span>
		        </div>
			<?php endforeach;
		?>
	</div>
	<div class="cms-pricing-buttons d-flex gap-30 mt-50 empty-none"><?php 
		finanzia_elementor_link_render($widget, $settings, [
			'name' 		=> 'link1_',
			'mode'		=> 'btn',
			'text_icon'	=> finanzia_svgs_icon([
				'icon'       => 'core/long-arrow-right',
				'icon_class' => '',
				'echo'       => false,
				'class'      => 'text-17'
			]),
			'class' => [
				'btn-lg',
				'w-100',
				'cms-hover-move-icon-right'
			],
			'btn_color'       => 'accent',
			'btn_color_hover' => 'primary'
		]);
		finanzia_elementor_link_render($widget, $settings, [
			'name' 		=> 'link2_',
			'mode'		=> 'btn',
			'text_icon'	=> '',
			'class' => [
				'btn-lg',
				'w-100'
			]
		]);
	?></div>
	<?php // Ribbon 
	if(!empty($settings['badge_text'])){
	?>
		<div class="cms-ribbon accent absolute top right empty-none"><span class="main"><?php etc_print_html($settings['badge_text']); ?></span></div>
	<?php } 
	?>
</div>