<?php
$default_align = 'center';
// Inline Edit
$widget->add_inline_editing_attributes( 'small_title', 'none' );
$widget->add_inline_editing_attributes( 'title', 'none' );
// Render Background Image
if(!empty($settings['bg_image']['id'])){
	$background_img = 'url('.$settings['bg_image']['url'].')';
} elseif(get_the_post_thumbnail_url('', 'full')) {
	$background_img = 'url('.get_the_post_thumbnail_url('', 'full').')';
} else {
	$background_img = 'var(--cms-ptitle-bg-image)';
}
// Wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-eptitle',
		'cms-eptitle-'.$widget->get_setting('layout','1'),
		'cms-eptitle-overlay',
		'text-'.$default_align,
		'text-white',
        'cms-bg-cover',
		'cms-lazy',
        'pt pb'
	],
	'style' => [
		'--cms-bg-lazyload:'.$background_img.';background-image:var(--cms-bg-lazyload-loaded);',
		'--pt:140px;--pb:140px;--pt-tablet:40px;--pb-tablet:40px;'
	]
]);
// Container
$widget->add_render_attribute('container',[
	'class' => [
		'cms-content container',
		'relative z-top',
		'd-flex justify-content-'.$default_align
	]
]);
// Content
$content_width = !empty($settings['content_width']['size']) ? $settings['content_width']['size'] : 520;
$widget->add_render_attribute('cms--content',[
	'class' => [
		'cms--content',
		'max-w'
	],
	'style' => [
		'--max-w:'.$content_width.'px;'
	]
]);
// Small Title 
$widget->add_render_attribute('small_title', [
	'class' => [
		'cms-small-title font-500',
		'mt-n7 pb-10',
		'empty-none'
	]
]);
// Title
$widget->add_render_attribute( 'title', [
	'class' => [
		'cms-nl2br lh-104',
		'text-60 text-tablet-50 text-smobile-40',
		'text-white',
		'empty-none'
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div <?php etc_print_html($widget->get_render_attribute_string('container')); ?>>
		<div <?php etc_print_html($widget->get_render_attribute_string('cms--content')); ?>>
			<div <?php etc_print_html($widget->get_render_attribute_string('small_title')); ?>><?php echo etc_print_html( $settings['small_title'] ); ?></div>
			<h1 <?php etc_print_html( $widget->get_render_attribute_string( 'title' ) ); ?>><?php echo nl2br( $widget->get_setting('title', get_the_title()) ); ?></h1>
		</div>
	</div>
</div>