<?php
$default_align = 'center';
// Wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-eptitle',
		'cms-eptitle-'.$widget->get_setting('layout','1'),
		'relative z-top',
		finanzia_elementor_get_alignment_class($widget, $settings, [
            'name'         => 'content_align',
            'prefix_class' => 'text-',
            'default'	   => $default_align	
        ]),
        'pt pb-33',
        'p-lr-20'
	],
	'style' => '--pt:283px;--pt-tablet:100px;--pt-mobile-extra:60px;'
]);
// Breadcrumb
$breadcrumb_classes = [
	'text-'.$widget->get_setting('breadcrumb_color_hover', 'grey'),
	'text-hover-'.$widget->get_setting('breadcrumb_text_color_hover','white'),
	'justify-content-'.$default_align
];
$breadcrumb_link_classes = [
	'text-'.$widget->get_setting('breadcrumb_color_hover', 'white'),
	'text-hover-'.$widget->get_setting('breadcrumb_text_color_hover','white'),
];
// Render Background Image
if(!empty($settings['bg_image']['id'])){
	$background_img = $settings['bg_image']['url'];
} elseif(get_the_post_thumbnail_url('', 'full')) {
	$background_img = get_the_post_thumbnail_url('', 'full');
} else {
	$background_img = $settings['bg_image']['url'];
}
$widget->add_render_attribute('background', [
	'class'                         => [
		'cms-eptitle-overlay cms-overlay',
		'cms-bg-cover',
		'cms-lazy'
	],
	'style' => '--cms-bg-lazyload:url('.$background_img.');background-image:var(--cms-bg-lazyload-loaded);'
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('background')); ?>></div>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php finanzia_breadcrumb([
		'icon_home' => '',
		'class'     => finanzia_nice_class($breadcrumb_classes),
		'link_class' => finanzia_nice_class($breadcrumb_link_classes),
		'before'    => '',
		'after'		=> ''
	]); ?>
</div>