<?php
$default_align = 'start';
// Render Background Image
if(!empty($settings['bg_image']['id'])){
	$background_img = 'url('.$settings['bg_image']['url'].')';
} elseif(get_the_post_thumbnail_url('', 'full')) {
	$background_img = 'url('.get_the_post_thumbnail_url('', 'full').')';
} else {
	$background_img = 'var(--cms-ptitle-bg-image)';
}
// Wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-eptitle',
		'cms-eptitle-'.$widget->get_setting('layout','1'),
		'cms-eptitle-overlay',
		'text-'.$default_align,
		'text-white',
        'cms-bg-cover',
		'cms-lazy',
        'pt pb'
	],
	'style' => [
		'--cms-bg-lazyload:'.$background_img.';background-image:var(--cms-bg-lazyload-loaded);',
		'--pt:140px;--pb:33px;--pt-tablet:50px;'
	]
]);
// Container
$widget->add_render_attribute('container',[
	'class' => [
		'cms-content container',
		'relative z-top',
		'd-flex justify-content-'.$default_align
	]
]);
// Content
$content_width = !empty($settings['content_width']['size']) ? $settings['content_width']['size'] : 620;
$widget->add_render_attribute('cms--content',[
	'class' => [
		'cms--content',
		'max-w'
	],
	'style' => [
		'--max-w:'.$content_width.'px;'
	]
]);
// Small Title 
$widget->add_render_attribute('small_title', [
	'class' => [
		'cms-small-title cms-nl2br font-500',
		'mt-n7 pb-10',
		'empty-none',
		'elementor-invisible animated-fast'
	],
	'data-settings' => json_encode([
		'animation' => 'fadeInLeft'
	])
]);
// Title
$widget->add_render_attribute( 'title', [
	'class' => [
		'cms-title cms-nl2br lh-1',
		'text-75 text-tablet-50 text-smobile-40',
		'text-white',
		'empty-none',
		'elementor-invisible'
	],
	'data-settings' => json_encode([
		'animation' => 'fadeInLeft',
		'animation_delay' => 300
	])
]);
// Description
$widget->add_render_attribute( 'description', [
	'class' => [
		'cms-desc cms-nl2br',
		'pt-20',
		'font-700',
		'empty-none',
		'elementor-invisible animated-slow'
	],
	'data-settings' => json_encode([
		'animation' => 'fadeInLeft',
		'animation_delay' => 500
	])
]);

// Inline Edit
$widget->add_inline_editing_attributes( 'small_title', 'none' );
$widget->add_inline_editing_attributes( 'title', 'none' );
$widget->add_inline_editing_attributes( 'description' );
$widget->add_inline_editing_attributes( 'link_text' );
// Buttons 
$widget->add_render_attribute('buttons',[
	'class' => [
		'd-flex gap empty-none',
		'pt-30',
		'justify-content-'.$default_align,
		'elementor-invisible'
	],
	'style' => '--cms-gap:30px;--cms-gap-mobile:20px;',
	'data-settings' => json_encode([
		'animation' => 'fadeInLeft',
		'animation_delay' => 700
	])
]);
// Breadcrumb
$breadcrumb_classes = [
	'text-grey',
	'text-hover-white',
	'justify-content-center p-lr-20',
	'text-15',
	'relative z-top'
];
$breadcrumb_link_classes = [
	'text-'.$widget->get_setting('breadcrumb_color_hover', 'white'),
	'text-hover-'.$widget->get_setting('breadcrumb_text_color_hover','white'),
];
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div <?php etc_print_html($widget->get_render_attribute_string('container')); ?>>
		<div <?php etc_print_html($widget->get_render_attribute_string('cms--content')); ?>>
			<div <?php etc_print_html($widget->get_render_attribute_string('small_title')); ?>><?php echo nl2br( $settings['small_title'] ); ?></div>
			<h1 <?php etc_print_html( $widget->get_render_attribute_string( 'title' ) ); ?>><?php echo nl2br( $widget->get_setting('title', get_the_title()) ); ?></h1>
			<div <?php etc_print_html( $widget->get_render_attribute_string( 'description' ) ); ?>><?php echo nl2br( $settings['description'] ); ?></div>
			<div <?php etc_print_html( $widget->get_render_attribute_string( 'buttons' ) ); ?>><?php 
				// Button #1
				finanzia_elementor_link_render($widget, $settings, [
					'name' 		=> 'link1_',
					'mode'		=> 'btn',
					'text_icon'	=> finanzia_svgs_icon([
						'icon'       => 'core/long-arrow-right',
						'icon_class' => '',
						'class'      => 'text-17',
						'echo'		 => false
					]),
					'class' => [
						'cms-hover-move-icon-right'
					],
					'btn_color'        => 'white',
					'text_color'	   => 'accent',
					'btn_color_hover'  => 'grey',
					'text_color_hover' => 'accent'
				]);
				// Button #2
				finanzia_elementor_link_render($widget, $settings, [
					'name' 		=> 'link2_',
					'mode'		=> 'btn',
					'text_icon'	=> '',
					'class' => [],
					'btn_prefix'       => 'btn-outline-',
					'btn_color'        => 'white',
					'text_color'       => 'white',
					'btn_color_hover'  => 'white',
					'text_color_hover' => 'accent'
				]);
				// Video
				finanzia_elementor_button_video_render($widget, $settings, [
					'name'   => 'video_link',
					'icon'   => $widget->get_setting('video_icon'),
					'icon'   => $widget->get_setting('video_icon'),
					'text'   => $widget->get_setting('video_text','How it works'),
					'layout' => 'btn',
					'class'  => 'btn btn-white text-accent btn-hover-accent text-hover-white',
					'echo'	 => true
			    ])
			?></div>
		</div>
	</div>
	<?php finanzia_breadcrumb([
		'icon_home'  => '',
		'class'      => finanzia_nice_class($breadcrumb_classes),
		'link_class' => finanzia_nice_class($breadcrumb_link_classes),
		'before'     => '<div class="pt elementor-invisible" style="--pt:93px;--pt-tablet:20px;"  data-settings={"animation":"fadeInUp","animation_delay":500}>',
		'after'      => '</div>'
	]); ?>
</div>