<?php
$default_align = 'center';
// Render Background Image
if(!empty($settings['bg_image']['id'])){
	$background_img = 'url('.$settings['bg_image']['url'].')';
} elseif(get_the_post_thumbnail_url('', 'full')) {
	$background_img = 'url('.get_the_post_thumbnail_url('', 'full').')';
} else {
	$background_img = 'var(--cms-ptitle-bg-image)';
}
// Wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-eptitle',
		'cms-eptitle-'.$widget->get_setting('layout','1'),
		'cms-eptitle-overlay',
		'text-'.$default_align,
		'text-white',
        'cms-bg-cover',
		'cms-lazy',
        'pt pb'
	],
	'style' => [
		'--cms-bg-lazyload:'.$background_img.';background-image:var(--cms-bg-lazyload-loaded);',
		'--pt:188px;--pb:33px;--pt-tablet:50px;'
	]
]);
// Container
$widget->add_render_attribute('container',[
	'class' => [
		'cms-content container',
		'relative z-top',
		'd-flex justify-content-'.$default_align
	]
]);
// Content
$content_width = !empty($settings['content_width']['size']) ? $settings['content_width']['size'] : 520;
$widget->add_render_attribute('cms--content',[
	'class' => [
		'cms--content',
		'max-w'
	],
	'style' => [
		'--max-w:'.$content_width.'px;'
	]
]);
// Small Title 
$widget->add_render_attribute('small_title', [
	'class' => [
		'cms-small-title font-500',
		'mt-n7 pb-10',
		'empty-none'
	]
]);
// Title
$widget->add_render_attribute( 'title', [
	'class' => [
		'cms-nl2br lh-104',
		'text-75 text-tablet-50 text-smobile-40',
		'text-white',
		'empty-none'
	]
]);
// Description
$widget->add_render_attribute( 'description', [
	'class' => [
		'cms-desc cms-nl2br',
		'pt-15',
		'font-700',
		'empty-none'
	]
]);

// Inline Edit
$widget->add_inline_editing_attributes( 'small_title', 'none' );
$widget->add_inline_editing_attributes( 'title', 'none' );
$widget->add_inline_editing_attributes( 'description' );
$widget->add_inline_editing_attributes( 'link_text' );
// Buttons 
$widget->add_render_attribute('buttons',[
	'class' => [
		'd-flex gap empty-none',
		'pt-35',
		'justify-content-'.$default_align
	],
	'style' => '--cms-gap:30px;--cms-gap-tablet:30px;--cms-gap-mobile:20px;'
]);
// Breadcrumb
$breadcrumb_classes = [
	'text-white',
	'text-hover-white',
	'justify-content-'.$default_align,
	'text-15'
];
$breadcrumb_link_classes = [
	'text-'.$widget->get_setting('breadcrumb_color_hover', 'white'),
	'text-hover-'.$widget->get_setting('breadcrumb_text_color_hover','white'),
];
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div <?php etc_print_html($widget->get_render_attribute_string('container')); ?>>
		<div <?php etc_print_html($widget->get_render_attribute_string('cms--content')); ?>>
			<div <?php etc_print_html($widget->get_render_attribute_string('small_title')); ?>><?php echo etc_print_html( $settings['small_title'] ); ?></div>
			<h1 <?php etc_print_html( $widget->get_render_attribute_string( 'title' ) ); ?>><?php echo nl2br( $widget->get_setting('title', get_the_title()) ); ?></h1>
			<div <?php etc_print_html( $widget->get_render_attribute_string( 'description' ) ); ?>><?php echo nl2br( $settings['description'] ); ?></div>
			<div <?php etc_print_html( $widget->get_render_attribute_string( 'buttons' ) ); ?>><?php 
				// Button #1
				finanzia_elementor_link_render($widget, $settings, [
					'name' 		=> 'link1_',
					'mode'		=> 'btn',
					'text_icon'	=> finanzia_svgs_icon([
						'icon'       => 'core/arrow-right',
						'icon_class' => '',
						'class'      => 'text-12',
						'echo'		 => false
					]),
					'class' => [
						'btn-lg',
						'cms-hover-move-icon-up'
					],
					'btn_color'        => 'accent',
					'btn_color_hover'  => 'white',
					'text_color_hover' => 'primary'
				]);
				// Button #2
				finanzia_elementor_link_render($widget, $settings, [
					'name' 		=> 'link2_',
					'mode'		=> 'btn',
					'text_icon'	=> '',
					'class' => [
						'btn-lg'
					],
					'btn_prefix'       => 'btn-outline-',
					'btn_color'        => 'white',
					'text_color'       => 'white',
					'btn_color_hover'  => 'white',
					'text_color_hover' => 'primary'
				]);
				// Video
				finanzia_elementor_button_video_render($widget, $settings, [
					'name'   => 'video_link',
					'icon'   => $widget->get_setting('video_icon'),
					'icon'   => $widget->get_setting('video_icon'),
					'text'   => $widget->get_setting('video_text','How it works'),
					'layout' => 'btn',
					'class'  => 'btn btn-lg btn-white text-primary btn-hover-accent text-hover-white',
					'echo'	 => true
			    ])
			?></div>
			<?php finanzia_breadcrumb([
				'icon_home'  => '',
				'class'      => finanzia_nice_class($breadcrumb_classes),
				'link_class' => finanzia_nice_class($breadcrumb_link_classes),
				'before'     => '<div class="pt elementor-invisible" style="--pt:85px;--pt-tablet:20px;" data-settings={"animation":"fadeInUp","animation_delay":500}>',
				'after'      => '</div>'
			]); ?>
		</div>
	</div>
</div>