<?php
$default_align = 'center';
// Render Background Image
if(!empty($settings['bg_image']['id'])){
	$background_img = 'url('.$settings['bg_image']['url'].')';
} elseif(get_the_post_thumbnail_url('', 'full')) {
	$background_img = 'url('.get_the_post_thumbnail_url('', 'full').')';
} else {
	$background_img = 'var(--cms-ptitle-bg-image)';
}
// Wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-ptitle text-center custom overflow-hidden relative',
		'cms-eptitle-'.$settings['layout'],
		'relative z-top',
		finanzia_elementor_get_alignment_class($widget, $settings, [
            'name'         => 'content_align',
            'prefix_class' => 'text-',
            'default'	   => $default_align	
        ]),
        'cms-bg-cover',
		'cms-lazy',
	],
	'style' => '--cms-bg-lazyload:'.$background_img.';background-image:var(--cms-bg-lazyload-loaded);'
]);
// Container
$widget->add_render_attribute('container',[
	'class' => [
		'container relative z-top'
	]
]);
// Small Title 
$widget->add_render_attribute('small_title', [
	'class' => [
		'cms-small-title font-500',
		'mt-n7 pb-25',
		'text-'.$widget->get_setting('small_title_color', 'white'),
		'empty-none'
	]
]);
// Title
$widget->add_render_attribute( 'title', [
	'class' => [
		'title cms-nl2br mt-n15',
		'text-'.$widget->get_setting('title_color','white'),
		'empty-none'
	]
]);
// Inline Edit
$widget->add_inline_editing_attributes( 'title', 'none' );
// CMS Content
$widget->add_render_attribute('cms--content',[
	'class' => [
		'cms--content d-flex flex-column',
		finanzia_elementor_get_alignment_class($widget, $settings, [
            'name'         => 'content_align',
            'prefix_class' => 'justify-content-',
            'default'	   => $default_align	
        ])
	]
]);
// Breadcrumb
$breadcrumb_classes = [
	'text-'.$widget->get_setting('breadcrumb_color_hover', 'grey'),
	'text-hover-'.$widget->get_setting('breadcrumb_text_color_hover','white'),
	'justify-content-'.$default_align,
	'pt-15 mb-n7',
	'text-15',
	'font-700'
];
$breadcrumb_link_classes = [
	'text-'.$widget->get_setting('breadcrumb_color_hover', 'white'),
	'text-hover-'.$widget->get_setting('breadcrumb_text_color_hover','white'),
];
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div <?php etc_print_html($widget->get_render_attribute_string('container')); ?>>
		<div <?php etc_print_html($widget->get_render_attribute_string('small_title')); ?>><?php echo etc_print_html( $settings['small_title'] ); ?></div>
		<h1 <?php etc_print_html( $widget->get_render_attribute_string( 'title' ) ); ?>><?php echo nl2br( $widget->get_setting('title', get_the_title()) ); ?></h1>
		<?php finanzia_breadcrumb([
			'icon_home' => '',
			'class'     => finanzia_nice_class($breadcrumb_classes),
			'link_class' => finanzia_nice_class($breadcrumb_link_classes),
			'before'    => '',
			'after'		=> ''
		]); ?>
	</div>
</div>