<?php
$default_align = 'start';
// wrap
$widget->add_render_attribute('wrap', [
    'class' => [
        'cms-newsletter',
        'cms-newsletter-'.$settings['layout'],
        finanzia_elementor_get_alignment_class($widget, $settings, ['name' => 'align','default' => $default_align]),
        'bg-accent-lighten',
        'cms-radius-24',
        'p-70 p-lr-mobile-40 p-lr-smobile-20',
        'd-flex gap-40 justify-content-between align-items-center'
    ]
]);
// title 
$widget->add_inline_editing_attributes('title');
$widget->add_render_attribute('title', [
    'class' => [
        'cms-title cms-heading',
        'empty-none',
        'text-'.$settings['title_color'],
        'text-40 text-tablet-30',
        'm-tb-n7'
    ]
]);
// Desccription
$widget->add_inline_editing_attributes('description');
$widget->add_render_attribute('description', [
    'class' => [
        'cms-desc empty-none',
        'text-'.$settings['desc_color'],
        'text-15',
        'm-tb-n7 pt-20'
    ]
]);
// Privacy Policy
$widget->add_render_attribute('privacy_policy_text_wrap', [
    'class' => [
        'cms-pp text-14 empty-none',
        'text-'.$settings['desc_color'],
        'pt-15'
    ]
]);
// Privacy Policy text
$widget->add_inline_editing_attributes('privacy_policy_text');
$widget->add_render_attribute('privacy_policy_text',[
    'class' => 'pp-text'
]);
// Privacy Policy link
$widget->add_render_attribute( 'privacy_policy_link_text', [
    'class' =>[
        'pp-link',
        'cms-hover-underline',
        'text-'.$settings['desc_color'],
        'text-hover-'.$settings['desc_color'],
    ],
    'href'  => get_permalink($widget->get_setting('privacy_policy_page'))
]);
// Form Fields
$show_name = $widget->get_setting('show_name','no');
// Shortcode
$fields = '[newsletter_form button_label="'.$widget->get_setting('button_text',esc_html__('Subscribe','finanzia')).'" class="cms-nlf-1 relative d-flex gap-30" style="--cms-form-btn-bg:var(--cms-accent);--cms-form-btn-bg-hover:var(--cms-accent-darken);--cms-form-btn-height:68px;--cms-form-field-border:0px 4px 24px rgba(8, 2, 52, 0.05);--cms-form-field-border-hover:0px 4px 24px rgba(8, 2, 52, 0.1);--cms-form-field-bg-color:white;--cms-tnp-field-email-flex:1 0 0%;"]';
    if($show_name == 'yes'){
        $fields .= '[newsletter_field name="first_name" label="" placeholder="'.$widget->get_setting('name_text',esc_html__('Your Name','finanzia')).'"]';
    }
    $fields .= '[newsletter_field name="email" label="" placeholder="'.$widget->get_setting('email_text',esc_html__('Your Email Address','finanzia')).'"]';
$fields .= '[/newsletter_form]';
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
    <div class="flex-auto max-w" style="--max-w:370px;--max-w-smobile:100%;">
        <h2 <?php etc_print_html($widget->get_render_attribute_string('title')); ?>><?php 
            echo nl2br($settings['title']); 
        ?></h2>
        <div <?php etc_print_html($widget->get_render_attribute_string('description')); ?>><?php 
            echo wpautop($settings['description']); 
        ?></div>
    </div>
    <div class="flex-basic flex-tablet-full max-w" style="--max-w:590px;">
        <?php 
            switch ($settings['layout_form']) {
                case 'custom':
                    newsletter_form($settings['form_id']); 
                    break;
                
                default:
                    echo do_shortcode($fields); 
                    break;
            }
        //
        if(!empty($widget->get_setting('privacy_policy_page'))){
        ?>
            <div <?php etc_print_html($widget->get_render_attribute_string('privacy_policy_text_wrap')); ?>>
                <span <?php etc_print_html($widget->get_render_attribute_string('privacy_policy_text')); ?>><?php 
                    // text
                    etc_print_html($settings['privacy_policy_text']).'&nbsp;';
                ?></span>
                <?php 
                    // link
                    etc_print_html(
                        '<a '.$widget->get_render_attribute_string('privacy_policy_link_text').'>'.$widget->get_setting('privacy_policy_link_text', esc_html__('Privacy Policy','finanzia')).'</a>'
                    );
                ?>
            </div>
        <?php } ?>
    </div>
</div>