<?php
// Wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-emenu',
		'cms-emenu-'.$settings['layout']
	]
]);
//Link
$page_ID = $widget->get_setting('page_link','');
switch ($settings['link_type']) {
	case 'page':
		$url  = !empty($page_ID) ? get_permalink($page_ID) : '#';
		break;
	default:
		$url = $widget->get_setting('custom_link', ['url' => '#'])['url'];
		break;
}
// Title
$widget->add_inline_editing_attributes( 'title', 'none' );
$widget->add_render_attribute( 'title', [
	'class' => [
		'cms-title',
		'text-19',
		'text-'.$widget->get_setting('title_color', 'heading'),
		'mt-n5 pb-10'
	]
]);
$widget->add_render_attribute( 'title_link', [
	'class' => [
		'text-'.$widget->get_setting('title_color', 'heading'),
		'cms-hover-underline'
	],
	'href' => $url
]);
// Menu
$menu = $widget->get_setting('menu','');
$link_class = implode(' ', array_filter([
	'text-'.$widget->get_setting('link_color','link'),
	'text-hover-'.$widget->get_setting('link_color_hover','link')
]));
if ( ! empty( $menu ) ) : ?>
	<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
		<h2 <?php etc_print_html($widget->get_render_attribute_string( 'title' ) ); ?>>
			<a <?php etc_print_html($widget->get_render_attribute_string('title_link')) ?>><?php echo etc_print_html( $settings['title'] ); ?></a>
		</h2>
		<?php 
			wp_nav_menu( array(
				'fallback_cb'     => '',
				'walker'          => '',
				'container'       => '',
				'container_class' => '',
				'menu'            => $menu,
				'menu_class'      => 'cms-dropdown-mega',
				'li_class'		  => 'cms-dropdown-mega-item',
				'link_class'      => $link_class,
				'depth'           => 1,
				'link_before' 	  => finanzia_cms_menu_child_icon(),
				'theme_location'  => ''
			)); 
		?>
	</div>
<?php  endif;  ?>