<?php
$default_align = 'start';
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-eheading',
		'cms-eheading-'.$widget->get_setting('layout'),
		'text-'.$widget->get_setting('align', $default_align),
		'h-100 d-flex justify-content-between flex-column'
	])
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'mt-n10'
	]
]);
// Description
$widget->add_inline_editing_attributes( 'desc' );
$widget->add_render_attribute( 'desc', [
	'class' => array_filter([
		'cms-desc pt-25 empty-none',
		'text-'.$widget->get_setting('desc_color','body')
	])
]);
// Feature List
$features = $widget->get_setting('cms_feature', []);
$widget->add_render_attribute('features-wrap', [
	'class' => [
		'cms-heading-features pt-80 pt-tablet-40',
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div>
		<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php echo nl2br( $settings['heading_text'] ); ?></h2>
		<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc' ) ); ?>><?php echo nl2br( $settings['desc'] ); ?></div>
		<div class="d-flex gap-30 pt-40 empty-none"><?php 
		// Button #1
		finanzia_elementor_link_render($widget, $settings, [
			'name' 		=> 'link1_',
			'mode'		=> 'btn',
			'text_icon'	=> finanzia_svgs_icon([
				'icon'       => 'core/long-arrow-right',
				'icon_class' => '',
				'echo'       => false,
				'class'      => 'text-17'
			]),
			'class' => [
				'cms-hover-move-icon-right'
			],
			'btn_color'        => 'accent',
			'text_color'       => 'white',
			'btn_color_hover'  => 'accent-darken',
			'text_color_hover' => 'white'	
		]);
		// Button #2
		finanzia_elementor_link_render($widget, $settings, [
			'name' 		=> 'link2_',
			'mode'		=> 'btn',
			'text_icon'	=> '',
			'btn_prefix'	   => 'btn-outline-',	
			'btn_color'        => 'primary',
			'text_color'       => 'primary',
			'btn_color_hover'  => 'accent',
			'text_color_hover' => 'white'	
		]);
		?></div>
	</div>
	<?php if($settings['show_feature'] == 'yes'): ?>
	<div <?php etc_print_html($widget->get_render_attribute_string('features-wrap')); ?>>
		<?php
		// Feature List
		foreach ( $features as $key => $cms_feature ):
			// Items
			$item_key = $widget->get_repeater_setting_key( 'item', 'cms_list', $key );
			$widget->add_render_attribute($item_key, [
				'class' => [
					'cms-list',
					'hover-icon-bounce',
					'd-flex gap-15 align-items-start',
					'bdr-'.$widget->get_setting('feature_border_color','divider')
				]
			]);
			if($key != (count($features)-1)){
				$widget->add_render_attribute($item_key, [
					'class' => [
						'pb-20'
					]
				]);
			}
			// Title
			$title_key = $widget->get_repeater_setting_key( 'title', 'cms_list', $key );
			$widget->add_render_attribute($title_key, [
				'class' => [
					'heading feature-title',
					'text-17',
					'text-'.$widget->get_setting('feature_title_color','heading')
				]
			]);
			$widget->add_inline_editing_attributes( $title_key, 'none' );
		?>
	        <div <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>>
	            <?php 
	            	if(!empty($cms_feature['icon']['value'])){
		            	finanzia_elementor_icon_render($cms_feature['icon'], [], [ 
							'aria-hidden' => 'true', 
							'class'       => 'cms-eicon flex-auto',
							'icon_size'   => 64,
							'icon_color'  => $widget->get_setting('feature_icon_color','primary')
		            	]);
		            } else {
		            	finanzia_svgs_icon([
		            		'icon'  => 'check',
		            		'class'	=> 'cms--ficon box-25 circle bg-'.$widget->get_setting('feature_icon_bg_color','primary').' flex-auto text-9 text-'.$widget->get_setting('feature_icon_color','white')
		            	]);
		            }
	            ?>
	            <div class="feature-content flex-basic">
	            	<div <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php 
	            		echo esc_html( $cms_feature['title'] ); 
	            	?></div>
	            	<div class="desc text-15 empty-none m-tb-n5 pt-15"><?php
	            		echo nl2br($cms_feature['description']);
	            	?></div>
	            </div>
	        </div>
		<?php endforeach;?>
	</div>
	<?php endif; ?>
</div>