<?php
$default_align = 'start';
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-eheading',
		'cms-eheading-'.$widget->get_setting('layout'),
		'text-'.$widget->get_setting('align', $default_align),
		'd-flex justify-content-between align-items-end',
		'gapY-30'
	])
]);
// Small Heading
$widget->add_inline_editing_attributes( 'smallheading_text' );
$widget->add_render_attribute( 'smallheading_text', [
	'class' => [
		'cms-smallheading text-15',
		'text-'.$widget->get_setting('smallheading_color','body'),
		'pb-15 mt-n5',
		'empty-none'
	]
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'm-tb-n7'
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div class="max-w flex-basic" style="--max-w:510px;">
		<div <?php etc_print_html( $widget->get_render_attribute_string( 'smallheading_text' ) ); ?>><?php 
			etc_print_html( $settings['smallheading_text'] ); 
		?></div>
		<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php 
			echo nl2br( $settings['heading_text'] ); 
		?></h2>
	</div>
	<div class="flex-auto flex-mobile-full d-flex justify-content-end">
		<?php
			// Button #1
			finanzia_elementor_link_render($widget, $settings, [
				'name' 		=> 'link1_',
				'mode'		=> 'btn',
				'text_icon'	=> finanzia_svgs_icon([
					'icon'       => 'core/long-arrow-right',
					'icon_class' => '',
					'echo'       => false,
					'class'      => 'text-17'
				]),
				'class' => [
					'cms-hover-move-icon-right',
					'mt-35'
				],
				'btn_color'       => 'accent',
				'btn_color_hover' => 'accent-darken'
			]);
		?>
	</div>
</div>