<?php
$default_align = 'start';
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-eheading',
		'cms-eheading-'.$widget->get_setting('layout'),
		'text-'.$widget->get_setting('align', $default_align)
	])
]);
// Small Heading
$widget->add_inline_editing_attributes( 'smallheading_text' );
$widget->add_render_attribute( 'smallheading_text', [
	'class' => [
		'cms-smallheading',
		'text-'.$widget->get_setting('smallheading_color','accent'),
		'text-15',
		'pb-20 mt-n5',
		'empty-none'
	]
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'mt-n10'
	]
]);
// Description
$widget->add_inline_editing_attributes( 'desc' );
$widget->add_render_attribute( 'desc', [
	'class' => array_filter([
		'cms-desc empty-none',
		'text-'.$widget->get_setting('desc_color','body'),
		'pt-33',
		'mt-33',
		'bdr-t-1 bdr-divider'
	])
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php if(!empty($settings['smallheading_text'])){ ?>
		<div <?php etc_print_html( $widget->get_render_attribute_string( 'smallheading_text' ) ); ?>><?php echo nl2br( $settings['smallheading_text'] ); ?></div>
	<?php } ?>
	<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php echo nl2br( $settings['heading_text'] ); ?></h2>
	<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc' ) ); ?>><?php echo nl2br( $settings['desc'] ); ?></div>
	<div class="d-flex gap-30 mt-30 empty-none"><?php
		finanzia_elementor_link_render($widget, $settings, [
			'name' 		=> 'link1_',
			'mode'		=> 'btn',
			'text_icon'	=> finanzia_svgs_icon([
				'icon'       => 'core/long-arrow-right',
				'icon_class' => '',
				'echo'       => false,
				'class'      => 'text-17'
			]),
			'class'            => ['cms-hover-move-icon-right'],
			'text_color'       => 'white',
			'btn_color'        => 'primary',
			'text_hover_color' => 'white',
			'btn_hover_color'  => 'accent'
		]);
		finanzia_elementor_link_render($widget, $settings, [
			'name'             => 'link2_',
			'mode'             => 'btn',
			'text_icon'        => '',
			'class'            => [],
			'btn_prefix'	   => 'btn-outline-',	
			'text_color'       => 'primary',
			'btn_color'        => 'primary',
			'text_hover_color' => 'white',
			'btn_hover_color'  => 'accent'
		]);
	?></div>
</div>