<?php
$default_align = 'start';
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-eheading',
		'cms-eheading-'.$widget->get_setting('layout'),
		'text-'.$widget->get_setting('align', $default_align),
		'h-100',
		'd-flex flex-column justify-content-between'
	])
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'mt-n10'
	]
]);
// Description
$widget->add_inline_editing_attributes( 'desc' );
$widget->add_render_attribute( 'desc', [
	'class' => array_filter([
		'cms-desc pt-15 empty-none',
		'text-'.$widget->get_setting('desc_color','body')
	])
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php echo nl2br( $settings['heading_text'] ); ?></h2>
	<div class="clearfix">
		<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc' ) ); ?>><?php echo nl2br( $settings['desc'] ); ?></div>
		<?php 
		// Button
		finanzia_elementor_link_render($widget, $settings, [
			'name' 		=> 'link1_',
			'mode'		=> 'btn',
			'text_icon'	=> finanzia_svgs_icon([
				'icon'       => 'core/arrow-right',
				'icon_class' => '',
				'echo'       => false,
				'class'      => 'text-12'
			]),
			'class' => [
				'btn-lg',
				'cms-hover-move-icon-up',
				'mt-30'
			],
			'btn_color'        => 'accent',
			'text_color'       => 'white',
			'btn_color_hover'  => 'accent-darken',
			'text_color_hover' => 'white'	
		]);
		?>
	</div>
</div>