<?php
$default_align = 'start';
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-eheading',
		'cms-eheading-'.$widget->get_setting('layout'),
		'text-'.$widget->get_setting('align', $default_align)
	])
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'font-700 empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'mt-n7'
	]
]);
// Description #1
$widget->add_inline_editing_attributes( 'desc' );
$widget->add_render_attribute( 'desc', [
	'class' => array_filter([
		'cms-desc empty-none',
		'text-'.$widget->get_setting('desc_color','heading'),
		'mt-n7 pt-25'
	])
]);
// Signature
$widget->add_render_attribute('signature-wrap',[
	'class' => [
		'cms-signature d-flex gap-20 align-items-center mt-50',
		'text-nowrap',
		'justify-content-'.$widget->get_setting('align', $default_align),
		'relative'
	]
]);
// Signature name
//$widget->add_inline_editing_attributes( 'sname' );
$widget->add_render_attribute('sname', [
	'class' => [
		'sname',
		'cms-heading text-19 font-500'
	]
]);
// Signature position
//$widget->add_inline_editing_attributes( 'sposition' );
$widget->add_render_attribute('sposition', [
	'class' => [
		'sposition',
		'text-14 text-heading',
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<div <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php echo nl2br( $settings['heading_text'] ); ?></div>
	<div <?php etc_print_html( $widget->get_render_attribute_string( 'desc' ) ); ?>><?php 
		echo nl2br( $settings['desc'] ); 
	?></div>
	<div <?php etc_print_html($widget->get_render_attribute_string('signature-wrap')); ?>>
		<?php finanzia_elementor_image_render($settings, [
			'name'        => 'savatar',
			'size'		  => 'custom',
			'custom_size' => ['width' => 90, 'height' => 122],
			'img_class'   => finanzia_nice_class(['savatar', 'cms-radius-16']),
			'attrs'		  => [],
			'before'      => '',
			'after'       => ''
		]); ?>
		<div class="stext flex-auto relative">
			<?php 
				finanzia_elementor_image_render($settings, [
					'name'        => 'simage',
					'size'        => 'full',
					'img_class'	  => 'rtl-flip ml-50 max-h',
					'custom_size' => ['width' => 172, 'height'=> 67],
					'attrs' => [
						'style' => '--max-h:67px;width:auto'
					]
				]);
			?>
			<div class="cms--signature absolute center-left">
				<div <?php etc_print_html($widget->get_render_attribute_string('sname')); ?>><?php echo nl2br($settings['sname']); ?></div>
				<div <?php etc_print_html($widget->get_render_attribute_string('sposition')); ?>><?php echo nl2br($settings['sposition']); ?></div>
			</div>
		</div>
	</div>
</div>