<?php
$default_align = $widget->get_setting('text_align', 'start');
$fancy_boxs = $widget->get_setting('fancy_box', []);
// Wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-fancyboxs-'.$settings['layout'],
		'd-flex gutter-custom-x gutter-custom-y',
		finanzia_elementor_get_grid_columns($widget, $settings, [
			'default' => 3,
			'tablet'  => 3,
			'mobile'  => 2	
		]),
		finanzia_elementor_get_alignment_class($widget, $settings, [
			'name'    => 'text_align',
			'default' => $default_align
		])
	],
	'style' => implode(';', [
		'--gutter-x:40px',
		'--gutter-y:60px'
	])
]);
//Title
$widget->add_render_attribute( 'title', [
	'class' => [
		'cms-title cms-heading text-19',
		'text-'.$widget->get_setting('title_color','white'),
		'mt-n5'
	]
]);
// Description
$widget->add_render_attribute( 'description', [
	'class' => [
		'cms-desc',
		'text-'.$widget->get_setting('description_color','grey'),
		'text-15',
		'pt-10 mb-n5',
		'empty-none'
	]
]);
// Output HTMl
?>
<div class="p-70 p-tablet-40 p-lr-smobile-20 cms-backdrop-1">
	<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
		<?php 
		$count = 0;
		foreach ($fancy_boxs as $key => $fancy_box) { 
			$count++;
			// Item
			$item_key = $widget->get_repeater_setting_key( 'item', 'cms_fancy_box', $key );
			$widget->add_render_attribute( $item_key, [
				'class' => array_filter([
					'cms-fancybox',
					'cms-fancybox-'.$settings['layout'],
					'hover-icon-bounce',
					'd-flex gutter-custom-x align-items-center'
				]),
				'style' => '--gutter-x:50px;'
			]);
		?>
		<div class="fancy-box-item relative">
			<div <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>>
				<?php
					// Icon
					finanzia_elementor_icon_image_render($widget, $settings,[
						'size'        => 48,
			            'color'       => $widget->get_setting('icon_color','white'),
			            'color_hover' => $widget->get_setting('icon_color','white'),
			            // icon
			            'icon_tag'    => 'div',
			            'icon_default' => [],
			            // default
			            'class'      => 'flex-auto',
			            'before'     => '',
			            'after'      => '',
			            'echo'       => true
					], $fancy_box);
				?>
				<div class="flex-basic">
					<div <?php etc_print_html( $widget->get_render_attribute_string( 'title' ) ); ?>><?php echo nl2br( $fancy_box['title'] ); ?></div>
				    <div <?php etc_print_html( $widget->get_render_attribute_string( 'description' ) ); ?>><?php echo wpautop( $fancy_box['description'] ); ?></div>
					<?php 
						finanzia_elementor_link_render($widget, $fancy_box, [
							'loop'        => true,
							'loop_key'    => $key,
							'color'       => false,
							'class'       => 'mt-23 cms-link font-700 cms-hover-underline cms-hover-move-icon-right',
							'before_text' => '',
							'after_text'  => '',
							'text_icon'   => finanzia_svgs_icon([
								'icon'       => 'core/long-arrow-right',
								'class'      => 'text-17',
								'icon_class' => '',
								'echo'       => false
							])
						]);
					?>
				</div>
			</div>
		</div>
		<?php } ?>
	</div>
</div>
