<?php
$default_align = $widget->get_setting('text_align', 'start');
$fancy_boxs = $widget->get_setting('fancy_box', []);
// Wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-fancyboxs-'.$settings['layout'],
		'd-flex gutter',
		finanzia_elementor_get_grid_columns($widget, $settings, [
			'default' => 4,
			'tablet'  => 3,
			'mobile'  => 2,
			'gap'        => '',
			'gap_prefix' => ''	
		]),
		finanzia_elementor_get_alignment_class($widget, $settings, [
			'name'    => 'text_align',
			'default' => $default_align
		])
	]
]);
//Title
$widget->add_render_attribute( 'title', [
	'class' => [
		'cms-title cms-heading cms-nl2br cms-transition',
		'text-'.$widget->get_setting('title_color','primary'),
		'text-on-hover-white',
		'text-19',
		'mt-n5 pb-10'
	]
]);
// Description
$widget->add_render_attribute( 'description', [
	'class' => [
		'cms-desc cms-nl2br cms-transition',
		'text-'.$widget->get_setting('description_color','body'),
		'text-on-hover-primary-lighten',
		'text-15',
		'mb-n5',
		'empty-none'
	]
]);
// Output HTMl
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php 
	$count = 0;
	foreach ($fancy_boxs as $key => $fancy_box) { 
		$count++;
		// Item
		$item_key = $widget->get_repeater_setting_key( 'item', 'cms_fancy_box', $key );
		$widget->add_render_attribute( $item_key, [
			'class' => array_filter([
				'fancy-box-item relative'
			])
		]);
		// Item Inner
		$item_inner_key = $widget->get_repeater_setting_key( 'item-inner', 'cms_fancy_box', $key );
		$widget->add_render_attribute( $item_inner_key, [
			'class' => array_filter([
				'cms-fancybox relative overflow-hidden',
				'cms-fancybox-'.$settings['layout'],
				'hover-icon-bounce',
				'bdr-t-1 bdr-l-1 bdr-divider bdr-hover-transparent',
				'cms-hover-change',
				'p-tb-40 pl-40 pr-30'
			])
		]);
	?>
	<div <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>>
		<div <?php etc_print_html($widget->get_render_attribute_string($item_inner_key)); ?>>
			<div class="bg-gradient-1 cms-transition cms-overlay cms-hover-show always move-left"></div>
			<div class="relative z-top">
				<div class="count text-on-hover-white pb cms-transition" style="--pb:65px;"><?php finanzia_leading_zero($count); ?>.</div>
				<div <?php etc_print_html( $widget->get_render_attribute_string( 'title' ) ); ?>><?php echo nl2br( $fancy_box['title'] ); ?></div>
			    <div <?php etc_print_html( $widget->get_render_attribute_string( 'description' ) ); ?>><?php echo wpautop( $fancy_box['description'] ); ?></div>
			    <?php
					// Icon
					finanzia_elementor_icon_image_render($widget, $settings,[
						'size'        => 48,
			            'color'       => $widget->get_setting('icon_color','accent'),
			            'color_hover' => $widget->get_setting('icon_color','accent'),
			            // icon
			            'icon_tag'    => 'div',
			            'icon_default' => [],
			            // default
			            'class'      => 'mt-50',
			            'before'     => '',
			            'after'      => '',
			            'echo'       => true
					], $fancy_box);
				?>
				<?php 
					finanzia_elementor_link_render($widget, $fancy_box, [
						'loop'        => true,
						'loop_key'    => $key,
						'color'       => false,
						'class'       => 'mt box-47 circle bdr-1 bdr-accent bdr-on-hover-white bg-on-hover-white text-accent cms-hover-icon-zoomout',
						'attrs'		  => [
							'style' => '--mt:70px;'
						],
						'before_text' => '<span class="screen-reader-text">',
						'after_text'  => '</span>',
						'text_icon'   => finanzia_svgs_icon([
							'icon'       => 'core/plus',
							'class'      => 'text-12',
							'icon_class' => '',
							'echo'       => false
						])
					]);
				?>
			</div>
		</div>
	</div>
	<?php } ?>
</div>
