<?php
$widget->add_inline_editing_attributes( 'text' );
$widget->add_inline_editing_attributes( 'link_text' );
// Wrap
$widget->add_render_attribute('wrap', [
	'class' => array_filter([
		'cms-cta',
		'cms-cta-'.$settings['layout'],
		finanzia_elementor_get_alignment_class($widget, $settings, ['name' => 'align','default'=>'start']),
		'bg-accent-darken',
		'p-40 p-lr-smobile-20'
	])
]);
// Title
$widget->add_render_attribute('title', [
	'class' => array_filter([
		'cms-heading cms-nl2br',
		'text-'.$widget->get_setting('title_color', 'white'),
		'text-26 lh mt-n8'
	]),
	'style' => '--lh:1.5;'
]);
// Description
$widget->add_render_attribute('text', [
	'class' => array_filter([
		'cms-desc cms-nl2br',
		'text-'.$widget->get_setting('title_color', 'primary-lighten'),
		'pt-23 pb'
	]),
	'style' => '--pb:93px;'
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<h2 <?php etc_print_html($widget->get_render_attribute_string('title')) ?>><?php echo nl2br($settings['title']);?></h2>
	<div <?php etc_print_html($widget->get_render_attribute_string('text')) ?>><?php echo nl2br($settings['text']);?></div>
	<?php 
		// Buttons 
		finanzia_elementor_link_render($widget, $settings, [
			'name'      => 'btn_',
			'mode'      => 'btn',
			'text_icon' => finanzia_svgs_icon([
				'icon'       => 'core/long-arrow-right',
				'icon_class' => '',
				'icon_size'  => 17,
				'echo'       => false
			]),
			'class' => [
				'cms-hover-move-icon-right',
				'btn-lg',
				'w-100'
			],
			'btn_color'       => 'white',
			'text_color'	  => 'accent',
			'btn_color_hover' => 'white',
			'text_color_hover' => 'accent'
		]);
		// Email 
		finanzia_elementor_link_render($widget, $settings, [
			'name'      => 'email_',
			'mode'      => '',
			'text_icon' => '',
			'class' => [
				'cms-link cms-hover-underline',
				'text-center pt-23'
			],
			'text_color'	  => 'white',
			'text_color_hover' => 'white',
			'before' => '<div class="text-center mb-n8">',
			'after'	 => '</div>'
		]);
	?>
</div>