<?php
$counters = $widget->get_setting('counters', []);
$default_align = 'start';
if(empty($counters)) return;
// wrap
$widget->add_render_attribute('wrap', [
	'class' => [
		'cms-ecounter',
		'cms-ecounter-'.$settings['layout'],
		'text-'.$default_align,
		'overflow-hidden'
	]
]);
// Number
$widget->add_render_attribute('counter--number',[
	'class' => [
		'cms-counter-numbers',
		'heading font-400 text-60 lh-08 text-nowrap',
		'text-'.$widget->get_setting('number_color','primary'),
		'mb-30',
		'd-flex flex-nowrap justify-content-'.$default_align
	]
]);
// Title
$widget->add_inline_editing_attributes( 'title');
$widget->add_render_attribute('title', [
	'class' => [
		'cms-counter-title cms-nl2br',
		'text-15',
		'text-'.$widget->get_setting('title_color','body'),
		'm-tb-n7'
	]
]);
// Description
$widget->add_inline_editing_attributes( 'description');
$widget->add_render_attribute('description', [
	'class' => [
		'cms-counter-desc cms-nl2br',
		'text-14',
		'text-'.$widget->get_setting('desc_color','body'),
		'm-tb-n5 pt-20'
	]
]);
// Layout mode setting
// Carousel Settings
$widget->add_render_attribute('carousel-settings',[
    'class' => [
    	'cms-ecounter',
    	'cms-ecounter-'.$settings['layout'],
        'cms-carousel swiper',
    ]
]);
// Arrows
$arrows = $widget->get_setting('arrows');
$widget->add_render_attribute('arrows', [
    'class' => [
        'cms-swiper-buttons d-flex gap-10 flex-auto',
        finanzia_add_hidden_device_controls_render($settings, 'arrows_')
    ]
]);
$arrows_classes = [
    'cms-carousel-button text-9',
    'box-58 circle',
    'text-'.$widget->get_setting('arrow_color','accent-darken'),
    'bdr-1 bdr-'.$widget->get_setting('arrow_color','accent-darken'),
    'bg-'.$widget->get_setting('arrow_bg_color','white'),
    'text-hover-'.$widget->get_setting('arrow_hover_color','white'),
    'bdr-hover-'.$widget->get_setting('arrow_hover_color','white'),
    'bg-hover-'.$widget->get_setting('arrow_bg_hover_color','accent')
];
$arrows_classes_prev = finanzia_nice_class(array_merge(['cms-carousel-button-prev prev'],$arrows_classes));
$arrows_classes_next = finanzia_nice_class(array_merge(['cms-carousel-button-next next'],$arrows_classes));

// Dots
$dots = $widget->get_setting('dots');
$widget->add_render_attribute('dots', [
    'class' => [
        'cms-carousel-dots cms-carousel-dots-bullets',
        'cms-carousel-dots-primary cms-carousel-dots-active-accent-regular',
        'justify-content-start gap-10 flex-basic',
        finanzia_add_hidden_device_controls_render($settings, 'dots_')
    ],
    'style' => [
        '--cms-dots-color:var(--cms-grey);',
        '--cms-dots-hover-color:var(--cms-accent);'
    ]
]);
// Grid Settings
$widget->add_render_attribute('grid-settings',[
    'class' => [
    	'cms-ecounter',
    	'cms-ecounter-'.$settings['layout'],
        'cms-counter-grid',
        'd-flex',
        finanzia_elementor_get_grid_columns($widget, $settings, [
			'prefix_class' => 'flex-col-', 
			'default'      => '2', 
			'gap'          => 100,
			'gap_prefix'   => 'gutterX-'
        ])
    ]
]);
?>

<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php
		// Start Counter 
		switch ($settings['layout_mode']) {
			case 'carousel':
		?>
		<div <?php etc_print_html($widget->get_render_attribute_string('carousel-settings')); ?>>
			<div class="swiper-wrapper">
		<?php
			break;
			default:
		?>
		<div <?php etc_print_html($widget->get_render_attribute_string('grid-settings')); ?>>
		<?php
			break;
		}
		// Start Item
		$count = 0;
		foreach ($counters as $key => $counter) {
			$count ++;
			$data_counter     = $widget->get_repeater_setting_key( 'counter-number', 'cms_counter', $key );
		    $widget->add_render_attribute( $data_counter, [
		        'class'          => [
		        	'cms-counter-number elementor-counter-number'
		        ],
		        'data-duration'  => $counter['duration'],
		        'data-to-value'  => $counter['ending_number'],
		        'data-delimiter' => !empty($counter['thousand_separator_char']) ? $counter['thousand_separator_char'] : ',',
		    ] );
		    // Items
		    $counter_item_key = $widget->get_repeater_setting_key( 'counter-item', 'cms_counter', $key );
			$widget->add_render_attribute( $counter_item_key,[
				'class' => [
					'counter-item',
					($settings['layout_mode'] === 'carousel') ? 'swiper-slide' : '',
					'hover-icon-bounce',
					'bdr-t-1 bdr-divider',
					($settings['layout_mode'] === 'grid' && $count == count($counters)) ? '' : 'bdr-r-1'
				]
			]);
		?>
		<div <?php etc_print_html($widget->get_render_attribute_string($counter_item_key)); ?>>
			<div class="counter--item p-tb-50">
				<?php
				    // Counter Icon
					finanzia_elementor_icon_image_render($widget, $settings, [
						'name'	  	  => 'counter_icon',
						'size'        => 48,
						'color'       => $widget->get_setting('icon_color', 'white'),
						'color_hover' => $widget->get_setting('icon_color', 'white'),
						'class'       => 'mb-40'
					], $counter);
				?>
				<div <?php etc_print_html($widget->get_render_attribute_string('counter--number')) ?>>
				    <span class="prefix"><?php echo esc_html( $counter['prefix'] ); ?></span>
				    <span <?php etc_print_html( $widget->get_render_attribute_string( $data_counter ) ); ?>><?php echo esc_html( $counter['starting_number'] ); ?></span>
				    <span class="suffix"><?php echo esc_html( $counter['suffix'] ); ?></span>
				</div>
				<?php if ( $counter['title'] ) : ?>
				    <div <?php etc_print_html($widget->get_render_attribute_string( 'title')); ?>><?php echo nl2br( $counter['title'] ); ?></div>
				<?php endif;
				// Description
				if ( $counter['description'] ) : ?>
				    <div <?php etc_print_html($widget->get_render_attribute_string( 'description')); ?>><?php echo nl2br( $counter['description'] ); ?></div>
				<?php endif; 
				// Link
				finanzia_elementor_link_render($widget, $counter, [
					'name'		=> 'link1_',
					'loop' 		=> true,
					'loop_key'  => $key,
					'color'		=> false,
					'class'     => ['cms-link', 'mt-25 mb-n7', 'text-15 font-700']		
				]);
				?>
			</div>
		</div>
		<?php
		} // end foreach

		switch ($settings['layout_mode']) {
			case 'carousel':
		?>
			</div>
		</div>
		<div class="cms-swiper-buttons-dots d-flex gap-20 align-items-center justify-content-between empty-none pt" style="--pt:23px;"><?php
	        // Dots
	        if ($dots == 'yes') { ?>
	            <div <?php etc_print_html($widget->get_render_attribute_string('dots')); ?>></div>
	        <?php } 
	        // Arrows
	        if ($arrows == 'yes'){ ?>
	            <div <?php etc_print_html($widget->get_render_attribute_string('arrows')); ?>><?php 
	                finanzia_elementor_icon_render(
	                    [], 
	                    [
	                        'library' => 'svg',
	                        'value'   => [
	                            'id'  => '',
	                            'url' => get_template_directory().'/assets/svgs/core/arrow-prev.svg'
	                        ]
	                    ], 
	                    [
	                        'class'     => $arrows_classes_prev,
	                        'icon_size' => 10
	                    ], 
	                    'div'
	                );
	                finanzia_elementor_icon_render(
	                    [], 
	                    [
	                        'library' => 'svg',
	                        'value'   => [
	                            'id'  => '',
	                            'url' => get_template_directory().'/assets/svgs/core/arrow-next.svg'
	                        ]
	                    ], 
	                    [
	                        'class'     => $arrows_classes_next,
	                        'icon_size' => 10
	                    ], 
	                    'div'
	                );
	            ?></div>
	        <?php } 
	    ?></div>
		<?php
			break;
			default:
		?>
		</div>
		<?php
			break;
		}
	// End Counter
	?>
</div>

