<?php
$icon_color = $widget->get_setting('icon_color','accent');
$small_title_color = $widget->get_setting('small_title_color','accent');
$title_color = $widget->get_setting('title_color','heading');
$desc_color = $widget->get_setting('desc_color','body');
$note_color = $widget->get_setting('note_color','body');

// Form
$label_color = $widget->get_setting('label_color','heading');
$field_height = !empty($widget->get_setting('form_field_height')['size']) ? $widget->get_setting('form_field_height')['size'].'px;' : '58px;';
$field_color = $widget->get_setting('field_color', 'body');
$placeholder_color = $widget->get_setting('placeholder_color','body');
$field_bg_color = $widget->get_setting('field_bg_color','transparent');
$field_bg_hover_color = $widget->get_setting('field_bg_hover_color','transparent');
$field_border_color = $widget->get_setting('field_border_color', 'divider');
$field_border_color_hover = $widget->get_setting('field_border_color_hover','accent');
$field_radius = !empty($widget->get_setting('form_field_radius')['size']) ? $widget->get_setting('form_field_radius')['size'].'px;' : '0;';

$field_checkbox_border = '0 0 0 2px var(--cms-'.$widget->get_setting('field_border_checkbox_color', 'accent').') inset;';
$field_seclect_arrow = 'url('.finanzia_elementor_image_src_render($settings, ['name' => 'field_select_arrow', 'echo'=>false, 'default' => false]).');';
$field_textarea_height = !empty($widget->get_setting('textarea_height')['size']) ? $widget->get_setting('textarea_height')['size'].'px;' : '108px;';

$form_btn_height =  !empty($widget->get_setting('form_btn_height')['size']) ? $widget->get_setting('form_btn_height')['size'].'px;' : '58px;';
$form_btn_color = 'var(--cms-'.$widget->get_setting('btn_color','white').');';
$form_btn_bg_color = 'var(--cms-'.$widget->get_setting('btn_bg_color','accent').');';
$form_btn_hover_color = 'var(--cms-'.$widget->get_setting('btn_hover_color','white').');';
$form_btn_bg_hover_color = 'var(--cms-'.$widget->get_setting('btn_bg_hover_color','accent').');';
$form_invalid_bg = $widget->get_setting('invalid_bg','grey');
$form_invalid_color = $widget->get_setting('invalid_color', 'primary');
// wrap
$widget->add_render_attribute('wrap', [
	'class' => [
		'cms-ecf7',
		'cms-ecf7-'.$settings['layout'],
		'bg-'.$widget->get_setting('bg_color','white'),
		$widget->get_setting('bg_backdrop'),
		'cms-shadow-5',
		'p-50 p-lr-smobile-20'
	],
	'style' => [
		'--cms-label-color:var(--cms-'.$label_color.');',
		'--cms-form-field-height:'.$field_height,
		'--cms-form-field-color:var(--cms-'.$field_color.');',
		'--cms-placeholder-color:var(--cms-'.$placeholder_color.');',
		'--cms-form-field-bg-color:var(--cms-'.$field_bg_color.');',
		'--cms-form-field-bg-hover-color:var(--cms-'.$field_bg_hover_color.');',
		'--cms-form-field-border-style: solid;',
		'--cms-form-field-border-width: 0 0 1px 0;',
		'--cms-form-field-border-color:var(--cms-'.$field_border_color.');',
		'--cms-form-field-border-color-hover:var(--cms-'.$field_border_color_hover.');',
		'--cms-form-field-radius:'.$field_radius,
		'--cms-form-field-border: none;',
		'--cms-form-field-border-hover:none;',
		'--cms-form-field-padding-start:10px;',
		'--cms-form-field-padding-end:10px;',
		'--cms-form-field-checkbox-border:'.$field_checkbox_border,
		'--cms-form-select-arrow:'.$field_seclect_arrow,
		'--cms-form-textarea-height:'.$field_textarea_height,
		'--cms-form-textarea-radius:0;',
		'--cms-form-btn-height:'.$form_btn_height,
		'--cms-form-btn-color:'.$form_btn_color,
		'--cms-form-btn-bg:'.$form_btn_bg_color,
		'--cms-form-btn-color-hover:'.$form_btn_hover_color,
		'--cms-form-btn-bg-hover:'.$form_btn_bg_hover_color,
		'--cms-invalid-bg:var(--cms-'.$form_invalid_bg.');',
		'--cms-invalid-color:var(--cms-'.$form_invalid_color.');'
	]
]);
// Small Title
$widget->add_inline_editing_attributes('ctf7_small_title');
$widget->add_render_attribute('ctf7_small_title',[
	'class' => [
		'cms-small-title empty-none',
		'font-500',
		'text-'.$small_title_color,
		'm-tb-n7 pb-20'
	]
]);
// title
$widget->add_inline_editing_attributes('ctf7_title');
$widget->add_render_attribute('ctf7_title',[
	'class' => [
		'cms-title cms-nl2br cms-heading empty-none',
		'text-26',
		'text-'.$title_color,
		'm-tb-n10 pb-30 pr-20 pr-tablet-extra-0'
	]
]);
// description
$widget->add_inline_editing_attributes('ctf7_description');
$widget->add_render_attribute('ctf7_description',[
	'class' => [
		'cms-desc empty-none',
		'text-15 text-'.$desc_color,
		'm-tb-n7 pb-30'
	]
]);
// note
$widget->add_inline_editing_attributes('ctf7_note');
$widget->add_render_attribute('ctf7_note',[
	'class' => [
		'cms-note empty-none',
		'text-15 font-italic text-'.$note_color,
		'm-tb-n7 pt-40'
	]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php 
		// Icon
		finanzia_elementor_icon_image_render($widget, $settings, [
			'name'         => 'ctf7_title_icon',
			'class'        => 'mb-30',
			'size'         => 64,
			'color'        => $icon_color,
			'icon_tag'     => 'div',
			'default_icon' => []
		]);
	?>
	<div <?php etc_print_html($widget->get_render_attribute_string('ctf7_small_title')); ?>><?php 
		etc_print_html($settings['ctf7_small_title']);
	?></div>
	<h2 <?php etc_print_html($widget->get_render_attribute_string('ctf7_title'));?>><?php
		// Text
		echo nl2br($settings['ctf7_title']); 
	?></h2>
	<div <?php etc_print_html($widget->get_render_attribute_string('ctf7_description')); ?>><?php 
		etc_print_html($settings['ctf7_description']);
	?></div>
	<?php
		echo do_shortcode('[contact-form-7 id="' . esc_attr($settings['ctf7_slug']) . '"]'); ?>
	<div <?php etc_print_html($widget->get_render_attribute_string('ctf7_note')); ?>><?php 
		echo nl2br($settings['ctf7_note']); 
	?></div>
</div>